% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rand-multiple.R
\encoding{UTF-8}
\name{rand}
\alias{rand}
\alias{crand}
\alias{rand2}
\alias{crand2}
\title{Comparing partitions on one or multiple sets of units}
\usage{
rand(clu1, clu2, tab)

crand(
  clu1,
  clu2,
  tab,
  multiSets = c("weights", "unlist"),
  weights = c("size", "equal"),
  returnIndividual = "attr"
)

rand2(clu1, clu2)

crand2(clu1, clu2)
}
\arguments{
\item{clu1}{The first of the two partitions to be compared, given in the form of vectors, where for each unit a cluster membership is given. Alternatively, this can be a contingency table obtained as a \code{table(clu1, clu2)}. If a partition, \code{clu2} must also be provided. In case of multiple sets, this should be pa list of partitions.}

\item{clu2}{If \code{clu1} is partition or a list of partitions, this must be a comaptible the second partition or list of partitions.}

\item{tab}{A contingency table obtained as a \code{table(clu1, clu2)}. This is included for back-compatibility reasons. If this is present, all other arguments are ignored.}

\item{multiSets}{How should we compute the index in case of multiple sets of unis (if \code{clu1} and  \code{clu2} are lists of partitions)? Possible values are "unlist" and "weight" (the default).}

\item{weights}{Weights to be used if \code{multiSets} is "weight". It can be "equal", "size" (default) or a numeric (non-negative) vector of the same length as the number of sets (the number of partitions in the list of partitions).}

\item{returnIndividual}{If \code{multiSets} is "weight", should the indices for individual sets be also returned.  If \code{TRUE}, the function returns a list instead of a single value. If the values is \code{"attr"} (the default), the indices by sets are given as an attribute \code{"bySets"}}
}
\value{
The value of Rand Index (corrected/adjusted for chance) unless \code{multiSets="weight"} and \code{returnIndividual=FALSE}. In this case, a list with two items is return. The "global" index is in \code{global}, while the the indices by sets are in \code{bySets}.
}
\description{
Rand Index and Rand Index corrected/adjusted for chance for comparing partitions (Hubert & Arabie, 1985). The functions also support computing these indices on partitions on multiple sets (where a "combined" partition is a list of multiple partitions).
The names of the clusters do not matter.
}
\references{
Hubert, L., & Arabie, P. (1985). Comparing Partitions. Journal of Classification, 2(1), 193-218.
}
\author{
\enc{Aleš Žiberna}{Ales Ziberna}
}
\keyword{cluster}
