% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distributions.R
\name{AsymLaplace}
\alias{AsymLaplace}
\alias{dasym_laplace}
\alias{pasym_laplace}
\alias{qasym_laplace}
\alias{rasym_laplace}
\title{The Asymmetric Laplace Distribution}
\usage{
dasym_laplace(x, mu = 0, sigma = 1, quantile = 0.5, log = FALSE)

pasym_laplace(
  q,
  mu = 0,
  sigma = 1,
  quantile = 0.5,
  lower.tail = TRUE,
  log.p = FALSE
)

qasym_laplace(
  p,
  mu = 0,
  sigma = 1,
  quantile = 0.5,
  lower.tail = TRUE,
  log.p = FALSE
)

rasym_laplace(n, mu = 0, sigma = 1, quantile = 0.5)
}
\arguments{
\item{x, q}{Vector of quantiles.}

\item{mu}{Vector of locations.}

\item{sigma}{Vector of scales.}

\item{quantile}{Asymmetry parameter corresponding to quantiles
in quantile regression (hence the name).}

\item{log}{Logical; If \code{TRUE}, values are returned on the log scale.}

\item{lower.tail}{Logical; If \code{TRUE} (default), return P(X <= x). 
Else, return P(X > x) .}

\item{log.p}{Logical; If \code{TRUE}, values are returned on the log scale.}

\item{p}{Vector of probabilities.}

\item{n}{Number of samples to draw from the distribution.}
}
\description{
Density, distribution function, quantile function and random generation 
for the asymmetric Laplace distribution with location \code{mu}, 
scale \code{sigma} and asymmetry parameter \code{quantile}.
}
\details{
See \code{vignette("brms_families")} for details
on the parameterization.
}
