% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggplot-themes.R
\name{theme_black}
\alias{theme_black}
\title{(Deprecated) Black Theme for \pkg{ggplot2} Graphics}
\usage{
theme_black(base_size = 12, base_family = "")
}
\arguments{
\item{base_size}{base font size}

\item{base_family}{base font family}
}
\value{
A \code{theme} object used in \pkg{ggplot2} graphics.
}
\description{
A black theme for ggplot graphics inspired by a blog post of Jon Lefcheck
(\url{https://jonlefcheck.net/2013/03/11/black-theme-for-ggplot2-2/}).
}
\details{
When using \code{theme_black} in plots powered by the
\pkg{bayesplot} package such as \code{pp_check} or \code{stanplot},
I recommend using the \code{"viridisC"} color scheme (see examples).
}
\examples{
\dontrun{
# change default ggplot theme
ggplot2::theme_set(theme_black())

# change default bayesplot color scheme
bayesplot::color_scheme_set("viridisC")

# fit a simple model
fit <- brm(count ~ zAge + zBase * Trt + (1|patient),
           data = epilepsy, family = poisson(), chains = 2)
summary(fit)
           
# create various plots
plot(marginal_effects(fit), ask = FALSE)
pp_check(fit)
stanplot(fit, type = "hex", pars = c("b_Intercept", "b_Trt1"))
}

}
