% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/base-tidiers.R
\name{tidy.table}
\alias{tidy.table}
\title{Tidy a(n) table object}
\usage{
\method{tidy}{table}(x, ...)
}
\arguments{
\item{x}{A \link[base:table]{base::table} object.}

\item{...}{Additional arguments. Not used. Needed to match generic
signature only. \strong{Cautionary note:} Misspelled arguments will be
absorbed in \code{...}, where they will be ignored. If the misspelled
argument has a default value, the default value will be used.
For example, if you pass \code{conf.lvel = 0.9}, all computation will
proceed using \code{conf.level = 0.95}. Two exceptions here are:
\itemize{
\item \code{tidy()} methods will warn when supplied an \code{exponentiate} argument if
it will be ignored.
\item \code{augment()} methods will warn when supplied a \code{newdata} argument if it
will be ignored.
}}
}
\value{
A \link[tibble:tibble]{tibble::tibble} in long-form containing frequency information
for the table in a \code{Freq} column. The result is much like what you get
from \code{\link[tidyr:pivot_longer]{tidyr::pivot_longer()}}.
}
\description{
Tidy summarizes information about the components of a model.
A model component might be a single term in a regression, a single
hypothesis, a cluster, or a class. Exactly what tidy considers to be a
model component varies across models but is usually self-evident.
If a model has several distinct types of components, you will need to
specify which components to return.

Deprecated. Please use \code{\link[tibble:as_tibble]{tibble::as_tibble()}} instead.
}
\details{
Directly calls \code{\link[tibble:as_tibble]{tibble::as_tibble()}} on a \link[base:table]{base::table} object.
}
\seealso{
\code{\link[tibble:as_tibble]{tibble::as_tibble.table()}}
}
