% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_grid_2d.R
\name{add_grid_2d}
\alias{add_grid_2d}
\title{Add a 2D grid of nodes to the graph}
\usage{
add_grid_2d(
  graph,
  x,
  y,
  type = NULL,
  label = TRUE,
  rel = NULL,
  node_aes = NULL,
  edge_aes = NULL,
  node_data = NULL,
  edge_data = NULL
)
}
\arguments{
\item{graph}{A graph object of class \code{dgr_graph}.}

\item{x}{The number of nodes in the x direction.}

\item{y}{The number of nodes in the y direction.}

\item{type}{An optional string that describes the entity type for the nodes
to be added.}

\item{label}{Either a vector object of length \code{x * y} that provides optional
labels for the new nodes, or, a logical value where setting to \code{TRUE}
ascribes node IDs to the label and \code{FALSE} yields a blank label.}

\item{rel}{An optional string for providing a relationship label to all new
edges created in the grid.}

\item{node_aes}{An optional list of named vectors comprising node aesthetic
attributes. The helper function \code{\link[=node_aes]{node_aes()}} is strongly recommended for
use here as it contains arguments for each of the accepted node aesthetic
attributes (e.g., \code{shape}, \code{style}, \code{color}, \code{fillcolor}).}

\item{edge_aes}{An optional list of named vectors comprising edge aesthetic
attributes. The helper function \code{\link[=edge_aes]{edge_aes()}} is strongly recommended for
use here as it contains arguments for each of the accepted edge aesthetic
attributes (e.g., \code{shape}, \code{style}, \code{penwidth}, \code{color}).}

\item{node_data}{An optional list of named vectors comprising node data
attributes. The helper function \code{\link[=node_data]{node_data()}} is strongly recommended for
use here as it helps bind data specifically to the created nodes.}

\item{edge_data}{An optional list of named vectors comprising edge data
attributes. The helper function \code{\link[=edge_data]{edge_data()}} is strongly recommended for
use here as it helps bind data specifically to the created edges.}
}
\value{
A graph object of class \code{dgr_graph}.
}
\description{
With a graph object of class \code{dgr_graph}, add a two-dimensional grid to the
graph.
}
\examples{
# Create a new graph and add
# a 3 x 3 grid
graph <-
  create_graph() \%>\%
  add_grid_2d(
    x = 3, y = 3,
    type = "grid")

# Get node information
# from this graph
graph \%>\%
  get_node_info()

# Attributes can be specified
# in extra arguments and these
# are applied in order; Usually
# these attributes are applied
# to nodes (e.g., `type` is a
# node attribute) but the `rel`
# attribute will apply to the
# edges
graph_w_attrs <-
  create_graph() \%>\%
  add_grid_2d(
    x = 3, y = 2,
    label = c("one", "two",
              "three", "four",
              "five", "six"),
    type = c("a", "a",
             "b", "b",
             "c", "c"),
    rel = "grid",
    node_data = node_data(
      value = c(
        1.2, 8.4, 3.4,
        5.2, 6.1, 2.6)))

# Get the graph's node data frame
graph_w_attrs \%>\% get_node_df()

# Get the graph's edge data frame
graph_w_attrs \%>\% get_edge_df()

}
