% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_nodes_from_table.R
\name{add_nodes_from_table}
\alias{add_nodes_from_table}
\title{Add nodes and attributes to graph from a table}
\usage{
add_nodes_from_table(
  graph,
  table,
  label_col = NULL,
  type_col = NULL,
  set_type = NULL,
  drop_cols = NULL
)
}
\arguments{
\item{graph}{A graph object of class \code{dgr_graph}.}

\item{table}{Either a path to a CSV file, or, a data frame object.}

\item{label_col}{An option to apply a column of data in the table as \code{label}
attribute values.}

\item{type_col}{An option to apply a column of data in the table as \code{type}
attribute values.}

\item{set_type}{An optional string to apply a \code{type} attribute to all nodes
created from data in the external table.}

\item{drop_cols}{An optional column selection statement for dropping columns
from the external table before inclusion as attributes in the graph's
internal node data frame. Several columns can be dropped by name using the
syntax \code{col_1 & col_2 & ...}. Columns can also be dropped using a numeric
column range with \code{:} (e.g., \code{5:8}), or, by using the \code{:} between column
names to specify the range (e.g., \code{col_5_name:col_8_name}).}
}
\value{
A graph object of class \code{dgr_graph}.
}
\description{
Add nodes and their attributes to an existing graph object from data in a CSV
file or a data frame.
}
\examples{
# To add nodes from the dataset called
# `currencies` (available as a dataset
# in the package), call the
# `add_nodes_from_table()` function
# after creating an empty graph; new
# node ID values will be created as
# monotonically-increasing values
graph_1 <-
  create_graph() \%>\%
  add_nodes_from_table(
    table = currencies)

# View part of the graph's internal
# node data frame (ndf)
graph_1 \%>\%
  get_node_df() \%>\%
  .[, 1:5] \%>\%
  head()

# If you would like to assign
# any of the table's columns as
# `type` or `label` attributes,
# this can be done with the `type_col`
# and `label_col` arguments; to set
# a static `type` attribute for all
# of the table records, use `set_type`
graph_2 <-
  create_graph() \%>\%
  add_nodes_from_table(
    table = currencies,
    label_col = iso_4217_code,
    set_type = currency)

# View part of the graph's internal ndf
graph_2 \%>\%
  get_node_df() \%>\%
  .[, 1:5] \%>\%
  head()

# Suppose we would like to not
# include certain columns from the
# external table in the resulting
# graph; we can use the `drop_cols`
# argument to choose which columns
# to not include as attributes
graph_3 <-
  create_graph() \%>\%
  add_nodes_from_table(
    table = currencies,
    label_col = iso_4217_code,
    set_type = currency,
    drop_cols = exponent & currency_name)

# Show the node attribute names
# for the graph; note that the
# `exponent` and `currency_name`
# columns are not attributes in the
# graph's internal node data frame
graph_3 \%>\%
  get_node_df() \%>\%
  colnames()

}
\seealso{
Other node creation and removal: 
\code{\link{add_n_node_clones}()},
\code{\link{add_n_nodes}()},
\code{\link{add_n_nodes_ws}()},
\code{\link{add_node}()},
\code{\link{add_node_clones_ws}()},
\code{\link{add_node_df}()},
\code{\link{add_nodes_from_df_cols}()},
\code{\link{colorize_node_attrs}()},
\code{\link{copy_node_attrs}()},
\code{\link{create_node_df}()},
\code{\link{delete_node}()},
\code{\link{delete_nodes_ws}()},
\code{\link{drop_node_attrs}()},
\code{\link{join_node_attrs}()},
\code{\link{layout_nodes_w_string}()},
\code{\link{mutate_node_attrs}()},
\code{\link{mutate_node_attrs_ws}()},
\code{\link{node_data}()},
\code{\link{recode_node_attrs}()},
\code{\link{rename_node_attrs}()},
\code{\link{rescale_node_attrs}()},
\code{\link{set_node_attr_to_display}()},
\code{\link{set_node_attr_w_fcn}()},
\code{\link{set_node_attrs}()},
\code{\link{set_node_attrs_ws}()},
\code{\link{set_node_position}()}
}
\concept{node creation and removal}
