% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_closeness_vitality.R
\name{get_closeness_vitality}
\alias{get_closeness_vitality}
\title{Get closeness vitality}
\usage{
get_closeness_vitality(graph)
}
\arguments{
\item{graph}{A graph object of class \code{dgr_graph}.}
}
\value{
A data frame with closeness vitality values for each of the nodes.
}
\description{
Get the closeness vitality values for all nodes in the graph.
}
\examples{
# Create a random graph using the
# `add_gnm_graph()` function
graph <-
  create_graph() \%>\%
  add_gnm_graph(
    n = 10,
    m = 12,
    set_seed = 23)

# Get closeness vitality values
# for all nodes in the graph
graph \%>\% get_closeness_vitality()

# Add the closeness vitality
# values to the graph as a
# node attribute
graph <-
  graph \%>\%
  join_node_attrs(
    df = get_closeness_vitality(.))

# Display the graph's
# node data frame
graph \%>\% get_node_df()

}
