% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/group-split.R
\name{group_split}
\alias{group_split}
\title{Split data frame by groups}
\usage{
group_split(.tbl, ..., .keep = TRUE)
}
\arguments{
\item{.tbl}{A tbl.}

\item{...}{If \code{.tbl} is an ungrouped data frame, a grouping specification,
forwarded to \code{\link[=group_by]{group_by()}}.}

\item{.keep}{Should the grouping columns be kept?}
}
\value{
A list of tibbles. Each tibble contains the rows of \code{.tbl} for the
associated group and all the columns, including the grouping variables.
Note that this returns a \link[vctrs:list_of]{list_of} which is slightly
stricter than a simple list but is useful for representing lists where
every element has the same type.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

\code{\link[=group_split]{group_split()}} works like \code{\link[base:split]{base::split()}} but:
\itemize{
\item It uses the grouping structure from \code{\link[=group_by]{group_by()}} and therefore is subject
to the data mask
\item It does not name the elements of the list based on the grouping as this
only works well for a single character grouping variable. Instead,
use \code{\link[=group_keys]{group_keys()}} to access a data frame that defines the groups.
}

\code{group_split()} is primarily designed to work with grouped data frames.
You can pass \code{...} to group and split an ungrouped data frame, but this
is generally not very useful as you want have easy access to the group
metadata.
}
\section{Lifecycle}{

\code{group_split()} is not stable because you can achieve very similar results by
manipulating the nested column returned from
\code{\link[tidyr:nest]{tidyr::nest(.by =)}}. That also retains the group keys all
within a single data structure. \code{group_split()} may be deprecated in the
future.
}

\examples{
ir <- iris \%>\% group_by(Species)

group_split(ir)
group_keys(ir)
}
\seealso{
Other grouping functions: 
\code{\link{group_by}()},
\code{\link{group_map}()},
\code{\link{group_nest}()},
\code{\link{group_trim}()}
}
\concept{grouping functions}
\keyword{internal}
