% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nest-by.R
\name{nest_by}
\alias{nest_by}
\title{Nest by one or more variables}
\usage{
nest_by(.data, ..., .key = "data", .keep = FALSE)
}
\arguments{
\item{.data}{A data frame, data frame extension (e.g. a tibble), or a
lazy data frame (e.g. from dbplyr or dtplyr). See \emph{Methods}, below, for
more details.}

\item{...}{In \code{group_by()}, variables or computations to group by.
Computations are always done on the ungrouped data frame.
To perform computations on the grouped data, you need to use
a separate \code{mutate()} step before the \code{group_by()}.
Computations are not allowed in \code{nest_by()}.
In \code{ungroup()}, variables to remove from the grouping.}

\item{.key}{Name of the list column}

\item{.keep}{Should the grouping columns be kept in the list column.}
}
\value{
A \link{rowwise} data frame. The output has the following properties:
\itemize{
\item The rows come from the underlying \code{\link[=group_keys]{group_keys()}}.
\item The columns are the grouping keys plus one list-column of data frames.
\item Data frame attributes are \strong{not} preserved, because \code{nest_by()}
fundamentally creates a new data frame.
}

A tbl with one row per unique combination of the grouping variables.
The first columns are the grouping variables, followed by a list column of tibbles
with matching rows of the remaining columns.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

\code{nest_by()} is closely related to \code{\link[=group_by]{group_by()}}. However, instead of storing
the group structure in the metadata, it is made explicit in the data,
giving each group key a single row along with a list-column of data frames
that contain all the other data.

\code{nest_by()} returns a \link{rowwise} data frame, which makes operations on the
grouped data particularly elegant. See \code{vignette("rowwise")} for more
details.
}
\details{
Note that \code{df \%>\% nest_by(x, y)} is roughly equivalent to

\if{html}{\out{<div class="sourceCode">}}\preformatted{df \%>\%
  group_by(x, y) \%>\%
  summarise(data = list(pick(everything()))) \%>\%
  rowwise()
}\if{html}{\out{</div>}}

If you want to unnest a nested data frame, you can either use
\code{tidyr::unnest()} or take advantage of \code{reframe()}s multi-row behaviour:

\if{html}{\out{<div class="sourceCode">}}\preformatted{nested \%>\%
  reframe(data)
}\if{html}{\out{</div>}}
}
\section{Lifecycle}{

\code{nest_by()} is not stable because \code{\link[tidyr:nest]{tidyr::nest(.by =)}}
provides very similar behavior. It may be deprecated in the future.
}

\section{Methods}{

This function is a \strong{generic}, which means that packages can provide
implementations (methods) for other classes. See the documentation of
individual methods for extra arguments and differences in behaviour.

The following methods are currently available in loaded packages:
\Sexpr[stage=render,results=rd]{dplyr:::methods_rd("nest_by")}.
}

\examples{
# After nesting, you get one row per group
iris \%>\% nest_by(Species)
starwars \%>\% nest_by(species)

# The output is grouped by row, which makes modelling particularly easy
models <- mtcars \%>\%
  nest_by(cyl) \%>\%
  mutate(model = list(lm(mpg ~ wt, data = data)))
models

models \%>\% summarise(rsq = summary(model)$r.squared)
\dontshow{if (requireNamespace("broom", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}

# This is particularly elegant with the broom functions
models \%>\% summarise(broom::glance(model))
models \%>\% reframe(broom::tidy(model))
\dontshow{\}) # examplesIf}

# Note that you can also `reframe()` to unnest the data
models \%>\% reframe(data)
}
\keyword{internal}
