% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/join.R
\name{nest_join}
\alias{nest_join}
\alias{nest_join.data.frame}
\title{Nest join}
\usage{
nest_join(x, y, by = NULL, copy = FALSE, keep = NULL, name = NULL, ...)

\method{nest_join}{data.frame}(
  x,
  y,
  by = NULL,
  copy = FALSE,
  keep = NULL,
  name = NULL,
  ...,
  na_matches = c("na", "never"),
  unmatched = "drop"
)
}
\arguments{
\item{x, y}{A pair of data frames, data frame extensions (e.g. a tibble), or
lazy data frames (e.g. from dbplyr or dtplyr). See \emph{Methods}, below, for
more details.}

\item{by}{A join specification created with \code{\link[=join_by]{join_by()}}, or a character
vector of variables to join by.

If \code{NULL}, the default, \verb{*_join()} will perform a natural join, using all
variables in common across \code{x} and \code{y}. A message lists the variables so
that you can check they're correct; suppress the message by supplying \code{by}
explicitly.

To join on different variables between \code{x} and \code{y}, use a \code{\link[=join_by]{join_by()}}
specification. For example, \code{join_by(a == b)} will match \code{x$a} to \code{y$b}.

To join by multiple variables, use a \code{\link[=join_by]{join_by()}} specification with
multiple expressions. For example, \code{join_by(a == b, c == d)} will match
\code{x$a} to \code{y$b} and \code{x$c} to \code{y$d}. If the column names are the same between
\code{x} and \code{y}, you can shorten this by listing only the variable names, like
\code{join_by(a, c)}.

\code{\link[=join_by]{join_by()}} can also be used to perform inequality, rolling, and overlap
joins. See the documentation at \link[=join_by]{?join_by} for details on
these types of joins.

For simple equality joins, you can alternatively specify a character vector
of variable names to join by. For example, \code{by = c("a", "b")} joins \code{x$a}
to \code{y$a} and \code{x$b} to \code{y$b}. If variable names differ between \code{x} and \code{y},
use a named character vector like \code{by = c("x_a" = "y_a", "x_b" = "y_b")}.

To perform a cross-join, generating all combinations of \code{x} and \code{y}, see
\code{\link[=cross_join]{cross_join()}}.}

\item{copy}{If \code{x} and \code{y} are not from the same data source,
and \code{copy} is \code{TRUE}, then \code{y} will be copied into the
same src as \code{x}.  This allows you to join tables across srcs, but
it is a potentially expensive operation so you must opt into it.}

\item{keep}{Should the new list-column contain join keys? The default
will preserve the join keys for inequality joins.}

\item{name}{The name of the list-column created by the join. If \code{NULL},
the default, the name of \code{y} is used.}

\item{...}{Other parameters passed onto methods.}

\item{na_matches}{Should two \code{NA} or two \code{NaN} values match?
\itemize{
\item \code{"na"}, the default, treats two \code{NA} or two \code{NaN} values as equal, like
\code{\%in\%}, \code{\link[=match]{match()}}, and \code{\link[=merge]{merge()}}.
\item \code{"never"} treats two \code{NA} or two \code{NaN} values as different, and will
never match them together or to any other values. This is similar to joins
for database sources and to \code{base::merge(incomparables = NA)}.
}}

\item{unmatched}{How should unmatched keys that would result in dropped rows
be handled?
\itemize{
\item \code{"drop"} drops unmatched keys from the result.
\item \code{"error"} throws an error if unmatched keys are detected.
}

\code{unmatched} is intended to protect you from accidentally dropping rows
during a join. It only checks for unmatched keys in the input that could
potentially drop rows.
\itemize{
\item For left joins, it checks \code{y}.
\item For right joins, it checks \code{x}.
\item For inner joins, it checks both \code{x} and \code{y}. In this case, \code{unmatched} is
also allowed to be a character vector of length 2 to specify the behavior
for \code{x} and \code{y} independently.
}}
}
\value{
The output:
\itemize{
\item Is same type as \code{x} (including having the same groups).
\item Has exactly the same number of rows as \code{x}.
\item Contains all the columns of \code{x} in the same order with the same values.
They are only modified (slightly) if \code{keep = FALSE}, when columns listed
in \code{by} will be coerced to their common type across \code{x} and \code{y}.
\item Gains one new column called \code{{name}} on the far right, a list column
containing data frames the same type as \code{y}.
}
}
\description{
A nest join leaves \code{x} almost unchanged, except that it adds a new
list-column, where each element contains the rows from \code{y} that match the
corresponding row in \code{x}.
}
\section{Relationship to other joins}{
You can recreate many other joins from the result of a nest join:
\itemize{
\item \code{\link[=inner_join]{inner_join()}} is a \code{nest_join()} plus \code{\link[tidyr:unnest]{tidyr::unnest()}}.
\item \code{\link[=left_join]{left_join()}} is a \code{nest_join()} plus \code{tidyr::unnest(keep_empty = TRUE)}.
\item \code{\link[=semi_join]{semi_join()}} is a \code{nest_join()} plus a \code{filter()} where you check
that every element of data has at least one row.
\item \code{\link[=anti_join]{anti_join()}} is a \code{nest_join()} plus a \code{filter()} where you check that every
element has zero rows.
}
}

\section{Methods}{

This function is a \strong{generic}, which means that packages can provide
implementations (methods) for other classes. See the documentation of
individual methods for extra arguments and differences in behaviour.

The following methods are currently available in loaded packages:
\Sexpr[stage=render,results=rd]{dplyr:::methods_rd("nest_join")}.
}

\examples{
df1 <- tibble(x = 1:3)
df2 <- tibble(x = c(2, 3, 3), y = c("a", "b", "c"))

out <- nest_join(df1, df2)
out
out$df2
}
\seealso{
Other joins: 
\code{\link{cross_join}()},
\code{\link{filter-joins}},
\code{\link{mutate-joins}}
}
\concept{joins}
