% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert_between_xtabcorr.R
\name{w_to_fei}
\alias{w_to_fei}
\alias{w_to_v}
\alias{w_to_t}
\alias{w_to_c}
\alias{fei_to_w}
\alias{v_to_w}
\alias{t_to_w}
\alias{c_to_w}
\alias{v_to_t}
\alias{t_to_v}
\title{Convert Between Effect Sizes for Contingency Tables Correlations}
\usage{
w_to_fei(w, p)

w_to_v(w, nrow, ncol)

w_to_t(w, nrow, ncol)

w_to_c(w)

fei_to_w(fei, p)

v_to_w(v, nrow, ncol)

t_to_w(t, nrow, ncol)

c_to_w(c)

v_to_t(v, nrow, ncol)

t_to_v(t, nrow, ncol)
}
\arguments{
\item{w, c, v, t, fei}{Effect size to be converted}

\item{p}{Vector of expected values. See \code{\link[stats:chisq.test]{stats::chisq.test()}}.}

\item{nrow, ncol}{The number of rows/columns in the contingency table.}
}
\description{
Enables a conversion between different indices of effect size, such as
Cohen's \emph{w} to \ifelse{latex}{\eqn{Fei}}{פ (Fei)}, and Cramer's \emph{V} to
Tschuprow's \emph{T}.
}
\examples{
library(effectsize)

## 2D tables
## ---------
data("Music_preferences2")
Music_preferences2

cramers_v(Music_preferences2, adjust = FALSE)

v_to_t(0.80, 3, 4)

tschuprows_t(Music_preferences2)



## Goodness of fit
## ---------------
data("Smoking_FASD")
Smoking_FASD

cohens_w(Smoking_FASD, p = c(0.015, 0.010, 0.975))

w_to_fei(0.11, p = c(0.015, 0.010, 0.975))

fei(Smoking_FASD, p = c(0.015, 0.010, 0.975))

\dontshow{if (require(pwr)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
## Power analysis
## --------------
# See https://osf.io/cg64s/

p0 <- c(0.35, 0.65)
Fei <- 0.3

pwr::pwr.chisq.test(
  w = fei_to_w(Fei, p = p0),
  df = length(p0) - 1,
  sig.level = 0.01,
  power = 0.85
)
\dontshow{\}) # examplesIf}
}
\references{
\itemize{
\item Ben-Shachar, M.S., Patil, I., Thériault, R., Wiernik, B.M., Lüdecke, D.
(2023). Phi, Fei, Fo, Fum: Effect Sizes for Categorical Data That Use the
Chi‑Squared Statistic. Mathematics, 11, 1982. \doi{10.3390/math11091982}
\item Cohen, J. (1988). Statistical power analysis for the behavioral sciences (2nd Ed.). New York: Routledge.
}
}
\seealso{
\code{\link[=cramers_v]{cramers_v()}} \code{\link[=chisq_to_fei]{chisq_to_fei()}}

Other convert between effect sizes: 
\code{\link{d_to_r}()},
\code{\link{diff_to_cles}},
\code{\link{eta2_to_f2}()},
\code{\link{odds_to_probs}()},
\code{\link{oddsratio_to_riskratio}()}
}
\concept{convert between effect sizes}
