% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/header-mail.R
\name{response}
\alias{response}
\alias{inreplyto}
\alias{references}
\title{Add In-Reply-To and References header fields}
\usage{
inreplyto(msg, msgid, subject_prefix = "Re: ")

references(msg, msgid, subject_prefix = "Re: ")
}
\arguments{
\item{msg}{A message object.}

\item{msgid}{A message ID. This would be the contents of the \code{Message-ID}
field from another message.}

\item{subject_prefix}{Prefix to add to subject. If specified will be prepended
onto the \code{Subject} field. Set to \code{NULL} if not required.}
}
\value{
A message object.
}
\description{
Add In-Reply-To and References header fields
}
\examples{
envelope() \%>\% inreplyto("<6163c08e.1c69fb81.65b78.183c@mx.google.com>")
# Now for German.
envelope() \%>\%
  inreplyto("6163c08e.1c69fb81.65b78.183c@mx.google.com", "AW: ")
# And also for Danish, Norwegian and Swedish (but not Finnish!).
envelope() \%>\%
  references("6163c08e.1c69fb81.65b78.183c@mx.google.com", "SV: ")
}
