% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/styles.R
\name{line_spacing}
\alias{line_spacing}
\title{Set text alignment}
\usage{
line_spacing(x, i = NULL, j = NULL, space = 1, part = "body")
}
\arguments{
\item{x}{a flextable object}

\item{i}{rows selection}

\item{j}{columns selection}

\item{space}{space between lines of text, 1 is single line spacing, 2 is double line spacing.}

\item{part}{partname of the table (one of 'all', 'body', 'header', 'footer')}
}
\description{
change text alignment of selected rows and columns of a flextable.
}
\section{Illustrations}{


\if{html}{\figure{fig_line_spacing_1.png}{options: width="400"}}
}

\examples{
ft <- flextable(head(mtcars)[, 3:6])
ft <- line_spacing(ft, space = 1.6, part = "all")
ft <- set_table_properties(ft, layout = "autofit")
ft
}
\seealso{
Other sugar functions for table style: 
\code{\link{align}()},
\code{\link{bg}()},
\code{\link{bold}()},
\code{\link{color}()},
\code{\link{empty_blanks}()},
\code{\link{fontsize}()},
\code{\link{font}()},
\code{\link{highlight}()},
\code{\link{italic}()},
\code{\link{padding}()},
\code{\link{rotate}()},
\code{\link{valign}()}
}
\concept{sugar functions for table style}
