% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_flextable.R
\name{as_flextable.lm}
\alias{as_flextable.lm}
\title{Transform a 'lm' object into a flextable}
\usage{
\method{as_flextable}{lm}(x, ...)
}
\arguments{
\item{x}{lm model}

\item{...}{unused argument}
}
\description{
produce a flextable describing a
linear model produced by function \code{lm}.

You can remove significance stars by setting options
\code{options(show.signif.stars = FALSE)}.
}
\examples{
if (require("broom")) {
  lmod <- lm(rating ~ complaints + privileges +
    learning + raises + critical, data = attitude)
  ft <- as_flextable(lmod)
  ft
}
}
\seealso{
Other as_flextable methods: 
\code{\link{as_flextable}()},
\code{\link{as_flextable.data.frame}()},
\code{\link{as_flextable.gam}()},
\code{\link{as_flextable.glm}()},
\code{\link{as_flextable.grouped_data}()},
\code{\link{as_flextable.htest}()},
\code{\link{as_flextable.kmeans}()},
\code{\link{as_flextable.merMod}()},
\code{\link{as_flextable.pam}()},
\code{\link{as_flextable.summarizor}()},
\code{\link{as_flextable.table}()},
\code{\link{as_flextable.tabular}()},
\code{\link{as_flextable.tabulator}()},
\code{\link{as_flextable.xtable}()}
}
\concept{as_flextable methods}
