% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom_edge_tile.R
\name{geom_edge_tile}
\alias{geom_edge_tile}
\title{Draw edges as glyphs}
\usage{
geom_edge_tile(
  mapping = NULL,
  data = get_edges(),
  position = "identity",
  mirror = FALSE,
  show.legend = NA,
  ...
)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[ggplot2:aes]{ggplot2::aes()}}
or \code{\link[ggplot2:aes_]{ggplot2::aes_()}}. By default x, y, xend, yend, group and
circular are mapped to x, y, xend, yend, edge.id and circular in the edge
data.}

\item{data}{The return of a call to \code{get_edges()} or a data.frame
giving edges in correct format (see details for for guidance on the format).
See \code{\link[=get_edges]{get_edges()}} for more details on edge extraction.}

\item{position}{Position adjustment, either as a string naming the adjustment
(e.g. \code{"jitter"} to use \code{position_jitter}), or the result of a call to a
position adjustment function. Use the latter if you need to change the
settings of the adjustment.}

\item{mirror}{Logical. Should edge points be duplicated on both sides of the
diagonal. Intended for undirected graphs. Default to \code{FALSE}}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.
It can also be a named logical vector to finely select the aesthetics to
display.}

\item{...}{Other arguments passed on to \code{\link[ggplot2:layer]{layer()}}. These are
often aesthetics, used to set an aesthetic to a fixed value, like
\code{colour = "red"} or \code{size = 3}. They may also be parameters
to the paired geom/stat.}
}
\description{
This geom draws edges as tiles with their x-position defined by the
x-position of the start node, and the y-position defined by the y-position of
the end node. As such it will result in a matrix layout when used in
conjunction with \code{\link[=layout_tbl_graph_matrix]{layout_tbl_graph_matrix()}}
}
\section{Aesthetics}{

\code{geom_edge_tile} understands the following
aesthetics. Bold aesthetics are automatically set, but can be overridden.
\itemize{
\item \strong{x}
\item \strong{y}
\item edge_fill
\item edge_colour
\item edge_size
\item edge_alpha
\item filter
}
}

\section{Edge aesthetic name expansion}{

In order to avoid excessive typing edge aesthetic names are
automatically expanded. Because of this it is not necessary to write
\code{edge_colour} within the \code{aes()} call as \code{colour} will
automatically be renamed appropriately.
}

\examples{
require(tidygraph)
gr <- create_notable('zachary') \%>\%
  mutate(group = group_infomap()) \%>\%
  morph(to_split, group) \%>\%
  activate(edges) \%>\%
  mutate(edge_group = as.character(.N()$group[1])) \%>\%
  unmorph()

ggraph(gr, 'matrix', sort.by = node_rank_hclust()) +
  geom_edge_tile(aes(fill = edge_group), mirror = TRUE) +
  scale_y_reverse() +
  coord_fixed() +
  labs(edge_colour = 'Infomap Cluster') +
  ggtitle("Zachary' Karate Club")
}
\seealso{
Other geom_edge_*: 
\code{\link{geom_edge_arc}()},
\code{\link{geom_edge_bend}()},
\code{\link{geom_edge_density}()},
\code{\link{geom_edge_diagonal}()},
\code{\link{geom_edge_elbow}()},
\code{\link{geom_edge_fan}()},
\code{\link{geom_edge_hive}()},
\code{\link{geom_edge_link}()},
\code{\link{geom_edge_loop}()},
\code{\link{geom_edge_parallel}()},
\code{\link{geom_edge_point}()},
\code{\link{geom_edge_span}()}
}
\author{
Thomas Lin Pedersen
}
\concept{geom_edge_*}
