% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/discrete-startrek.R
\name{pal_startrek}
\alias{pal_startrek}
\title{Star Trek color palettes}
\usage{
pal_startrek(palette = c("uniform"), alpha = 1)
}
\arguments{
\item{palette}{Palette type.
Currently there is one available option: \code{"uniform"}
(7-color palette).}

\item{alpha}{Transparency level, a real number in (0, 1].
See \code{alpha} in \code{\link[grDevices:rgb]{grDevices::rgb()}} for details.}
}
\description{
Color palettes inspired by the colors used in \emph{Star Trek}.
}
\examples{
library("scales")
show_col(pal_startrek("uniform")(7))
show_col(pal_startrek("uniform", alpha = 0.6)(7))
}
\author{
Nan Xiao | \email{me@nanx.me} | \url{https://nanx.me}
}
