% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/continuous-bs5.R
\name{scale_color_bs5}
\alias{scale_color_bs5}
\alias{scale_colour_bs5}
\alias{scale_fill_bs5}
\title{Bootstrap 5 color scales}
\usage{
scale_color_bs5(
  palette = c("blue", "indigo", "purple", "pink", "red", "orange", "yellow", "green",
    "teal", "cyan", "gray"),
  alpha = 1,
  reverse = FALSE,
  ...
)

scale_colour_bs5(
  palette = c("blue", "indigo", "purple", "pink", "red", "orange", "yellow", "green",
    "teal", "cyan", "gray"),
  alpha = 1,
  reverse = FALSE,
  ...
)

scale_fill_bs5(
  palette = c("blue", "indigo", "purple", "pink", "red", "orange", "yellow", "green",
    "teal", "cyan", "gray"),
  alpha = 1,
  reverse = FALSE,
  ...
)
}
\arguments{
\item{palette}{Palette type. There are 11 available options:
\itemize{
\item \code{"blue"}
\item \code{"indigo"}
\item \code{"purple"}
\item \code{"pink"}
\item \code{"red"}
\item \code{"orange"}
\item \code{"yellow"}
\item \code{"green"}
\item \code{"teal"}
\item \code{"cyan"}
\item \code{"gray"}
}}

\item{alpha}{Transparency level, a real number in (0, 1].
See \code{alpha} in \code{\link[grDevices:rgb]{grDevices::rgb()}} for details.}

\item{reverse}{Logical. Should the order of the colors be reversed?}

\item{...}{Additional parameters for \code{\link[ggplot2:discrete_scale]{ggplot2::discrete_scale()}}.}
}
\description{
See \code{\link[=pal_bs5]{pal_bs5()}} for details.
}
\examples{
library("ggplot2")

data("mtcars")
cor <- abs(cor(mtcars))
cor_melt <- data.frame(
  Var1 = rep(seq_len(nrow(cor)), times = ncol(cor)),
  Var2 = rep(seq_len(ncol(cor)), each = nrow(cor)),
  value = as.vector(cor)
)

ggplot(
  cor_melt,
  aes(x = Var1, y = Var2, fill = value)
) +
  geom_tile(colour = "black", size = 0.3) +
  theme_bw() +
  scale_fill_bs5("teal")
}
\author{
Nan Xiao | \email{me@nanx.me} | \url{https://nanx.me}
}
