% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/resp-headers.R
\name{resp_link_url}
\alias{resp_link_url}
\title{Parse link URL from a response}
\usage{
resp_link_url(resp, rel)
}
\arguments{
\item{resp}{A httr2 \link{response} object, created by \code{\link[=req_perform]{req_perform()}}.}

\item{rel}{The "link relation type" value for which to retrieve a URL.}
}
\value{
Either a string providing a URL, if the specified \code{rel} exists, or
\code{NULL} if not.
}
\description{
Parses URLs out of the the \code{Link} header as defined by \href{https://datatracker.ietf.org/doc/html/rfc8288}{RFC 8288}.
}
\examples{
# Simulate response from GitHub code search
resp <- response(headers = paste0("Link: ",
  '<https://api.github.com/search/code?q=addClass+user\%3Amozilla&page=2>; rel="next",',
  '<https://api.github.com/search/code?q=addClass+user\%3Amozilla&page=34>; rel="last"'
))

resp_link_url(resp, "next")
resp_link_url(resp, "last")
resp_link_url(resp, "prev")
}
