% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/operators.R
\name{reverse_edges}
\alias{reverse_edges}
\alias{t.igraph}
\title{Reverse edges in a graph}
\usage{
reverse_edges(graph, eids = E(graph))

\method{t}{igraph}(x)
}
\arguments{
\item{graph}{The input graph.}

\item{eids}{The edge IDs of the edges to reverse.}

\item{x}{The input graph.}
}
\value{
The result graph where the direction of the edges with the given
  IDs are reversed
}
\description{
The new graph will contain the same vertices, edges and attributes as
the original graph, except that the direction of the edges selected by
their edge IDs in the \code{eids} argument will be reversed. When reversing
all edges, this operation is also known as graph transpose.
}
\examples{

g <- make_graph( ~ 1-+2, 2-+3, 3-+4 )
reverse_edges(g, 2)
}
