% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phreg.R
\name{basehazplot.phreg}
\alias{basehazplot.phreg}
\alias{bplot}
\alias{basecumhaz}
\alias{plotConfRegion}
\alias{plotConfRegionSE}
\alias{plotstrata}
\title{Plotting the baslines of stratified Cox}
\usage{
basehazplot.phreg(
  x,
  se = FALSE,
  time = NULL,
  add = FALSE,
  ylim = NULL,
  xlim = NULL,
  lty = NULL,
  col = NULL,
  legend = TRUE,
  ylab = NULL,
  xlab = NULL,
  polygon = TRUE,
  level = 0.95,
  stratas = NULL,
  robust = FALSE,
  ...
)
}
\arguments{
\item{x}{phreg object}

\item{se}{to include standard errors}

\item{time}{to plot for specific time variables}

\item{add}{to add to previous plot}

\item{ylim}{to give ylim}

\item{xlim}{to give xlim}

\item{lty}{to specify lty of components}

\item{col}{to specify col of components}

\item{legend}{to specify col of components}

\item{ylab}{to specify ylab}

\item{xlab}{to specify xlab}

\item{polygon}{to get standard error in shaded form}

\item{level}{of standard errors}

\item{stratas}{wich strata to plot}

\item{robust}{to use robust standard errors if possible}

\item{...}{Additional arguments to lower level funtions}
}
\description{
Plotting the baslines of stratified Cox
}
\examples{
data(TRACE)
dcut(TRACE) <- ~.
out1 <- phreg(Surv(time,status==9)~vf+chf+strata(wmicat.4),data=TRACE)

par(mfrow=c(2,2))
bplot(out1)
bplot(out1,stratas=c(0,3))
bplot(out1,stratas=c(0,3),col=2:3,lty=1:2,se=TRUE)
bplot(out1,stratas=c(0),col=2,lty=2,se=TRUE,polygon=FALSE)
bplot(out1,stratas=c(0),col=matrix(c(2,1,3),1,3),
            lty=matrix(c(1,2,3),1,3),se=TRUE,polygon=FALSE)
}
\author{
Klaus K. Holst, Thomas Scheike
}
