% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Classification.R
\name{Gini}
\alias{Gini}
\title{Gini Coefficient}
\usage{
Gini(y_pred, y_true)
}
\arguments{
\item{y_pred}{Predicted probabilities vector, as returned by a classifier}

\item{y_true}{Ground truth (correct) 0-1 labels vector}
}
\value{
Gini Coefficient
}
\description{
Compute the Gini Coefficient.
}
\examples{
data(cars)
logreg <- glm(formula = vs ~ hp + wt,
              family = binomial(link = "logit"), data = mtcars)
Gini(y_pred = logreg$fitted.values, y_true = mtcars$vs)
}

