% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_attribute_data.R
\name{read_attribute_data}
\alias{read_attribute_data}
\title{Read attribute dataframe from NetCDF-DSG file}
\usage{
read_attribute_data(nc, instance_dim)
}
\arguments{
\item{nc}{A NetCDF path or urlto be opened.}

\item{instance_dim}{The NetCDF instance/station dimension.}
}
\description{
Gets attribute data from a NetCDF-DSG file and returns it in a \code{data.frame}.
This function is intended as a convenience to be used within workflows where
the netCDF file is already open and well understood.
}
\examples{
hucPolygons <- sf::read_sf(system.file('extdata','example_huc_eta.json', package = 'ncdfgeom'))
hucPolygons_nc <- ncdfgeom::write_geometry(tempfile(), hucPolygons)

read_attribute_data(hucPolygons_nc, "instance")

}
