% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotAnc.R
\name{plotAnc}
\alias{plotAnc}
\alias{plotSeqLogo}
\alias{add_mutations}
\title{Plot ancestral character on a tree}
\usage{
plotAnc(x, i = 1, type = "phylogram", ..., col = NULL, cex.pie = 0.5,
  pos = "bottomright", scheme = NULL)

plotSeqLogo(x, node = getRoot(x$tree), start = 1, end = 10,
  scheme = "Ape_NT", ...)

add_mutations(x, frame = "none", ...)
}
\arguments{
\item{x}{an object of class \code{ancestral}.}

\item{i}{plots the i-th site.}

\item{type}{a character string specifying the type of phylogeny to be drawn;
it must be one of "phylogram" (the default), "cladogram", "fan", "unrooted",
"radial", "tidy", or any unambiguous abbreviation of these.}

\item{\dots}{Further arguments passed to or from other methods.}

\item{col}{a vector containing the colors for all possible states.}

\item{cex.pie}{a numeric defining the size of the pie graphs.}

\item{pos}{a character string defining the position of the legend.}

\item{scheme}{a predefined color scheme. For amino acid options are "Ape_AA",
"Zappo_AA", "Clustal", "Polarity" and "Transmembrane_tendency", for
nucleotides "Ape_NT" and"RY_NT". Names can be abbreviated.}

\item{node}{to plot for which the probabilities should be plotted.}

\item{start}{start position to plot.}

\item{end}{end position to plot.}

\item{frame}{a character string specifying the kind of frame to be printed
around the text. See \code{\link[ape]{edgelabels}}.}
}
\value{
\code{plotAnc} returns silently x.

\code{plotSeqLogo} returns a ggplot object.

\code{add_mutations} adds the position and and changes of possible
mutations to a phylogeny.
}
\description{
\code{plotAnc} plots a phylogeny and adds character to the nodes. Either
takes output from  \code{ancestral.pars} or \code{ancestral.pml} or from an
alignment where there are node labels in the tree match the constructed
sequences in the alignment.
}
\details{
For further details see vignette("Ancestral").
}
\examples{

example(NJ)
# generate node labels to ensure plotting will work
tree <- makeNodeLabel(tree)
anc.p <- anc_pars(tree, Laurasiatherian)
# plot the third character
plotAnc(anc.p, 3, pos="topright")
plotSeqLogo(anc.p, node="Node10", 1, 25)

data(chloroplast)
tree <- pratchet(chloroplast,  maxit=10, trace=0)
tree <- makeNodeLabel(tree)
anc.ch <- anc_pars(tree, chloroplast)
image(as.phyDat(anc.ch)[, 1:25])
plotAnc(anc.ch, 21, scheme="Ape_AA", pos="topleft")
plotAnc(anc.ch, 21, scheme="Clustal", pos="topleft")
plotSeqLogo(anc.ch, node="Node1", 1, 25, scheme="Clustal")


data(woodmouse)
tree <- pml_bb(woodmouse, "JC", rearrangement="NNI")$tree |> midpoint()
woodmouse_aa <- trans(woodmouse, 2) |> as.phyDat()
anc_aa <- anc_pars(tree, woodmouse_aa)
plot(tree, direction="downwards")
add_mutations(anc_aa)

}
\seealso{
\code{\link{ancestral.pml}}, \code{\link[ape]{plot.phylo}},
\code{\link[ape]{image.DNAbin}}, \code{\link[ape]{image.AAbin}}
\code{\link[ggseqlogo]{ggseqlogo}}, \code{\link[ape]{edgelabels}}
}
\author{
Klaus Schliep \email{klaus.schliep@gmail.com}
}
\keyword{plot}
