% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/project.R
\name{load_project}
\alias{load_project}
\alias{library_project}
\title{Load Development Package}
\usage{
load_project(
  pkg,
  reset = FALSE,
  ...,
  utests = TRUE,
  verbose = FALSE,
  addlib = TRUE,
  character.only = FALSE,
  try.library = FALSE
)

library_project(...)
}
\arguments{
\item{pkg}{name of the package/project to load.}

\item{reset}{logical that indicates if the package should be reloaded (passed to \code{\link[devtools]{load_all}}.}

\item{...}{other arguments passed to \code{\link[devtools]{load_all}}.}

\item{utests}{logical that indicates if an environment containing the unit test functions should be created.
If \code{TRUE} this environment is accessible at \code{pkgname::UnitTests$test.filename.r$function.name}.}

\item{verbose}{logical that indicates if log messages should be printed.}

\item{addlib}{logical that indicates if the \code{lib/} sub-directory, if it exists, should be prepended
to the library path.
This enables to control the version of the loaded dependencies.}

\item{character.only}{logical that indicates if argument \var{pkg} should be evaluated or taken litteral.}

\item{try.library}{logicatl that indicates if projects that could not be found should be looked up in
the installed packages.}
}
\description{
Load Development Package
}
\section{Functions}{
\itemize{
\item \code{library_project}: shortcut for \code{load_project(..., try.library = TRUE)}, to load project
code from installed library if not found as a development project.
All its arguments are passed to \code{load_project}.
}}

