% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{reorder_columns}
\alias{reorder_columns}
\title{Reordering Columns}
\usage{
reorder_columns(x, target, decreasing = FALSE)
}
\arguments{
\item{x}{an object with columns, such as a \code{matrix} or a \code{data.frame},
or from a class that support subsetting via \code{x[, i, drop = FALSE]} and has a method \code{colnames}.}

\item{target}{a character or named numeric vector that specifies the column prefered order.
If a numeric vector, then its names are assumed to correspond to columns,
and its values determine the target order -- according to argument \code{decreasing}.}

\item{decreasing}{logical that indicates in which direction a numeric target vector should
be ordered.}
}
\value{
an object of the same type and dimension
}
\description{
Reorders columns according to a prefered target order
}
\details{
Column names will be reordered so that their order match the one in \code{target}.
Any column that does not appear in \code{target} will be put after those that are
listed in \code{target}.
}
