% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotly.R
\name{plot_mapbox}
\alias{plot_mapbox}
\title{Initiate a plotly-mapbox object}
\usage{
plot_mapbox(data = data.frame(), ...)
}
\arguments{
\item{data}{A data frame (optional).}

\item{...}{arguments passed along to \code{\link[=plot_ly]{plot_ly()}}. They should be
valid scattermapbox attributes - \url{https://plotly.com/r/reference/#scattermapbox}.
Note that x/y can also be used in place of lat/lon.}
}
\description{
Use this function instead of \code{\link[=plot_ly]{plot_ly()}} to initialize
a plotly-mapbox object. This enforces the entire plot so use
the scattermapbox trace type, and enables higher level geometries
like \code{\link[=add_polygons]{add_polygons()}} to work
}
\examples{
\dontrun{

plot_mapbox(res_mn)
plot_mapbox(res_mn, color = ~INDRESNAME)

map_data("world", "canada") \%>\%
  group_by(group) \%>\%
  plot_mapbox(x = ~long, y = ~lat) \%>\%
  add_polygons() \%>\%
  layout(
    mapbox = list(
      center = list(lat = ~median(lat), lon = ~median(long))
    )
  )
}

}
\seealso{
\code{\link[=plot_ly]{plot_ly()}}, \code{\link[=plot_geo]{plot_geo()}}, \code{\link[=ggplotly]{ggplotly()}}
}
\author{
Carson Sievert
}
