% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/novel.R
\name{step_novel}
\alias{step_novel}
\title{Simple Value Assignments for Novel Factor Levels}
\usage{
step_novel(
  recipe,
  ...,
  role = NA,
  trained = FALSE,
  new_level = "new",
  objects = NULL,
  skip = FALSE,
  id = rand_id("novel")
)
}
\arguments{
\item{recipe}{A recipe object. The step will be added to the
sequence of operations for this recipe.}

\item{...}{One or more selector functions to choose variables
for this step. See \code{\link[=selections]{selections()}} for more details.}

\item{role}{Not used by this step since no new variables are
created.}

\item{trained}{A logical to indicate if the quantities for
preprocessing have been estimated.}

\item{new_level}{A single character value that will be assigned
to new factor levels.}

\item{objects}{A list of objects that contain the information
on factor levels that will be determined by \code{\link[=prep]{prep()}}.}

\item{skip}{A logical. Should the step be skipped when the
recipe is baked by \code{\link[=bake]{bake()}}? While all operations are baked
when \code{\link[=prep]{prep()}} is run, some operations may not be able to be
conducted on new data (e.g. processing the outcome variable(s)).
Care should be taken when using \code{skip = TRUE} as it may affect
the computations for subsequent operations.}

\item{id}{A character string that is unique to this step to identify it.}
}
\value{
An updated version of \code{recipe} with the new step added to the
sequence of any existing operations.
}
\description{
\code{step_novel} creates a \emph{specification} of a recipe
step that will assign a previously unseen factor level to a
new value.
}
\details{
The selected variables are adjusted to have a new
level (given by \code{new_level}) that is placed in the last
position. During preparation there will be no data points
associated with this new level since all of the data have been
seen.

Note that if the original columns are character, they will be
converted to factors by this step.

Missing values will remain missing.

If \code{new_level} is already in the data given to \code{prep}, an error
is thrown.

When fitting a model that can deal with new factor levels, consider using
\code{\link[workflows:add_recipe]{workflows::add_recipe()}} with \code{allow_novel_levels = TRUE} set in
\code{\link[hardhat:default_recipe_blueprint]{hardhat::default_recipe_blueprint()}}. This will allow your model to handle
new levels at prediction time, instead of throwing warnings or errors.
}
\section{Tidying}{
When you \code{\link[=tidy.recipe]{tidy()}} this step, a tibble with columns
\code{terms} (the columns that will be affected) and \code{value} (the factor
levels that is used for the new value) is returned.
}

\section{Case weights}{


The underlying operation does not allow for case weights.
}

\examples{
\dontshow{if (rlang::is_installed("modeldata")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
data(Sacramento, package = "modeldata")

sacr_tr <- Sacramento[1:800, ]
sacr_te <- Sacramento[801:806, ]
sacr_te$city[3] <- "beeptown"
sacr_te$city[4] <- "boopville"

rec <- recipe(~ city + zip, data = sacr_tr)

rec <- rec \%>\%
  step_novel(city, zip)
rec <- prep(rec, training = sacr_tr)

processed <- bake(rec, sacr_te)
tibble(old = sacr_te$city, new = processed$city)

tidy(rec, number = 1)
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[=dummy_names]{dummy_names()}}

Other dummy variable and encoding steps: 
\code{\link{step_bin2factor}()},
\code{\link{step_count}()},
\code{\link{step_date}()},
\code{\link{step_dummy_extract}()},
\code{\link{step_dummy_multi_choice}()},
\code{\link{step_dummy}()},
\code{\link{step_factor2string}()},
\code{\link{step_holiday}()},
\code{\link{step_indicate_na}()},
\code{\link{step_integer}()},
\code{\link{step_num2factor}()},
\code{\link{step_ordinalscore}()},
\code{\link{step_other}()},
\code{\link{step_regex}()},
\code{\link{step_relevel}()},
\code{\link{step_string2factor}()},
\code{\link{step_time}()},
\code{\link{step_unknown}()},
\code{\link{step_unorder}()}
}
\concept{dummy variable and encoding steps}
