% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Serializer.R
\docType{class}
\name{Serializer-class}
\alias{Serializer-class}
\alias{Serializer}
\title{An RDF Serializer object.}
\description{
The Serializer class provides methods to convert a Model object
to other forms, for example, write out a Model to a file.
}
\section{Slots}{

\describe{
\item{\code{librdf_serializer}}{A redland statement object}
}}

\section{Methods}{

\itemize{
\code{\link{Serializer-initialize}}: Initialize a Serializer object.
\code{\link{setNameSpace}}: Set a namespace for the serializer.
\code{\link{serializeToCharacter}}: Serialize a model to a character vector.
\code{\link{serializeToFile}}: Serialize a model to a file.
\code{\link{freeSerializer}}: Free memory used by a librdf serializer.
}
}

\examples{
world <- new("World")
storage <- new("Storage", world, "hashes", name="", options="hash-type='memory'")
model <- new("Model", world, storage, options="")
filePath <- system.file("extdata/example.rdf", package="redland")
parser <- new("Parser", world)
parseFileIntoModel(parser, world, filePath, model)
# Creat the default "rdfxml" serizlizer
serializer <- new("Serializer", world)
# Add a namespace definition to the serializer
status <- setNameSpace(serializer, world, namespace="http://purl.org/dc/elements/1.1/", prefix="dc")
rdf <- serializeToCharacter(serializer, world, model, baseUri="")
}
\seealso{
\code{\link{redland}}: redland package
}
\keyword{classes}
