% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rio.R
\docType{package}
\name{rio}
\alias{rio-package}
\alias{rio}
\title{A Swiss-Army Knife for Data I/O}
\description{
The aim of rio is to make data file input and output as easy as possible. \code{\link[=export]{export()}} and \code{\link[=import]{import()}} serve as a Swiss-army knife for painless data I/O for data from almost any file format by inferring the data structure from the file extension, natively reading web-based data sources, setting reasonable defaults for import and export, and relying on efficient data import and export packages. An additional convenience function, \code{\link[=convert]{convert()}}, provides a simple method for converting between file types.

Note that some of rio's functionality is provided by \sQuote{Suggests} dependendencies, meaning they are not installed by default. Use \code{\link[=install_formats]{install_formats()}} to make sure these packages are available for use.
}
\examples{
# export
library("datasets")
export(mtcars, csv_file <- tempfile(fileext = ".csv")) # comma-separated values
export(mtcars, rds_file <- tempfile(fileext = ".rds")) # R serialized
export(mtcars, sav_file <- tempfile(fileext = ".sav")) # SPSS

# import
x <- import(csv_file)
y <- import(rds_file)
z <- import(sav_file)

# convert sav (SPSS) to dta (Stata)
convert(sav_file, dta_file <- tempfile(fileext = ".dta"))

# cleanup
unlink(c(csv_file, rds_file, sav_file, dta_file))

}
\references{
\href{https://cran.r-project.org/package=datamods}{datamods} provides Shiny modules for importing data via \code{rio}.

\href{https://github.com/Stan125/GREA}{GREA} provides an RStudio add-in to import data using rio.
}
\seealso{
\code{\link[=import]{import()}}, \code{\link[=import_list]{import_list()}}, \code{\link[=export]{export()}}, \code{\link[=export_list]{export_list()}}, \code{\link[=convert]{convert()}}, \code{\link[=install_formats]{install_formats()}}
}
\author{
\strong{Maintainer}: Chung-hong Chan \email{chainsawtiney@gmail.com} (\href{https://orcid.org/0000-0002-6232-7530}{ORCID})

Authors:
\itemize{
  \item Jason Becker \email{jason@jbecker.co}
  \item David Schoch \email{david@schochastics.net} (\href{https://orcid.org/0000-0003-2952-4812}{ORCID})
  \item Thomas J. Leeper \email{thosjleeper@gmail.com} (\href{https://orcid.org/0000-0003-4097-6326}{ORCID})
}

Other contributors:
\itemize{
  \item Geoffrey CH Chan \email{gefchchan@gmail.com} [contributor]
  \item Christopher Gandrud [contributor]
  \item Andrew MacDonald [contributor]
  \item Ista Zahn [contributor]
  \item Stanislaus Stadlmann [contributor]
  \item Ruaridh Williamson \email{ruaridh.williamson@gmail.com} [contributor]
  \item Patrick Kennedy [contributor]
  \item Ryan Price \email{ryapric@gmail.com} [contributor]
  \item Trevor L Davis \email{trevor.l.davis@gmail.com} [contributor]
  \item Nathan Day \email{nathancday@gmail.com} [contributor]
  \item Bill Denney \email{wdenney@humanpredictions.com} (\href{https://orcid.org/0000-0002-5759-428X}{ORCID}) [contributor]
  \item Alex Bokov \email{alex.bokov@gmail.com} (\href{https://orcid.org/0000-0002-0511-9815}{ORCID}) [contributor]
  \item Hugo Gruson (\href{https://orcid.org/0000-0002-4094-1476}{ORCID}) [contributor]
}

}
