% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jscolor.R
\name{jscolorInput}
\alias{jscolorInput}
\title{Create a JSColor picker input widget}
\usage{
jscolorInput(inputId, label, value, position = "bottom",
  color = "transparent", mode = "HSV", slider = TRUE,
  close = FALSE)
}
\arguments{
\item{inputId}{\code{\link{character}} (\strong{required}):
Specifies the input slot that will be used to access the value.}

\item{label}{\code{\link{character}} (\emph{optional}):
Display label for the control, or NULL for no label.}

\item{value}{\code{\link{character}} (\emph{optional}):
Initial RGB value of the color picker. Default is black ('#000000').}

\item{position}{\code{\link{character}} (\emph{with default}):
Position of the picker relative to the text input ('bottom', 'left', 'top', 'right').}

\item{color}{\code{\link{character}} (\emph{with default}):
Picker color scheme ('transparent' by default). Use RGB color coding ('000000').}

\item{mode}{\code{\link{character}} (\emph{with default}):
Mode of hue, saturation and value. Can either be 'HSV' or 'HVS'.}

\item{slider}{\code{\link{logical}} (\emph{with default}):
Show or hide the slider.}

\item{close}{\code{\link{logical}} (\emph{with default}):
Show or hide a close button.}
}
\description{
Creates a JSColor (Javascript/HTML Color Picker) widget to be used in shiny applications.
}
\examples{
# html code
jscolorInput("col", "Color", "21BF6B", slider = FALSE)

# example app
\dontrun{
shinyApp(
ui = fluidPage(
  jscolorInput(inputId = "col", label = "JSColor Picker", 
               value = "21BF6B", position = "right", 
               mode = "HVS", close = TRUE),
  plotOutput("plot")
),
server = function(input, output) {
  output$plot <- renderPlot({
    plot(cars, col = input$col, cex = 2, pch = 16)
 })
})
}
}
\seealso{
Other input.elements: \code{\link{animationOptions}}, \code{\link{sliderInput}};
\code{\link{checkboxGroupInput}}; \code{\link{checkboxInput}}; \code{\link{dateInput}};
\code{\link{dateRangeInput}}; \code{\link{fileInput}}; \code{\link{numericInput}};
\code{\link{passwordInput}}; \code{\link{radioButtons}}; \code{\link{selectInput}},
\code{\link{selectizeInput}}; \code{\link{submitButton}}; \code{\link{textInput}}
}
