% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tag-metadata.R
\name{tags-namespace}
\alias{tags-namespace}
\alias{@evalNamespace}
\alias{@export}
\alias{@exportClass}
\alias{@exportMethod}
\alias{@exportPattern}
\alias{@exportS3Method}
\alias{@import}
\alias{@importClassesFrom}
\alias{@importFrom}
\alias{@importMethodsFrom}
\alias{@rawNamespace}
\alias{@useDynLib}
\title{Tags for managing the \code{NAMESPACE}}
\usage{
#' @evalNamespace ${1:r-code}
#' @export
#' @exportClass ${1:class}
#' @exportMethod ${1:generic}
#' @exportPattern ${1:pattern}
#' @exportS3Method ${1:package}::${2:generic}
#' @import ${1:package}
#' @importClassesFrom ${1:package} ${2:class}
#' @importFrom ${1:package} ${2:function}
#' @importMethodsFrom ${1:package} ${2:generic}
#' @rawNamespace ${1:namespace directives}
#' @useDynLib ${1:package}
}
\description{
Learn the full details in \code{vignette('namespace')}.

Key tags:
\itemize{
\item \verb{@export}: Export this function, method, generic, or class so it's available outside of the package.
\item \verb{@exportS3Method $\{1:package\}::$\{2:generic\}}: Export an S3 method. Only needed when the method is for a generic from a suggested package.
\item \verb{@importFrom $\{1:package\} $\{2:function\}}: Import specific functions from a package.
\item \verb{@useDynLib $\{1:package\}}: Import compiled code from another package.
}

Other less frequently used tags:
\itemize{
\item \verb{@evalNamespace $\{1:r-code\}}: Evaluate arbitrary code in the package namespace and insert the results into the \code{NAMESPACE}. Should return a character vector of directives.
\item \verb{@exportClass $\{1:class\}}: Export an S4 class. For expert use only; in most cases you should use \verb{@export} so roxygen2 can automatically generate the correct directive.
\item \verb{@exportMethod $\{1:generic\}}: Export S4 methods. For expert use only; in most cases you should use \verb{@export} so roxygen2 can automatically generate the correct directive.
\item \verb{@exportPattern $\{1:pattern\}}: Export all objects matching a regular expression.
\item \verb{@import $\{1:package\}}: Import all functions from a package. Use with extreme care.
\item \verb{@importClassesFrom $\{1:package\} $\{2:class\}}: Import S4 classes from another package.
\item \verb{@importMethodsFrom $\{1:package\} $\{2:generic\}}: Import S4 methods from a package.
\item \verb{@rawNamespace $\{1:namespace directives\}}: Insert literal text directly into the \code{NAMESPACE}.
}
}
