% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diagnose.R
\name{SitemFit}
\alias{SitemFit}
\title{Compute the S fit statistic for a set of items}
\usage{
SitemFit(
  grp,
  ...,
  method = "pearson",
  log = TRUE,
  qwidth = 6,
  qpoints = 49L,
  alt = FALSE,
  omit = 0L,
  .twotier = TRUE,
  .parallel = TRUE
)
}
\arguments{
\item{grp}{a list containing the model and data. See the details section.}

\item{...}{Not used.  Forces remaining arguments to be specified by name.}

\item{method}{whether to use a pearson or rms test}

\item{log}{whether to return p-values in log units}

\item{qwidth}{\lifecycle{deprecated}}

\item{qpoints}{\lifecycle{deprecated}}

\item{alt}{whether to include the item of interest in the denominator}

\item{omit}{number of items to omit (a single number) or a list of the length the number of items}

\item{.twotier}{whether to enable the two-tier optimization}

\item{.parallel}{whether to take advantage of multiple CPUs (default TRUE)}
}
\value{
a list of output from \code{\link{SitemFit1}}
}
\description{
Runs \code{\link{SitemFit1}} for every item and accumulates
the results.
}
\section{Format of a group}{


A model, or group within a model, is represented as a named list.
\describe{
\item{spec}{list of response model objects}
\item{param}{numeric matrix of item parameters}
\item{free}{logical matrix of indicating which parameters are free (TRUE) or fixed (FALSE)}
\item{mean}{numeric vector giving the mean of the latent distribution}
\item{cov}{numeric matrix giving the covariance of the latent distribution}
\item{data}{data.frame containing observed item responses, and optionally,
weights and frequencies}
\item{score}{factors scores with response patterns in rows}
\item{weightColumn}{name of the data column containing the numeric row weights (optional)}
\item{freqColumn}{name of the data column containing the integral row frequencies (optional)}
\item{qwidth}{width of the quadrature expressed in Z units}
\item{qpoints}{number of quadrature points}
\item{minItemsPerScore}{minimum number of non-missing items when estimating factor scores}
}

The \code{param} matrix stores items parameters by column. If a
column has more rows than are required to fully specify a model
then the extra rows are ignored.  The order of the items in
\code{spec} and order of columns in \code{param} are assumed to
match. All items should have the same number of latent dimensions.
Loadings on latent dimensions are given in the first few rows and
can be named by setting rownames. Item names are assigned by
\code{param} colnames.

Currently only a multivariate normal distribution is available,
parameterized by the \code{mean} and \code{cov}. If \code{mean} and
\code{cov} are not specified then a standard normal distribution is
assumed. The quadrature consists of equally spaced points. For
example, \code{qwidth=2} and \code{qpoints=5} would produce points
-2, -1, 0, 1, and 2. The quadrature specification is part of the
group and not passed as extra arguments for the sake of
consistency. As currently implemented, OpenMx uses EAP scores to
estimate latent distribution parameters. By default, the exact same
EAP scores should be produced by \link{EAPscores}.
}

\examples{
grp <- list(spec=list())
grp$spec[1:20] <- list(rpf.grm())
grp$param <- sapply(grp$spec, rpf.rparam)
colnames(grp$param) <- paste("i", 1:20, sep="")
grp$mean <- 0
grp$cov <- diag(1)
grp$free <- grp$param != 0
grp$data <- rpf.sample(500, grp=grp)
SitemFit(grp)
}
\seealso{
Other diagnostic: 
\code{\link{ChenThissen1997}()},
\code{\link{SitemFit1}()},
\code{\link{multinomialFit}()},
\code{\link{rpf.1dim.fit}()},
\code{\link{sumScoreEAPTest}()}
}
\concept{diagnostic}
