% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cor_select.R
\name{cor_select}
\alias{cor_select}
\title{Subset Correlation Matrix}
\usage{
cor_select(x, ..., vars = NULL)
}
\arguments{
\item{x}{a correlation matrix. Particularly, an object of class \code{cor_mat}.}

\item{...}{One or more unquoted expressions (or variable names) separated by
commas. Used to select variables of interest.}

\item{vars}{a character vector containing the variable names of interest.}
}
\value{
a data frame
}
\description{
Subset Correlation Matrix
}
\examples{
# Compute correlation matrix
#::::::::::::::::::::::::::::::::::::::::::
cor.mat <- mtcars \%>\%
  select(mpg, disp, hp, drat, wt, qsec) \%>\%
  cor_mat()

# Subsetting correlation matrix
#::::::::::::::::::::::::::::::::::::::::::

# Select some variables of interest
cor.mat \%>\%
  cor_select(mpg, drat, wt)

# Remove variables
cor.mat \%>\%
  cor_select(-mpg, -wt)

}
\seealso{
\code{\link{cor_mat}()}, \code{\link{pull_triangle}()}, \code{\link{replace_triangle}()}
}
