% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tk2ico.R
\name{tk2ico.create}
\alias{tk2ico.create}
\alias{tk2ico.destroy}
\alias{tk2ico.list}
\alias{tk2ico.sizes}
\alias{tk2ico.load}
\alias{tk2ico.setFromFile}
\alias{tk2ico.set}
\title{Manipulate icons under Windows}
\usage{
tk2ico.create(iconfile, res = 0, size = 16)

tk2ico.destroy(icon)

tk2ico.list(file = "shell32.dll")

tk2ico.sizes(file = "shell32.dll", res = "application")

tk2ico.load(file = "shell32.dll", res = "application", size = 16)

tk2ico.setFromFile(win, iconfile)

tk2ico.set(win, icon)
}
\arguments{
\item{iconfile}{A file with a .ico, or .exe extension, containing one or more
Windows icons}

\item{res}{The name of the resource from where the icon should be extracted.}

\item{size}{Te size of the icon to use. For windows icons, 16 should be fine
usually.}

\item{icon}{A icon object.}

\item{file}{A file having icon resources (.exe, or .dll).}

\item{win}{A Tk window, or an integer representing the handle (HWND) of a
foreign window whose icon will be changed (take care, the function returns
\code{TRUE} even if the handle is wrong!}
}
\value{
An icon object, which is a reference to an image resource in Tcl. Its classes
are \code{c("tclObj", "tclIcon")}. Do not forget to destroy it using
\code{\link[=tk2ico.destroy]{tk2ico.destroy()}} when you do not need it any more!
If \code{\link[=tk2ico.load]{tk2ico.load()}} fails, it returns \code{NULL} instead of a Tcl object.
}
\description{
Create, load and work with Windows icons. Change icons for Windows. These
functions are only useful for Windows, but they silently return \code{NULL} on
other platforms for writing compatible code (Windows icons instructions can
be simply ignored).
}
\note{
This is Windows-specific. It is implemented using the ico Tcl package.
}
\examples{
\dontrun{
# These cannot be run by examples() but should be OK when pasted
# into an interactive R session with the tcltk package loaded

### Examples of tk2ico - icon manipulation under Windows
tt2 <- tktoplevel()
# Load a system icon (there are: "application", "asterisk", "error",
# "exclamation", "hand", "question", "information", "warning", and "winlogo".
Warn <- tk2ico.load(res = "warning")
# Change the icon of my window tt2
tk2ico.set(tt2, Warn)
# Do not forget to destroy icon to free resource when not needed any more
tk2ico.destroy(Warn)
rm(Warn)

### Otherwise, the list of icons in a file are:
tk2ico.list()
# and for a given icon, the various sizes are:
tk2ico.sizes(res = 4)

### One can set icon of a window from an .ico or .exe file directly
tk2ico.setFromFile(tt, default = file.path(R.home("bin"), "Rgui.exe"))

tk2ico.setFromFile(tt2, system.file("gui", "SciViews.ico", package = "tcltk2"))

### When done, dispose of the window and clean the workspace
tkdestroy(tt2)
rm(tt2)
}
}
\seealso{
\code{\link[=tk2dde.exec]{tk2dde.exec()}}, \code{\link[=tk2reg.get]{tk2reg.get()}}
}
\author{
Philippe Grosjean
}
\keyword{utilities}
