% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/local_.R, R/with_.R
\name{local_}
\alias{local_}
\alias{with_}
\title{Create a new "with" or "local" function}
\usage{
local_(
  set,
  reset = set,
  get = NULL,
  ...,
  envir = parent.frame(),
  new = TRUE,
  dots = FALSE
)

with_(set, reset = set, get = NULL, ..., envir = parent.frame(), new = TRUE)
}
\arguments{
\item{set}{\verb{[function(...)]}\cr Function used to set the state.
The function can have arbitrarily many arguments, they will be replicated
in the formals of the returned function.}

\item{reset}{\verb{[function(x)]}\cr Function used to reset the state.
The first argument can be named arbitrarily, further arguments with default
values, or a "dots" argument, are supported but not used: The function will
be called as \code{reset(old)}.}

\item{get}{\verb{[function(...)]}\cr Optionally, a getter function. If
supplied, the \code{on.exit()} restoration is set up \emph{before} calling
\code{set}. This is more robust in edge cases.

For technical reasons, this getter function must have the same
interface as \code{set}, which means it is passed the new values as
well. These can be safely ignored.}

\item{...}{These dots are for future extensions and must be empty.}

\item{envir}{\verb{[environment]}\cr Environment of the returned function.}

\item{new}{\verb{[logical(1)]}\cr Replace the first argument of the \code{set} function
by \code{new}? Set to \code{FALSE} if the \code{set} function only has optional arguments.}
}
\value{
\verb{[function(new, code, ...)]} A function with at least two arguments,
\itemize{
\item \code{new}: New state to use
\item \code{code}: Code to run in that state.
}
If there are more arguments to the function passed in \code{set} they are
added to the returned function.  If \code{set} does not have arguments,
or \code{new} is \code{FALSE}, the returned function does not have a \code{code} argument.
}
\description{
These are constructors for \code{with_...} or \code{local_...} functions.
They are only needed if you want to alter some global state which is not
covered by the existing \code{with_...} functions, see \link{withr}
for an overview.
}
\details{
The \code{with_...} functions reset the state immediately after the
\code{code} argument has been evaluated. The \code{local_...} functions
reset their arguments after they go out of scope, usually at the end of the
function body.
}
\examples{
with_(setwd)

global_stack <- list()
set_global_state <- function(state, msg = "Changing global state.") {
  global_stack <- c(list(state), global_stack)
  message(msg)
  state
}
reset_global_state <- function(state) {
  old_state <- global_stack[[1]]
  global_stack <- global_stack[-1]
  stopifnot(identical(state, old_state))
}
with_(set_global_state, reset_global_state)
}
\keyword{internal}
