% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wkt.R
\name{wkt}
\alias{wkt}
\alias{parse_wkt}
\alias{as_wkt}
\alias{as_wkt.default}
\alias{as_wkt.character}
\alias{as_wkt.wk_wkt}
\title{Mark character vectors as well-known text}
\usage{
wkt(x = character(), crs = wk_crs_auto(), geodesic = FALSE)

parse_wkt(x, crs = wk_crs_auto(), geodesic = FALSE)

as_wkt(x, ...)

\method{as_wkt}{default}(x, ...)

\method{as_wkt}{character}(x, ..., crs = NULL, geodesic = FALSE)

\method{as_wkt}{wk_wkt}(x, ...)
}
\arguments{
\item{x}{A \code{\link[=character]{character()}} vector containing well-known text.}

\item{crs}{A value to be propagated as the CRS for this vector.}

\item{geodesic}{\code{TRUE} if edges must be interpolated as geodesics when
coordinates are spherical, \code{FALSE} otherwise.}

\item{...}{Unused}
}
\value{
A \code{\link[=new_wk_wkt]{new_wk_wkt()}}
}
\description{
Mark character vectors as well-known text
}
\examples{
wkt("POINT (20 10)")

}
