% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/encoding.R
\name{native_encode}
\alias{native_encode}
\title{Try to use the system native encoding to represent a character vector}
\usage{
native_encode(x)
}
\arguments{
\item{x}{A character vector.}
}
\description{
Apply \code{enc2native()} to the character vector, and check if
\code{enc2utf8()} can convert it back without a loss. If it does, return
\code{enc2native(x)}, otherwise return the original vector with a warning.
}
\note{
On platforms that supports UTF-8 as the native encoding
  (\code{\link{l10n_info}()[['UTF-8']]} returns \code{TRUE}), the conversion
  will be skipped.
}
\examples{
library(xfun)
s = intToUtf8(c(20320, 22909))
Encoding(s)

s2 = native_encode(s)
Encoding(s2)
}
