% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/string.R
\name{numbers_to_words}
\alias{numbers_to_words}
\alias{n2w}
\title{Convert numbers to English words}
\usage{
numbers_to_words(x, cap = FALSE, hyphen = TRUE, and = FALSE)

n2w(x, cap = FALSE, hyphen = TRUE, and = FALSE)
}
\arguments{
\item{x}{A numeric vector. Values should be integers. The absolute values
should be less than \code{1e15}.}

\item{cap}{Whether to capitalize the first letter of the word. This can be
useful when the word is at the beginning of a sentence. Default is
\code{FALSE}.}

\item{hyphen}{Whether to insert hyphen (-) when the number is between 21 and
99 (except 30, 40, etc.).}

\item{and}{Whether to insert \code{and} between hundreds and tens, e.g.,
write 110 as \dQuote{one hundred and ten} if \code{TRUE} instead of
\dQuote{one hundred ten}.}
}
\value{
A character vector.
}
\description{
This can be helpful when writing reports with \pkg{knitr}/\pkg{rmarkdown} if
we want to print numbers as English words in the output. The function
\code{n2w()} is an alias of \code{numbers_to_words()}.
}
\examples{
library(xfun)
n2w(0, cap = TRUE)
n2w(0:121, and = TRUE)
n2w(1e+06)
n2w(1e+11 + 12345678)
n2w(-987654321)
n2w(1e+15 - 1)
}
\author{
Daijiang Li
}
