% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ascat.asmultipcf.R
\name{ascat.asmultipcf}
\alias{ascat.asmultipcf}
\title{Allele-specific segmentation of multiple samples}
\usage{
ascat.asmultipcf(
  ASCATobj,
  ascat.gg = NULL,
  penalty = 70,
  out.dir = ".",
  wsample = NULL,
  selectAlg = "exact",
  refine = TRUE,
  seed = as.integer(Sys.time())
)
}
\arguments{
\item{ASCATobj}{an ASCAT object}

\item{ascat.gg}{germline genotypes (NULL if germline data is available)}

\item{penalty}{penalty of introducing an additional ASPCF breakpoint (expert parameter, don't adapt unless you know what you are doing)}

\item{out.dir}{directory in which output files will be written. Can be set to NA to not write PCFed files.}

\item{wsample}{Vector of length length(ASCATobj$samples). Can be used to assign different weights to samples, for example to account for differences in sequencing quality. (Default = NULL)}

\item{selectAlg}{Set to "exact" to run the exact algorithm, or "fast" to run the heuristic algorithm. (Default = "exact")}

\item{refine}{Logical. Should breakpoints be refined on a per sample base? Otherwise each breakpoint is assumed to be present in each sample. (Default = TRUE)}

\item{seed}{A seed to be set when subsampling SNPs for X in males (optional, default=as.integer(Sys.time())).}
}
\value{
output: ascat data structure containing:\cr
1. Tumor_LogR data matrix\cr
2. Tumor_BAF data matrix\cr
3. Tumor_LogR_segmented: matrix of LogR segmented values\cr
4. Tumor_BAF_segmented: list of BAF segmented values; each element in the list is a matrix containing the segmented values for one sample (only for probes that are germline homozygous)\cr
5. Germline_LogR data matrix\cr
6. Germline_BAF data matrix\cr
7. SNPpos: position of all SNPs\cr
8. ch: a list containing vectors with the indices for each chromosome (e.g. Tumor_LogR[ch[[13]],] will output the Tumor_LogR data of chromosome 13\cr
9. chr: a list containing vectors with the indices for each distinct part that can be segmented separately (e.g. chromosome arm, stretch of DNA between gaps in the array design)\cr
}
\description{
This segmentation function should only be used if part of the breakpoints are expected to be shared 
between samples, e.g. due to a common ancestry.
}
\details{
This function saves the results in in [sample].LogR.PCFed.txt and [sample].BAF.PCFed.txt
}
