/*
 *	recite - english text speech synthesizer
 *	Copyright (C) 1993 Peter Miller.
 *	All rights reserved.
 *
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 1, or (at your option)
 *	any later version.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * MANIFEST: functions to mainipluate klatt data
 *
 * Derived from a program
 * dated 25 July 1987, L. Goldstein, S. Levy
 */

#include <multimedia/ulaw2linear.h>

#include <frame.h>
#include <klatt.h>
#include <mem.h>
#include <parwave.h>
#include <trace.h>


static	unsigned char	*playbuf_data;
static	size_t		playbuf_size;
static	size_t		playbuf_pos;


#define NUM_SET_PARS 20

#define NMSPF_DEF 10
#define NF_DEF 20
#define MAX_SAM 500
#define NFRAMES 20
#define NFRAMES_PER_PAGE 20
#define NSAMP_PER_BLOCK 256
#define MIDSCALE 2048
#define BOOLEAN int
#define MAX_PLA 100000
#define NCHANGE 20
#define SWITCH 5
#define BADVAL 99
#define CR 13
#define ZERO 48
#define NINE 57
#define BACKSPACE 8
#define NPARTOT 47


/* default values for pars array from .doc file */
static pars_ty def_pars =
{
	1000,	/* F0hz10 */
	60,	/* AVdb */
	500,	/* F1hz */
	60,	/* B1hz */
	1500,	/* F2hz */
	90,	/* B2hz */
	2800,	/* F3hz */
	150,	/* B3hz */
	3250,	/* F4hz */
	200,	/* B4hz */
	3700,	/* F5hz */
	200,	/* B5hz */
	4990,	/* F6hz */
	500,	/* B6hz */
	280,	/* FNZhz */
	90,	/* BNZhz */
	280,	/* FNPhz */
	90,	/* BNPhz */
	0,	/* AP */
	30,	/* Kopen */
	0,	/* Aturb */
	0,	/* TLTdb */
	0,	/* AF */
	0,	/* Kskew */
	0,	/* A1 */
	80,	/* B1phz */
	0,	/* A2 */
	200,	/* B2phz */
	0,	/* A3 */
	350,	/* B3phz */
	0,	/* A4 */
	500,	/* B4phz */
	0,	/* A5 */
	600,	/* B5phz */
	0,	/* A6 */
	800,	/* B6phz */
	0,	/* ANP */
	0,	/* AB */
	0,	/* AVpdb */
	66	/* Gain0 */
};


static	int totsam;
static	int icount;
static	int ibuf;
static pars_ty *par_array;    /* parameter buffer */
static short *inflect;             /* needed for interpolation */
static	int data_exist = 0;

;

static	long	initsw, warnsw, dispt, disptcum;
static	int	nframes;


/*
 * read parameter values from a file into the parameter array
 */

static void read_pars _((char *data, long datalen));

static void
read_pars(data, datalen)
	char		*data;
	long		datalen;
{
	frame_ty	*frame;
	int		j;
	frame_ty	*fp;
	pars_ty		*pp;

	trace(("read_pars()\n{\n"/*}*/));
	frame = (frame_ty *)data;
	nframes = datalen / sizeof(frame_ty);

	par_array = (pars_ty *)mem_alloc(nframes * sizeof(pars_ty));
	inflect = (short *)mem_alloc(nframes * sizeof(short));

	for (j = 0; j < nframes; ++j)
	{
		fp = &frame[j];
		pp = &par_array[j];
		*pp = def_pars;
		pp->F0hz10 = fp->f0;
		pp->F1hz = fp->f1;
		pp->F2hz = fp->f2;
		pp->F3hz = fp->f3;
		pp->B1hz = fp->bw1;
		pp->B2hz = fp->bw2;
		pp->B3hz = fp->bw3;
		pp->FNZhz = fp->fnz;
		pp->FNPhz = fp->fnp;
		pp->AVdb = fp->av;
		/* pp->TLTdb = fp->anp; */
		pp->ANP = fp->anp;
		pp->AP = fp->asp;
		pp->AF = fp->af;
		pp->A1 = fp->a1;
		pp->A2 = fp->a2;
		pp->A3 = fp->a3;
		pp->A4 = fp->a4;
		pp->A5 = fp->a5;
		pp->A6 = fp->a6;
		pp->AB = fp->ab;
	}
	trace((/*{*/"}\n"));
} 


static void playbuf _((int));

static void
playbuf(sample)
	int	sample;
{
	trace(("playbuf(%d)\n{\n"/*}*/, sample));
	if (playbuf_pos >= playbuf_size)
	{
		playbuf_size += (1L << 16);
		trace(("playbuf_size = %ld\n", playbuf_size));
		if (!playbuf_data)
			playbuf_data = (unsigned char *)mem_alloc(playbuf_size);
		else
			mem_change_size((char **)&playbuf_data, playbuf_size);
		trace(("playbuf_data = %08lX\n", (long)playbuf_data));
	}
	playbuf_data[playbuf_pos++] = sample;
	trace((/*{*/"}\n"));
}


static void playbuf_collect _((char **, long *));

static void
playbuf_collect(out, outlen)
	char	**out;
	long	*outlen;
{
	trace(("playbuf_collect()\n{\n"/*}*/));
	if (playbuf_pos < playbuf_size)
	{
		playbuf_size = playbuf_pos;
		mem_change_size((char **)&playbuf_data, playbuf_size);
	}
	*out = (char *)playbuf_data;
	*outlen = playbuf_size;
	playbuf_data = 0;
	playbuf_size = 0;
	playbuf_pos = 0;
	trace((/*{*/"}\n"));
}


void
klatt_to_ulaw(in, inlen, out, outlen)
	char	*in;
	long	inlen;
	char	**out;
	long	*outlen;
{
	short	iwave[NSAMP_PER_FRAME];
	int	isam;

	trace(("klatt_to_ulaw()\n{\n"/*}*/));
	read_pars(in, inlen);
	
	ibuf = 0;
	initsw = 0; 
	warnsw = 0;
	dispt = 0;
	disptcum =0;
	
	for (icount = 0; icount < nframes; icount++)
	{
		parwav(&par_array[icount], iwave); 
		for (isam = 0; isam < NSAMP_PER_FRAME; ++isam)
			playbuf(audio_s2u(iwave[isam]));
		data_exist = 1;
		totsam = ibuf;
	}

	playbuf_collect(out, outlen);
	trace((/*{*/"}\n"));
}
