#!/bin/sh
basis_list=$*

cat << EOF1
// file automatically generated by: $0
///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
///
/// =========================================================================
#include "rheolef/basis.h"
#include "rheolef/basis_get.h"
#include "basis_fem_Pk_lagrange.h"
#include "basis_fem_Pk_bernstein.h"
#include "basis_fem_Pk_sherwin.h"
#include "basis_fem_RTk.h"
#include "basis_fem_sides.h"
#include "basis_fem_vector.h"
#include "basis_fem_tensor.h"
#include "basis_fem_empty.h"
EOF1

for basis in ${basis_list}; do
 echo "#include \"${basis}.h\""
done

cat << EOF2
namespace rheolef {
using namespace std;

template<class T>
bool
basis_rep<T>::have_index_parameter (std::string name) {
EOF2

for basis in ${basis_list}; do
  is_Pk=`echo "$basis" | grep '^P[0-9]$'`
  if test x"$is_Pk" != x""; then continue; fi
  echo "  if (name == \"${basis}\") return false;"
done

cat << EOF3
  return true;
}
template<class T>
bool
basis_rep<T>::have_continuous_feature (std::string name) {
EOF3

for basis in ${basis_list}; do
  is_Pk_C0=`echo "$basis" | grep '^P[1-9]$'`
  if test x"$is_Pk_C0" != x""; then continue; fi
  echo "  if (name == \"${basis}\") return false;"
done

cat << EOF4
  return true;
}
template<class T>
basis_rep<T>*
basis_rep<T>::make_ptr (const std::string& name)
{
  family_index_option_type fio;
  basis_parse_from_string (name, fio);

  if (fio.family == "") return 0;
  if (fio.option.valued_tag() != space_constant::scalar) {
    basis_option sopt2 = fio.option;
    sopt2.set_valued_tag (space_constant::scalar);
    std::string name2 = basis_rep<T>::standard_naming (fio.family, fio.index, sopt2);
    // recursively call make_ptr without the vector/tensor option:
    basis_basic<T> scalar_basis;
    scalar_basis.basis_basic<T>::base::operator= (basis_rep<T>::make_ptr(name2));
    switch (fio.option.valued_tag()) {
      case space_constant::vector:
	  return new_macro(basis_fem_vector<T>(scalar_basis,fio.option));
      case space_constant::tensor:
	  return new_macro(basis_fem_tensor<T>(scalar_basis,fio.option));
      default:
          check_macro (fio.option.valued_tag() == space_constant::scalar,
	    fio.option.valued()<<"-valued basis not yet supported, sorry");
    }
  }
  if (fio.option.is_restricted_to_sides()) {
    basis_option sopt2 = fio.option;
    sopt2.set_restricted_to_sides(false);
    std::string name2 = basis_rep<T>::standard_naming (fio.family, fio.index, sopt2);
    // recursively call make_ptr without the side option:
    basis_basic<T> side_basis;
    side_basis.basis_basic<T>::base::operator= (basis_rep<T>::make_ptr(name2));
    return new_macro(basis_fem_sides<T>(side_basis));
  }
EOF4

for basis in ${basis_list}; do
  is_Pk=`echo "$basis" | grep '^P[01-9]$'`
  if test x"$is_Pk" != x""; then
    k=`echo "$basis" | sed -e 's/P//'`
    if test "$k" = "0"; then
       echo "  if (fio.family == \"P\" && fio.index == ${k}) return new_macro(basis_${basis}<T>());"
    else
       echo "  if (fio.family == \"P\" && fio.index == ${k}) return new_macro(basis_${basis}<T>(fio.option));"
    fi
  else
    echo "  if (fio.family == \"${basis}\") return new_macro(basis_${basis}<T>);"
  fi
done

cat << EOF5
  if (fio.family == "P")  return new_macro(basis_fem_Pk_lagrange<T> (fio.index, fio.option));
  if (fio.family == "B")  return new_macro(basis_fem_Pk_bernstein<T>(fio.index, fio.option));
  if (fio.family == "S")  return new_macro(basis_fem_Pk_sherwin<T>  (fio.index, fio.option));
  if (fio.family == "RT") return new_macro(basis_fem_RTk<T>         (fio.index, fio.option));
  if (fio.family == "empty")  return new_macro(basis_fem_empty<T>());
  error_macro ("undefined basis \`" << fio.family << "'");
  return 0;
}
// instanciation in library:
template basis_rep<Float>* basis_rep<Float>::make_ptr (const std::string&);
template bool              basis_rep<Float>::have_index_parameter   (std::string family_name);
template bool              basis_rep<Float>::have_continuous_feature (std::string family_name);

} // namespace rheolef
EOF5

exit 0
