// Code generated by go-swagger; DO NOT EDIT.

package provisioning

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"0xacab.org/leap/menshen/models"
)

// Get5ServiceReader is a Reader for the Get5Service structure.
type Get5ServiceReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *Get5ServiceReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewGet5ServiceOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewGet5ServiceBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 404:
		result := NewGet5ServiceNotFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewGet5ServiceInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[GET /5/service] Get5Service", response, response.Code())
	}
}

// NewGet5ServiceOK creates a Get5ServiceOK with default headers values
func NewGet5ServiceOK() *Get5ServiceOK {
	return &Get5ServiceOK{}
}

/*
Get5ServiceOK describes a response with status code 200, with default header values.

OK
*/
type Get5ServiceOK struct {
	Payload *models.ModelsEIPService
}

// IsSuccess returns true when this get5 service o k response has a 2xx status code
func (o *Get5ServiceOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this get5 service o k response has a 3xx status code
func (o *Get5ServiceOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get5 service o k response has a 4xx status code
func (o *Get5ServiceOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this get5 service o k response has a 5xx status code
func (o *Get5ServiceOK) IsServerError() bool {
	return false
}

// IsCode returns true when this get5 service o k response a status code equal to that given
func (o *Get5ServiceOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the get5 service o k response
func (o *Get5ServiceOK) Code() int {
	return 200
}

func (o *Get5ServiceOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /5/service][%d] get5ServiceOK %s", 200, payload)
}

func (o *Get5ServiceOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /5/service][%d] get5ServiceOK %s", 200, payload)
}

func (o *Get5ServiceOK) GetPayload() *models.ModelsEIPService {
	return o.Payload
}

func (o *Get5ServiceOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ModelsEIPService)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGet5ServiceBadRequest creates a Get5ServiceBadRequest with default headers values
func NewGet5ServiceBadRequest() *Get5ServiceBadRequest {
	return &Get5ServiceBadRequest{}
}

/*
Get5ServiceBadRequest describes a response with status code 400, with default header values.

Bad Request
*/
type Get5ServiceBadRequest struct {
	Payload interface{}
}

// IsSuccess returns true when this get5 service bad request response has a 2xx status code
func (o *Get5ServiceBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get5 service bad request response has a 3xx status code
func (o *Get5ServiceBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get5 service bad request response has a 4xx status code
func (o *Get5ServiceBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this get5 service bad request response has a 5xx status code
func (o *Get5ServiceBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this get5 service bad request response a status code equal to that given
func (o *Get5ServiceBadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the get5 service bad request response
func (o *Get5ServiceBadRequest) Code() int {
	return 400
}

func (o *Get5ServiceBadRequest) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /5/service][%d] get5ServiceBadRequest %s", 400, payload)
}

func (o *Get5ServiceBadRequest) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /5/service][%d] get5ServiceBadRequest %s", 400, payload)
}

func (o *Get5ServiceBadRequest) GetPayload() interface{} {
	return o.Payload
}

func (o *Get5ServiceBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// response payload
	if err := consumer.Consume(response.Body(), &o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGet5ServiceNotFound creates a Get5ServiceNotFound with default headers values
func NewGet5ServiceNotFound() *Get5ServiceNotFound {
	return &Get5ServiceNotFound{}
}

/*
Get5ServiceNotFound describes a response with status code 404, with default header values.

Not Found
*/
type Get5ServiceNotFound struct {
	Payload interface{}
}

// IsSuccess returns true when this get5 service not found response has a 2xx status code
func (o *Get5ServiceNotFound) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get5 service not found response has a 3xx status code
func (o *Get5ServiceNotFound) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get5 service not found response has a 4xx status code
func (o *Get5ServiceNotFound) IsClientError() bool {
	return true
}

// IsServerError returns true when this get5 service not found response has a 5xx status code
func (o *Get5ServiceNotFound) IsServerError() bool {
	return false
}

// IsCode returns true when this get5 service not found response a status code equal to that given
func (o *Get5ServiceNotFound) IsCode(code int) bool {
	return code == 404
}

// Code gets the status code for the get5 service not found response
func (o *Get5ServiceNotFound) Code() int {
	return 404
}

func (o *Get5ServiceNotFound) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /5/service][%d] get5ServiceNotFound %s", 404, payload)
}

func (o *Get5ServiceNotFound) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /5/service][%d] get5ServiceNotFound %s", 404, payload)
}

func (o *Get5ServiceNotFound) GetPayload() interface{} {
	return o.Payload
}

func (o *Get5ServiceNotFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// response payload
	if err := consumer.Consume(response.Body(), &o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGet5ServiceInternalServerError creates a Get5ServiceInternalServerError with default headers values
func NewGet5ServiceInternalServerError() *Get5ServiceInternalServerError {
	return &Get5ServiceInternalServerError{}
}

/*
Get5ServiceInternalServerError describes a response with status code 500, with default header values.

Internal Server Error
*/
type Get5ServiceInternalServerError struct {
	Payload interface{}
}

// IsSuccess returns true when this get5 service internal server error response has a 2xx status code
func (o *Get5ServiceInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get5 service internal server error response has a 3xx status code
func (o *Get5ServiceInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get5 service internal server error response has a 4xx status code
func (o *Get5ServiceInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this get5 service internal server error response has a 5xx status code
func (o *Get5ServiceInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this get5 service internal server error response a status code equal to that given
func (o *Get5ServiceInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the get5 service internal server error response
func (o *Get5ServiceInternalServerError) Code() int {
	return 500
}

func (o *Get5ServiceInternalServerError) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /5/service][%d] get5ServiceInternalServerError %s", 500, payload)
}

func (o *Get5ServiceInternalServerError) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /5/service][%d] get5ServiceInternalServerError %s", 500, payload)
}

func (o *Get5ServiceInternalServerError) GetPayload() interface{} {
	return o.Payload
}

func (o *Get5ServiceInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// response payload
	if err := consumer.Consume(response.Body(), &o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
