Robot Testing Framework 1.4.0 (2018-02-09) Release Notes               {#v1_4_0}
========================================================

Important Changes
-----------------

* RTF now requires CMake 3.5 for building.
* C++11 is required for compiling and using RTF.
* Added `[[noreturn]]` c++11 statement for assert macros.
* Fixed old typo, the keyword `suit` has been replaced with `suite`, maintaining
  the backward compatibility.
* Added `target_include_directories` in all RTF libraries.
* Change logic for `RTF_*_IF(condition, message)` functions, adding new
  functions `RTF_*_IF_TRUE` and `RTF_*_IF_FALSE`, deprecating the old ones.
* It is now possible to pass an absolute path to a library.
* The RTF libraries library can now be compiled either as shared or
  static libraries, using the [`BUILD_SHARED_LIBS`](https://cmake.org/cmake/help/v3.5/variable/BUILD_SHARED_LIBS.html)
  CMake variable. For RTF, we set the default value of `BUILD_SHARED_LIBS` to ON.
  Before this release, Windows compilation was only supported if RTF libraries were compiled
  as static libraries, while now also on Windows by default libraries are compiled as shared ( https://github.com/robotology/robot-testing-framework/pull/85 ).

### Libraries


New Features
------------

### CMake Modules

* Added `rtf_add_plugin`.
* Added `rtf_add_suite`.
* Exported target `testrunner`.

### Libraries

#### `RTF`

* Added xml tag order check.
* Added `RTF::TestSuite::size()` method

### Tools

#### testrunner

* The order of the dots in the status bar is now correct (#94)

Bug Fixes
---------

### Libraries

#### `RTF_dll`

* Fixed dll postfix mismatch on windows.
  In debug configuration rtf will try to load the dll with a "d" between the
  name and the format (e.g. name + "d" + .dll)
* `SharedLibrary*` classes unified with respective `YARP` code.
  In particular commit c114635 has been imported from YARP.
  See issue #435 in robotology/yarp for more details.

Contributors
------------

This is a list of people that contributed to this release (generated from the
git history using `git shortlog -ens --no-merges v1.2.0..v1.4.0`):

```
    28	Nicolo' Genesio <nicolo.genesio@iit.it>
    21	Daniele E. Domenichelli <daniele.domenichelli@iit.it>
    11	Andrea Ruzzenenti <andrea.ruzzenenti@iit.it>
     6	Damiano Enerli <damiano.enerli@iit.it>
     5	Silvio Traversaro <silvio.traversaro@iit.it>
     1	Nicolò Genesio <nicolo.genesio@iit.it>
```
