/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.REngine.Rserve;

import java.io.File;
import org.rosuda.REngine.Rserve.RConnection;
import org.rosuda.REngine.Rserve.StreamHog;

public class StartRserve {
    public static boolean launchRserve(String string) {
        return StartRserve.launchRserve(string, "--no-save --slave", "--no-save --slave", false);
    }

    public static boolean launchRserve(String string, String string2, String string3, boolean bl) {
        try {
            Process process;
            boolean bl2 = false;
            String string4 = System.getProperty("os.name");
            if (string4 != null && string4.length() >= 7 && string4.substring(0, 7).equals("Windows")) {
                bl2 = true;
                process = Runtime.getRuntime().exec("\"" + string + "\" -e \"library(Rserve);Rserve(" + (bl ? "TRUE" : "FALSE") + ",args='" + string3 + "')\" " + string2);
            } else {
                process = Runtime.getRuntime().exec(new String[]{"/bin/sh", "-c", "echo 'library(Rserve);Rserve(" + (bl ? "TRUE" : "FALSE") + ",args=\"" + string3 + "\")'|" + string + " " + string2});
            }
            System.out.println("StartRserve: waiting for Rserve to start ... (" + process + ")");
            StreamHog streamHog = new StreamHog(process.getErrorStream(), false);
            StreamHog streamHog2 = new StreamHog(process.getInputStream(), false);
            if (!bl2) {
                process.waitFor();
            }
            System.out.println("StartRserve: call terminated, let us try to connect ...");
        }
        catch (Exception exception) {
            System.out.println("StartRserve: failed to start Rserve process with " + exception.getMessage());
            return false;
        }
        for (int i = 5; i > 0; --i) {
            try {
                RConnection rConnection = new RConnection();
                rConnection.close();
                return true;
            }
            catch (Exception exception) {
                System.out.println("StartRserve: Try failed with: " + exception.getMessage());
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                continue;
            }
        }
        return false;
    }

    public static boolean checkLocalRserve() {
        if (StartRserve.isRserveRunning()) {
            return true;
        }
        String string = System.getProperty("os.name");
        if (string != null && string.length() >= 7 && string.substring(0, 7).equals("Windows")) {
            System.out.println("StartRserve: Windows: query registry to find where R is installed ...");
            String string2 = null;
            try {
                Process process = Runtime.getRuntime().exec("reg query HKLM\\Software\\R-core\\R");
                StreamHog streamHog = new StreamHog(process.getInputStream(), true);
                process.waitFor();
                streamHog.join();
                string2 = streamHog.getInstallPath();
            }
            catch (Exception exception) {
                System.out.println("ERROR: unable to run REG to find the location of R: " + exception);
                return false;
            }
            if (string2 == null) {
                System.out.println("ERROR: canot find path to R. Make sure reg is available and R was installed with registry settings.");
                return false;
            }
            return StartRserve.launchRserve(string2 + "\\bin\\R.exe");
        }
        return StartRserve.launchRserve("R") || new File("/Library/Frameworks/R.framework/Resources/bin/R").exists() && StartRserve.launchRserve("/Library/Frameworks/R.framework/Resources/bin/R") || new File("/usr/local/lib/R/bin/R").exists() && StartRserve.launchRserve("/usr/local/lib/R/bin/R") || new File("/usr/lib/R/bin/R").exists() && StartRserve.launchRserve("/usr/lib/R/bin/R") || new File("/usr/local/bin/R").exists() && StartRserve.launchRserve("/usr/local/bin/R") || new File("/sw/bin/R").exists() && StartRserve.launchRserve("/sw/bin/R") || new File("/usr/common/bin/R").exists() && StartRserve.launchRserve("/usr/common/bin/R") || new File("/opt/bin/R").exists() && StartRserve.launchRserve("/opt/bin/R");
    }

    public static boolean isRserveRunning() {
        try {
            RConnection rConnection = new RConnection();
            rConnection.close();
            return true;
        }
        catch (Exception exception) {
            System.out.println("StartRserve: first connect try failed with: " + exception.getMessage());
            return false;
        }
    }

    public static void main(String[] stringArray) {
        System.out.println("result=" + StartRserve.checkLocalRserve());
        try {
            RConnection rConnection = new RConnection();
            rConnection.shutdown();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

