# encoding: utf-8
# Code generated by Microsoft (R) AutoRest Code Generator 1.2.2.0
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.

module Azure::ARM::DevTestLabs
  #
  # The DevTest Labs Client.
  #
  class Disks
    include MsRestAzure

    #
    # Creates and initializes a new instance of the Disks class.
    # @param client service class for accessing basic functionality.
    #
    def initialize(client)
      @client = client
    end

    # @return [DevTestLabsClient] reference to the DevTestLabsClient
    attr_reader :client

    #
    # List disks in a given user profile.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param lab_name [String] The name of the lab.
    # @param user_name [String] The name of the user profile.
    # @param expand [String] Specify the $expand query. Example:
    # 'properties($select=diskType)'
    # @param filter [String] The filter to apply to the operation.
    # @param top [Integer] The maximum number of resources to return from the
    # operation.
    # @param orderby [String] The ordering expression for the results, using OData
    # notation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array<Disk>] operation results.
    #
    def list(resource_group_name, lab_name, user_name, expand = nil, filter = nil, top = nil, orderby = nil, custom_headers = nil)
      first_page = list_as_lazy(resource_group_name, lab_name, user_name, expand, filter, top, orderby, custom_headers)
      first_page.get_all_items
    end

    #
    # List disks in a given user profile.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param lab_name [String] The name of the lab.
    # @param user_name [String] The name of the user profile.
    # @param expand [String] Specify the $expand query. Example:
    # 'properties($select=diskType)'
    # @param filter [String] The filter to apply to the operation.
    # @param top [Integer] The maximum number of resources to return from the
    # operation.
    # @param orderby [String] The ordering expression for the results, using OData
    # notation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_with_http_info(resource_group_name, lab_name, user_name, expand = nil, filter = nil, top = nil, orderby = nil, custom_headers = nil)
      list_async(resource_group_name, lab_name, user_name, expand, filter, top, orderby, custom_headers).value!
    end

    #
    # List disks in a given user profile.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param lab_name [String] The name of the lab.
    # @param user_name [String] The name of the user profile.
    # @param expand [String] Specify the $expand query. Example:
    # 'properties($select=diskType)'
    # @param filter [String] The filter to apply to the operation.
    # @param top [Integer] The maximum number of resources to return from the
    # operation.
    # @param orderby [String] The ordering expression for the results, using OData
    # notation.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_async(resource_group_name, lab_name, user_name, expand = nil, filter = nil, top = nil, orderby = nil, custom_headers = nil)
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'lab_name is nil' if lab_name.nil?
      fail ArgumentError, 'user_name is nil' if user_name.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DevTestLab/labs/{labName}/users/{userName}/disks'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'subscriptionId' => @client.subscription_id,'resourceGroupName' => resource_group_name,'labName' => lab_name,'userName' => user_name},
          query_params: {'$expand' => expand,'$filter' => filter,'$top' => top,'$orderby' => orderby,'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::DevTestLabs::Models::ResponseWithContinuationDisk.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Get disk.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param lab_name [String] The name of the lab.
    # @param user_name [String] The name of the user profile.
    # @param name [String] The name of the disk.
    # @param expand [String] Specify the $expand query. Example:
    # 'properties($select=diskType)'
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Disk] operation results.
    #
    def get(resource_group_name, lab_name, user_name, name, expand = nil, custom_headers = nil)
      response = get_async(resource_group_name, lab_name, user_name, name, expand, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Get disk.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param lab_name [String] The name of the lab.
    # @param user_name [String] The name of the user profile.
    # @param name [String] The name of the disk.
    # @param expand [String] Specify the $expand query. Example:
    # 'properties($select=diskType)'
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_with_http_info(resource_group_name, lab_name, user_name, name, expand = nil, custom_headers = nil)
      get_async(resource_group_name, lab_name, user_name, name, expand, custom_headers).value!
    end

    #
    # Get disk.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param lab_name [String] The name of the lab.
    # @param user_name [String] The name of the user profile.
    # @param name [String] The name of the disk.
    # @param expand [String] Specify the $expand query. Example:
    # 'properties($select=diskType)'
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_async(resource_group_name, lab_name, user_name, name, expand = nil, custom_headers = nil)
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'lab_name is nil' if lab_name.nil?
      fail ArgumentError, 'user_name is nil' if user_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DevTestLab/labs/{labName}/users/{userName}/disks/{name}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'subscriptionId' => @client.subscription_id,'resourceGroupName' => resource_group_name,'labName' => lab_name,'userName' => user_name,'name' => name},
          query_params: {'$expand' => expand,'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::DevTestLabs::Models::Disk.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Create or replace an existing disk. This operation can take a while to
    # complete.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param lab_name [String] The name of the lab.
    # @param user_name [String] The name of the user profile.
    # @param name [String] The name of the disk.
    # @param disk [Disk] A Disk.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Disk] operation results.
    #
    def create_or_update(resource_group_name, lab_name, user_name, name, disk, custom_headers = nil)
      response = create_or_update_async(resource_group_name, lab_name, user_name, name, disk, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # @param resource_group_name [String] The name of the resource group.
    # @param lab_name [String] The name of the lab.
    # @param user_name [String] The name of the user profile.
    # @param name [String] The name of the disk.
    # @param disk [Disk] A Disk.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Concurrent::Promise] promise which provides async access to http
    # response.
    #
    def create_or_update_async(resource_group_name, lab_name, user_name, name, disk, custom_headers = nil)
      # Send request
      promise = begin_create_or_update_async(resource_group_name, lab_name, user_name, name, disk, custom_headers)

      promise = promise.then do |response|
        # Defining deserialization method.
        deserialize_method = lambda do |parsed_response|
          result_mapper = Azure::ARM::DevTestLabs::Models::Disk.mapper()
          parsed_response = @client.deserialize(result_mapper, parsed_response)
        end

        # Waiting for response.
        @client.get_long_running_operation_result(response, deserialize_method)
      end

      promise
    end

    #
    # Delete disk. This operation can take a while to complete.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param lab_name [String] The name of the lab.
    # @param user_name [String] The name of the user profile.
    # @param name [String] The name of the disk.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    def delete(resource_group_name, lab_name, user_name, name, custom_headers = nil)
      response = delete_async(resource_group_name, lab_name, user_name, name, custom_headers).value!
      nil
    end

    #
    # @param resource_group_name [String] The name of the resource group.
    # @param lab_name [String] The name of the lab.
    # @param user_name [String] The name of the user profile.
    # @param name [String] The name of the disk.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Concurrent::Promise] promise which provides async access to http
    # response.
    #
    def delete_async(resource_group_name, lab_name, user_name, name, custom_headers = nil)
      # Send request
      promise = begin_delete_async(resource_group_name, lab_name, user_name, name, custom_headers)

      promise = promise.then do |response|
        # Defining deserialization method.
        deserialize_method = lambda do |parsed_response|
        end

        # Waiting for response.
        @client.get_long_running_operation_result(response, deserialize_method)
      end

      promise
    end

    #
    # Attach and create the lease of the disk to the virtual machine. This
    # operation can take a while to complete.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param lab_name [String] The name of the lab.
    # @param user_name [String] The name of the user profile.
    # @param name [String] The name of the disk.
    # @param attach_disk_properties [AttachDiskProperties] Properties of the disk
    # to attach.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    def attach(resource_group_name, lab_name, user_name, name, attach_disk_properties, custom_headers = nil)
      response = attach_async(resource_group_name, lab_name, user_name, name, attach_disk_properties, custom_headers).value!
      nil
    end

    #
    # @param resource_group_name [String] The name of the resource group.
    # @param lab_name [String] The name of the lab.
    # @param user_name [String] The name of the user profile.
    # @param name [String] The name of the disk.
    # @param attach_disk_properties [AttachDiskProperties] Properties of the disk
    # to attach.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Concurrent::Promise] promise which provides async access to http
    # response.
    #
    def attach_async(resource_group_name, lab_name, user_name, name, attach_disk_properties, custom_headers = nil)
      # Send request
      promise = begin_attach_async(resource_group_name, lab_name, user_name, name, attach_disk_properties, custom_headers)

      promise = promise.then do |response|
        # Defining deserialization method.
        deserialize_method = lambda do |parsed_response|
        end

        # Waiting for response.
        @client.get_long_running_operation_result(response, deserialize_method)
      end

      promise
    end

    #
    # Detach and break the lease of the disk attached to the virtual machine. This
    # operation can take a while to complete.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param lab_name [String] The name of the lab.
    # @param user_name [String] The name of the user profile.
    # @param name [String] The name of the disk.
    # @param detach_disk_properties [DetachDiskProperties] Properties of the disk
    # to detach.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    def detach(resource_group_name, lab_name, user_name, name, detach_disk_properties, custom_headers = nil)
      response = detach_async(resource_group_name, lab_name, user_name, name, detach_disk_properties, custom_headers).value!
      nil
    end

    #
    # @param resource_group_name [String] The name of the resource group.
    # @param lab_name [String] The name of the lab.
    # @param user_name [String] The name of the user profile.
    # @param name [String] The name of the disk.
    # @param detach_disk_properties [DetachDiskProperties] Properties of the disk
    # to detach.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Concurrent::Promise] promise which provides async access to http
    # response.
    #
    def detach_async(resource_group_name, lab_name, user_name, name, detach_disk_properties, custom_headers = nil)
      # Send request
      promise = begin_detach_async(resource_group_name, lab_name, user_name, name, detach_disk_properties, custom_headers)

      promise = promise.then do |response|
        # Defining deserialization method.
        deserialize_method = lambda do |parsed_response|
        end

        # Waiting for response.
        @client.get_long_running_operation_result(response, deserialize_method)
      end

      promise
    end

    #
    # Create or replace an existing disk. This operation can take a while to
    # complete.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param lab_name [String] The name of the lab.
    # @param user_name [String] The name of the user profile.
    # @param name [String] The name of the disk.
    # @param disk [Disk] A Disk.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Disk] operation results.
    #
    def begin_create_or_update(resource_group_name, lab_name, user_name, name, disk, custom_headers = nil)
      response = begin_create_or_update_async(resource_group_name, lab_name, user_name, name, disk, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Create or replace an existing disk. This operation can take a while to
    # complete.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param lab_name [String] The name of the lab.
    # @param user_name [String] The name of the user profile.
    # @param name [String] The name of the disk.
    # @param disk [Disk] A Disk.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def begin_create_or_update_with_http_info(resource_group_name, lab_name, user_name, name, disk, custom_headers = nil)
      begin_create_or_update_async(resource_group_name, lab_name, user_name, name, disk, custom_headers).value!
    end

    #
    # Create or replace an existing disk. This operation can take a while to
    # complete.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param lab_name [String] The name of the lab.
    # @param user_name [String] The name of the user profile.
    # @param name [String] The name of the disk.
    # @param disk [Disk] A Disk.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def begin_create_or_update_async(resource_group_name, lab_name, user_name, name, disk, custom_headers = nil)
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'lab_name is nil' if lab_name.nil?
      fail ArgumentError, 'user_name is nil' if user_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'disk is nil' if disk.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = Azure::ARM::DevTestLabs::Models::Disk.mapper()
      request_content = @client.serialize(request_mapper,  disk)
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DevTestLab/labs/{labName}/users/{userName}/disks/{name}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'subscriptionId' => @client.subscription_id,'resourceGroupName' => resource_group_name,'labName' => lab_name,'userName' => user_name,'name' => name},
          query_params: {'api-version' => @client.api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:put, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200 || status_code == 201
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::DevTestLabs::Models::Disk.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end
        # Deserialize Response
        if status_code == 201
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::DevTestLabs::Models::Disk.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Delete disk. This operation can take a while to complete.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param lab_name [String] The name of the lab.
    # @param user_name [String] The name of the user profile.
    # @param name [String] The name of the disk.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    #
    def begin_delete(resource_group_name, lab_name, user_name, name, custom_headers = nil)
      response = begin_delete_async(resource_group_name, lab_name, user_name, name, custom_headers).value!
      nil
    end

    #
    # Delete disk. This operation can take a while to complete.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param lab_name [String] The name of the lab.
    # @param user_name [String] The name of the user profile.
    # @param name [String] The name of the disk.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def begin_delete_with_http_info(resource_group_name, lab_name, user_name, name, custom_headers = nil)
      begin_delete_async(resource_group_name, lab_name, user_name, name, custom_headers).value!
    end

    #
    # Delete disk. This operation can take a while to complete.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param lab_name [String] The name of the lab.
    # @param user_name [String] The name of the user profile.
    # @param name [String] The name of the disk.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def begin_delete_async(resource_group_name, lab_name, user_name, name, custom_headers = nil)
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'lab_name is nil' if lab_name.nil?
      fail ArgumentError, 'user_name is nil' if user_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DevTestLab/labs/{labName}/users/{userName}/disks/{name}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'subscriptionId' => @client.subscription_id,'resourceGroupName' => resource_group_name,'labName' => lab_name,'userName' => user_name,'name' => name},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:delete, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 202 || status_code == 204
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Attach and create the lease of the disk to the virtual machine. This
    # operation can take a while to complete.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param lab_name [String] The name of the lab.
    # @param user_name [String] The name of the user profile.
    # @param name [String] The name of the disk.
    # @param attach_disk_properties [AttachDiskProperties] Properties of the disk
    # to attach.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    #
    def begin_attach(resource_group_name, lab_name, user_name, name, attach_disk_properties, custom_headers = nil)
      response = begin_attach_async(resource_group_name, lab_name, user_name, name, attach_disk_properties, custom_headers).value!
      nil
    end

    #
    # Attach and create the lease of the disk to the virtual machine. This
    # operation can take a while to complete.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param lab_name [String] The name of the lab.
    # @param user_name [String] The name of the user profile.
    # @param name [String] The name of the disk.
    # @param attach_disk_properties [AttachDiskProperties] Properties of the disk
    # to attach.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def begin_attach_with_http_info(resource_group_name, lab_name, user_name, name, attach_disk_properties, custom_headers = nil)
      begin_attach_async(resource_group_name, lab_name, user_name, name, attach_disk_properties, custom_headers).value!
    end

    #
    # Attach and create the lease of the disk to the virtual machine. This
    # operation can take a while to complete.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param lab_name [String] The name of the lab.
    # @param user_name [String] The name of the user profile.
    # @param name [String] The name of the disk.
    # @param attach_disk_properties [AttachDiskProperties] Properties of the disk
    # to attach.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def begin_attach_async(resource_group_name, lab_name, user_name, name, attach_disk_properties, custom_headers = nil)
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'lab_name is nil' if lab_name.nil?
      fail ArgumentError, 'user_name is nil' if user_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'attach_disk_properties is nil' if attach_disk_properties.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = Azure::ARM::DevTestLabs::Models::AttachDiskProperties.mapper()
      request_content = @client.serialize(request_mapper,  attach_disk_properties)
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DevTestLab/labs/{labName}/users/{userName}/disks/{name}/attach'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'subscriptionId' => @client.subscription_id,'resourceGroupName' => resource_group_name,'labName' => lab_name,'userName' => user_name,'name' => name},
          query_params: {'api-version' => @client.api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200 || status_code == 202
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Detach and break the lease of the disk attached to the virtual machine. This
    # operation can take a while to complete.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param lab_name [String] The name of the lab.
    # @param user_name [String] The name of the user profile.
    # @param name [String] The name of the disk.
    # @param detach_disk_properties [DetachDiskProperties] Properties of the disk
    # to detach.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    #
    def begin_detach(resource_group_name, lab_name, user_name, name, detach_disk_properties, custom_headers = nil)
      response = begin_detach_async(resource_group_name, lab_name, user_name, name, detach_disk_properties, custom_headers).value!
      nil
    end

    #
    # Detach and break the lease of the disk attached to the virtual machine. This
    # operation can take a while to complete.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param lab_name [String] The name of the lab.
    # @param user_name [String] The name of the user profile.
    # @param name [String] The name of the disk.
    # @param detach_disk_properties [DetachDiskProperties] Properties of the disk
    # to detach.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def begin_detach_with_http_info(resource_group_name, lab_name, user_name, name, detach_disk_properties, custom_headers = nil)
      begin_detach_async(resource_group_name, lab_name, user_name, name, detach_disk_properties, custom_headers).value!
    end

    #
    # Detach and break the lease of the disk attached to the virtual machine. This
    # operation can take a while to complete.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param lab_name [String] The name of the lab.
    # @param user_name [String] The name of the user profile.
    # @param name [String] The name of the disk.
    # @param detach_disk_properties [DetachDiskProperties] Properties of the disk
    # to detach.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def begin_detach_async(resource_group_name, lab_name, user_name, name, detach_disk_properties, custom_headers = nil)
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'lab_name is nil' if lab_name.nil?
      fail ArgumentError, 'user_name is nil' if user_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'detach_disk_properties is nil' if detach_disk_properties.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = Azure::ARM::DevTestLabs::Models::DetachDiskProperties.mapper()
      request_content = @client.serialize(request_mapper,  detach_disk_properties)
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DevTestLab/labs/{labName}/users/{userName}/disks/{name}/detach'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'subscriptionId' => @client.subscription_id,'resourceGroupName' => resource_group_name,'labName' => lab_name,'userName' => user_name,'name' => name},
          query_params: {'api-version' => @client.api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200 || status_code == 202
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # List disks in a given user profile.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [ResponseWithContinuationDisk] operation results.
    #
    def list_next(next_page_link, custom_headers = nil)
      response = list_next_async(next_page_link, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # List disks in a given user profile.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_next_with_http_info(next_page_link, custom_headers = nil)
      list_next_async(next_page_link, custom_headers).value!
    end

    #
    # List disks in a given user profile.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_next_async(next_page_link, custom_headers = nil)
      fail ArgumentError, 'next_page_link is nil' if next_page_link.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '{nextLink}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          skip_encoding_path_params: {'nextLink' => next_page_link},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::DevTestLabs::Models::ResponseWithContinuationDisk.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # List disks in a given user profile.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param lab_name [String] The name of the lab.
    # @param user_name [String] The name of the user profile.
    # @param expand [String] Specify the $expand query. Example:
    # 'properties($select=diskType)'
    # @param filter [String] The filter to apply to the operation.
    # @param top [Integer] The maximum number of resources to return from the
    # operation.
    # @param orderby [String] The ordering expression for the results, using OData
    # notation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [ResponseWithContinuationDisk] which provide lazy access to pages of
    # the response.
    #
    def list_as_lazy(resource_group_name, lab_name, user_name, expand = nil, filter = nil, top = nil, orderby = nil, custom_headers = nil)
      response = list_async(resource_group_name, lab_name, user_name, expand, filter, top, orderby, custom_headers).value!
      unless response.nil?
        page = response.body
        page.next_method = Proc.new do |next_page_link|
          list_next_async(next_page_link, custom_headers)
        end
        page
      end
    end

  end
end
