# encoding: utf-8
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator 1.2.2.0
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.

module Azure::ARM::RecoveryServicesBackup
  module Models
    #
    # Additional information on Azure Sql specific protected item.
    #
    class AzureSqlProtectedItemExtendedInfo

      include MsRestAzure

      include MsRest::JSONable
      # @return [DateTime] The oldest backup copy available for this item in
      # the service.
      attr_accessor :oldest_recovery_point

      # @return [Integer] Number of available backup copies associated with
      # this backup item.
      attr_accessor :recovery_point_count

      # @return [String] State of the backup policy associated with this backup
      # item.
      attr_accessor :policy_state


      #
      # Mapper for AzureSqlProtectedItemExtendedInfo class as Ruby Hash.
      # This will be used for serialization/deserialization.
      #
      def self.mapper()
        {
          required: false,
          serialized_name: 'AzureSqlProtectedItemExtendedInfo',
          type: {
            name: 'Composite',
            class_name: 'AzureSqlProtectedItemExtendedInfo',
            model_properties: {
              oldest_recovery_point: {
                required: false,
                serialized_name: 'oldestRecoveryPoint',
                type: {
                  name: 'DateTime'
                }
              },
              recovery_point_count: {
                required: false,
                serialized_name: 'recoveryPointCount',
                type: {
                  name: 'Number'
                }
              },
              policy_state: {
                required: false,
                serialized_name: 'policyState',
                type: {
                  name: 'String'
                }
              }
            }
          }
        }
      end
    end
  end
end
