# encoding: utf-8
# Code generated by Microsoft (R) AutoRest Code Generator 1.2.2.0
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.

module Azure::ARM::ServerManagement
  module Models
    #
    # Expanded gateway status information.
    #
    class GatewayStatus

      include MsRestAzure

      include MsRest::JSONable
      # @return [Float] The available memory on the gateway host machine in
      # megabytes.
      attr_accessor :available_memory_mbyte

      # @return [Float] The CPU utilization of the gateway process (numeric
      # value between 0 and 100).
      attr_accessor :gateway_cpu_utilization_percent

      # @return [Float] CPU Utilization of the whole system.
      attr_accessor :total_cpu_utilization_percent

      # @return [String] The version of the gateway that is installed on the
      # system.
      attr_accessor :gateway_version

      # @return [String] The Plaintext description of the OS on the gateway.
      attr_accessor :friendly_os_name

      # @return [DateTime] The date the gateway was installed.
      attr_accessor :installed_date

      # @return [Integer] Number of logical processors in the gateway system.
      attr_accessor :logical_processor_count

      # @return [String] The computer name of the gateway system.
      attr_accessor :name

      # @return [String] The gateway resource ID.
      attr_accessor :gateway_id

      # @return [Float] The working set size of the gateway process in
      # megabytes.
      attr_accessor :gateway_working_set_mbyte

      # @return [DateTime] UTC date and time when gateway status was last
      # updated.
      attr_accessor :status_updated

      # @return [String] The group policy error.
      attr_accessor :group_policy_error

      # @return [Boolean] Status of the allowGatewayGroupPolicy setting.
      attr_accessor :allow_gateway_group_policy_status

      # @return [Boolean] Status of the requireMfaGroupPolicy setting.
      attr_accessor :require_mfa_group_policy_status

      # @return [String] Thumbprint of the encryption certificate.
      attr_accessor :encryption_certificate_thumbprint

      # @return [String] Secondary thumbprint of the encryption certificate.
      attr_accessor :secondary_encryption_certificate_thumbprint

      # @return [EncryptionJwkResource] The encryption certificate key.
      attr_accessor :encryption_jwk

      # @return [EncryptionJwkResource] The secondary encryption certificate
      # key.
      attr_accessor :secondary_encryption_jwk

      # @return [Integer] Active message count.
      attr_accessor :active_message_count

      # @return [String] Latest published version of the gateway install MSI.
      attr_accessor :latest_published_msi_version

      # @return [DateTime] Gateway install MSI published time.
      attr_accessor :published_time_utc


      #
      # Mapper for GatewayStatus class as Ruby Hash.
      # This will be used for serialization/deserialization.
      #
      def self.mapper()
        {
          required: false,
          serialized_name: 'GatewayStatus',
          type: {
            name: 'Composite',
            class_name: 'GatewayStatus',
            model_properties: {
              available_memory_mbyte: {
                required: false,
                serialized_name: 'availableMemoryMByte',
                type: {
                  name: 'Double'
                }
              },
              gateway_cpu_utilization_percent: {
                required: false,
                serialized_name: 'gatewayCpuUtilizationPercent',
                constraints: {
                  InclusiveMaximum: 100,
                  InclusiveMinimum: 0
                },
                type: {
                  name: 'Double'
                }
              },
              total_cpu_utilization_percent: {
                required: false,
                serialized_name: 'totalCpuUtilizationPercent',
                type: {
                  name: 'Double'
                }
              },
              gateway_version: {
                required: false,
                serialized_name: 'gatewayVersion',
                type: {
                  name: 'String'
                }
              },
              friendly_os_name: {
                required: false,
                serialized_name: 'friendlyOsName',
                type: {
                  name: 'String'
                }
              },
              installed_date: {
                required: false,
                serialized_name: 'installedDate',
                type: {
                  name: 'DateTime'
                }
              },
              logical_processor_count: {
                required: false,
                serialized_name: 'logicalProcessorCount',
                type: {
                  name: 'Number'
                }
              },
              name: {
                required: false,
                serialized_name: 'name',
                type: {
                  name: 'String'
                }
              },
              gateway_id: {
                required: false,
                serialized_name: 'gatewayId',
                type: {
                  name: 'String'
                }
              },
              gateway_working_set_mbyte: {
                required: false,
                serialized_name: 'gatewayWorkingSetMByte',
                type: {
                  name: 'Double'
                }
              },
              status_updated: {
                required: false,
                serialized_name: 'statusUpdated',
                type: {
                  name: 'DateTime'
                }
              },
              group_policy_error: {
                required: false,
                serialized_name: 'groupPolicyError',
                type: {
                  name: 'String'
                }
              },
              allow_gateway_group_policy_status: {
                required: false,
                serialized_name: 'allowGatewayGroupPolicyStatus',
                type: {
                  name: 'Boolean'
                }
              },
              require_mfa_group_policy_status: {
                required: false,
                serialized_name: 'requireMfaGroupPolicyStatus',
                type: {
                  name: 'Boolean'
                }
              },
              encryption_certificate_thumbprint: {
                required: false,
                serialized_name: 'encryptionCertificateThumbprint',
                type: {
                  name: 'String'
                }
              },
              secondary_encryption_certificate_thumbprint: {
                required: false,
                serialized_name: 'secondaryEncryptionCertificateThumbprint',
                type: {
                  name: 'String'
                }
              },
              encryption_jwk: {
                required: false,
                serialized_name: 'encryptionJwk',
                type: {
                  name: 'Composite',
                  class_name: 'EncryptionJwkResource'
                }
              },
              secondary_encryption_jwk: {
                required: false,
                serialized_name: 'secondaryEncryptionJwk',
                type: {
                  name: 'Composite',
                  class_name: 'EncryptionJwkResource'
                }
              },
              active_message_count: {
                required: false,
                serialized_name: 'activeMessageCount',
                type: {
                  name: 'Number'
                }
              },
              latest_published_msi_version: {
                required: false,
                serialized_name: 'latestPublishedMsiVersion',
                type: {
                  name: 'String'
                }
              },
              published_time_utc: {
                required: false,
                serialized_name: 'publishedTimeUtc',
                type: {
                  name: 'DateTime'
                }
              }
            }
          }
        }
      end
    end
  end
end
