# encoding: utf-8
# Code generated by Microsoft (R) AutoRest Code Generator 1.2.2.0
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.

module Azure::ARM::StreamAnalytics
  #
  # Stream Analytics Client
  #
  class Functions
    include MsRestAzure

    #
    # Creates and initializes a new instance of the Functions class.
    # @param client service class for accessing basic functionality.
    #
    def initialize(client)
      @client = client
    end

    # @return [StreamAnalyticsManagementClient] reference to the StreamAnalyticsManagementClient
    attr_reader :client

    #
    # Creates a function or replaces an already existing function under an existing
    # streaming job.
    #
    # @param function [Function] The definition of the function that will be used
    # to create a new function or replace the existing one under the streaming job.
    # @param resource_group_name [String] The name of the resource group that
    # contains the resource. You can obtain this value from the Azure Resource
    # Manager API or the portal.
    # @param job_name [String] The name of the streaming job.
    # @param function_name [String] The name of the function.
    # @param if_match [String] The ETag of the function. Omit this value to always
    # overwrite the current function. Specify the last-seen ETag value to prevent
    # accidentally overwritting concurrent changes.
    # @param if_none_match [String] Set to '*' to allow a new function to be
    # created, but to prevent updating an existing function. Other values will
    # result in a 412 Pre-condition Failed response.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Function] operation results.
    #
    def create_or_replace(function, resource_group_name, job_name, function_name, if_match = nil, if_none_match = nil, custom_headers = nil)
      response = create_or_replace_async(function, resource_group_name, job_name, function_name, if_match, if_none_match, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Creates a function or replaces an already existing function under an existing
    # streaming job.
    #
    # @param function [Function] The definition of the function that will be used
    # to create a new function or replace the existing one under the streaming job.
    # @param resource_group_name [String] The name of the resource group that
    # contains the resource. You can obtain this value from the Azure Resource
    # Manager API or the portal.
    # @param job_name [String] The name of the streaming job.
    # @param function_name [String] The name of the function.
    # @param if_match [String] The ETag of the function. Omit this value to always
    # overwrite the current function. Specify the last-seen ETag value to prevent
    # accidentally overwritting concurrent changes.
    # @param if_none_match [String] Set to '*' to allow a new function to be
    # created, but to prevent updating an existing function. Other values will
    # result in a 412 Pre-condition Failed response.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def create_or_replace_with_http_info(function, resource_group_name, job_name, function_name, if_match = nil, if_none_match = nil, custom_headers = nil)
      create_or_replace_async(function, resource_group_name, job_name, function_name, if_match, if_none_match, custom_headers).value!
    end

    #
    # Creates a function or replaces an already existing function under an existing
    # streaming job.
    #
    # @param function [Function] The definition of the function that will be used
    # to create a new function or replace the existing one under the streaming job.
    # @param resource_group_name [String] The name of the resource group that
    # contains the resource. You can obtain this value from the Azure Resource
    # Manager API or the portal.
    # @param job_name [String] The name of the streaming job.
    # @param function_name [String] The name of the function.
    # @param if_match [String] The ETag of the function. Omit this value to always
    # overwrite the current function. Specify the last-seen ETag value to prevent
    # accidentally overwritting concurrent changes.
    # @param if_none_match [String] Set to '*' to allow a new function to be
    # created, but to prevent updating an existing function. Other values will
    # result in a 412 Pre-condition Failed response.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def create_or_replace_async(function, resource_group_name, job_name, function_name, if_match = nil, if_none_match = nil, custom_headers = nil)
      fail ArgumentError, 'function is nil' if function.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'job_name is nil' if job_name.nil?
      fail ArgumentError, 'function_name is nil' if function_name.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['If-Match'] = if_match unless if_match.nil?
      request_headers['If-None-Match'] = if_none_match unless if_none_match.nil?
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = Azure::ARM::StreamAnalytics::Models::Function.mapper()
      request_content = @client.serialize(request_mapper,  function)
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = 'subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.StreamAnalytics/streamingjobs/{jobName}/functions/{functionName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'subscriptionId' => @client.subscription_id,'resourceGroupName' => resource_group_name,'jobName' => job_name,'functionName' => function_name},
          query_params: {'api-version' => @client.api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:put, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200 || status_code == 201
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::StreamAnalytics::Models::Function.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end
        # Deserialize Response
        if status_code == 201
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::StreamAnalytics::Models::Function.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Updates an existing function under an existing streaming job. This can be
    # used to partially update (ie. update one or two properties) a function
    # without affecting the rest the job or function definition.
    #
    # @param function [Function] A function object. The properties specified here
    # will overwrite the corresponding properties in the existing function (ie.
    # Those properties will be updated). Any properties that are set to null here
    # will mean that the corresponding property in the existing function will
    # remain the same and not change as a result of this PATCH operation.
    # @param resource_group_name [String] The name of the resource group that
    # contains the resource. You can obtain this value from the Azure Resource
    # Manager API or the portal.
    # @param job_name [String] The name of the streaming job.
    # @param function_name [String] The name of the function.
    # @param if_match [String] The ETag of the function. Omit this value to always
    # overwrite the current function. Specify the last-seen ETag value to prevent
    # accidentally overwritting concurrent changes.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Function] operation results.
    #
    def update(function, resource_group_name, job_name, function_name, if_match = nil, custom_headers = nil)
      response = update_async(function, resource_group_name, job_name, function_name, if_match, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Updates an existing function under an existing streaming job. This can be
    # used to partially update (ie. update one or two properties) a function
    # without affecting the rest the job or function definition.
    #
    # @param function [Function] A function object. The properties specified here
    # will overwrite the corresponding properties in the existing function (ie.
    # Those properties will be updated). Any properties that are set to null here
    # will mean that the corresponding property in the existing function will
    # remain the same and not change as a result of this PATCH operation.
    # @param resource_group_name [String] The name of the resource group that
    # contains the resource. You can obtain this value from the Azure Resource
    # Manager API or the portal.
    # @param job_name [String] The name of the streaming job.
    # @param function_name [String] The name of the function.
    # @param if_match [String] The ETag of the function. Omit this value to always
    # overwrite the current function. Specify the last-seen ETag value to prevent
    # accidentally overwritting concurrent changes.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def update_with_http_info(function, resource_group_name, job_name, function_name, if_match = nil, custom_headers = nil)
      update_async(function, resource_group_name, job_name, function_name, if_match, custom_headers).value!
    end

    #
    # Updates an existing function under an existing streaming job. This can be
    # used to partially update (ie. update one or two properties) a function
    # without affecting the rest the job or function definition.
    #
    # @param function [Function] A function object. The properties specified here
    # will overwrite the corresponding properties in the existing function (ie.
    # Those properties will be updated). Any properties that are set to null here
    # will mean that the corresponding property in the existing function will
    # remain the same and not change as a result of this PATCH operation.
    # @param resource_group_name [String] The name of the resource group that
    # contains the resource. You can obtain this value from the Azure Resource
    # Manager API or the portal.
    # @param job_name [String] The name of the streaming job.
    # @param function_name [String] The name of the function.
    # @param if_match [String] The ETag of the function. Omit this value to always
    # overwrite the current function. Specify the last-seen ETag value to prevent
    # accidentally overwritting concurrent changes.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def update_async(function, resource_group_name, job_name, function_name, if_match = nil, custom_headers = nil)
      fail ArgumentError, 'function is nil' if function.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'job_name is nil' if job_name.nil?
      fail ArgumentError, 'function_name is nil' if function_name.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['If-Match'] = if_match unless if_match.nil?
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = Azure::ARM::StreamAnalytics::Models::Function.mapper()
      request_content = @client.serialize(request_mapper,  function)
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = 'subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.StreamAnalytics/streamingjobs/{jobName}/functions/{functionName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'subscriptionId' => @client.subscription_id,'resourceGroupName' => resource_group_name,'jobName' => job_name,'functionName' => function_name},
          query_params: {'api-version' => @client.api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:patch, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::StreamAnalytics::Models::Function.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Deletes a function from the streaming job.
    #
    # @param resource_group_name [String] The name of the resource group that
    # contains the resource. You can obtain this value from the Azure Resource
    # Manager API or the portal.
    # @param job_name [String] The name of the streaming job.
    # @param function_name [String] The name of the function.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    #
    def delete(resource_group_name, job_name, function_name, custom_headers = nil)
      response = delete_async(resource_group_name, job_name, function_name, custom_headers).value!
      nil
    end

    #
    # Deletes a function from the streaming job.
    #
    # @param resource_group_name [String] The name of the resource group that
    # contains the resource. You can obtain this value from the Azure Resource
    # Manager API or the portal.
    # @param job_name [String] The name of the streaming job.
    # @param function_name [String] The name of the function.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def delete_with_http_info(resource_group_name, job_name, function_name, custom_headers = nil)
      delete_async(resource_group_name, job_name, function_name, custom_headers).value!
    end

    #
    # Deletes a function from the streaming job.
    #
    # @param resource_group_name [String] The name of the resource group that
    # contains the resource. You can obtain this value from the Azure Resource
    # Manager API or the portal.
    # @param job_name [String] The name of the streaming job.
    # @param function_name [String] The name of the function.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def delete_async(resource_group_name, job_name, function_name, custom_headers = nil)
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'job_name is nil' if job_name.nil?
      fail ArgumentError, 'function_name is nil' if function_name.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.StreamAnalytics/streamingjobs/{jobName}/functions/{functionName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'subscriptionId' => @client.subscription_id,'resourceGroupName' => resource_group_name,'jobName' => job_name,'functionName' => function_name},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:delete, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200 || status_code == 204
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Gets details about the specified function.
    #
    # @param resource_group_name [String] The name of the resource group that
    # contains the resource. You can obtain this value from the Azure Resource
    # Manager API or the portal.
    # @param job_name [String] The name of the streaming job.
    # @param function_name [String] The name of the function.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Function] operation results.
    #
    def get(resource_group_name, job_name, function_name, custom_headers = nil)
      response = get_async(resource_group_name, job_name, function_name, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets details about the specified function.
    #
    # @param resource_group_name [String] The name of the resource group that
    # contains the resource. You can obtain this value from the Azure Resource
    # Manager API or the portal.
    # @param job_name [String] The name of the streaming job.
    # @param function_name [String] The name of the function.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_with_http_info(resource_group_name, job_name, function_name, custom_headers = nil)
      get_async(resource_group_name, job_name, function_name, custom_headers).value!
    end

    #
    # Gets details about the specified function.
    #
    # @param resource_group_name [String] The name of the resource group that
    # contains the resource. You can obtain this value from the Azure Resource
    # Manager API or the portal.
    # @param job_name [String] The name of the streaming job.
    # @param function_name [String] The name of the function.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_async(resource_group_name, job_name, function_name, custom_headers = nil)
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'job_name is nil' if job_name.nil?
      fail ArgumentError, 'function_name is nil' if function_name.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.StreamAnalytics/streamingjobs/{jobName}/functions/{functionName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'subscriptionId' => @client.subscription_id,'resourceGroupName' => resource_group_name,'jobName' => job_name,'functionName' => function_name},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::StreamAnalytics::Models::Function.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Lists all of the functions under the specified streaming job.
    #
    # @param resource_group_name [String] The name of the resource group that
    # contains the resource. You can obtain this value from the Azure Resource
    # Manager API or the portal.
    # @param job_name [String] The name of the streaming job.
    # @param select [String] The $select OData query parameter. This is a
    # comma-separated list of structural properties to include in the response, or
    # “*” to include all properties. By default, all properties are returned except
    # diagnostics. Currently only accepts '*' as a valid value.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array<Function>] operation results.
    #
    def list_by_streaming_job(resource_group_name, job_name, select = nil, custom_headers = nil)
      first_page = list_by_streaming_job_as_lazy(resource_group_name, job_name, select, custom_headers)
      first_page.get_all_items
    end

    #
    # Lists all of the functions under the specified streaming job.
    #
    # @param resource_group_name [String] The name of the resource group that
    # contains the resource. You can obtain this value from the Azure Resource
    # Manager API or the portal.
    # @param job_name [String] The name of the streaming job.
    # @param select [String] The $select OData query parameter. This is a
    # comma-separated list of structural properties to include in the response, or
    # “*” to include all properties. By default, all properties are returned except
    # diagnostics. Currently only accepts '*' as a valid value.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_by_streaming_job_with_http_info(resource_group_name, job_name, select = nil, custom_headers = nil)
      list_by_streaming_job_async(resource_group_name, job_name, select, custom_headers).value!
    end

    #
    # Lists all of the functions under the specified streaming job.
    #
    # @param resource_group_name [String] The name of the resource group that
    # contains the resource. You can obtain this value from the Azure Resource
    # Manager API or the portal.
    # @param job_name [String] The name of the streaming job.
    # @param select [String] The $select OData query parameter. This is a
    # comma-separated list of structural properties to include in the response, or
    # “*” to include all properties. By default, all properties are returned except
    # diagnostics. Currently only accepts '*' as a valid value.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_by_streaming_job_async(resource_group_name, job_name, select = nil, custom_headers = nil)
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'job_name is nil' if job_name.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.StreamAnalytics/streamingjobs/{jobName}/functions'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'subscriptionId' => @client.subscription_id,'resourceGroupName' => resource_group_name,'jobName' => job_name},
          query_params: {'$select' => select,'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::StreamAnalytics::Models::FunctionListResult.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Tests if the information provided for a function is valid. This can range
    # from testing the connection to the underlying web service behind the function
    # or making sure the function code provided is syntactically correct.
    #
    # @param resource_group_name [String] The name of the resource group that
    # contains the resource. You can obtain this value from the Azure Resource
    # Manager API or the portal.
    # @param job_name [String] The name of the streaming job.
    # @param function_name [String] The name of the function.
    # @param function [Function] If the function specified does not already exist,
    # this parameter must contain the full function definition intended to be
    # tested. If the function specified already exists, this parameter can be left
    # null to test the existing function as is or if specified, the properties
    # specified will overwrite the corresponding properties in the existing
    # function (exactly like a PATCH operation) and the resulting function will be
    # tested.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [ResourceTestStatus] operation results.
    #
    def test(resource_group_name, job_name, function_name, function = nil, custom_headers = nil)
      response = test_async(resource_group_name, job_name, function_name, function, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # @param resource_group_name [String] The name of the resource group that
    # contains the resource. You can obtain this value from the Azure Resource
    # Manager API or the portal.
    # @param job_name [String] The name of the streaming job.
    # @param function_name [String] The name of the function.
    # @param function [Function] If the function specified does not already exist,
    # this parameter must contain the full function definition intended to be
    # tested. If the function specified already exists, this parameter can be left
    # null to test the existing function as is or if specified, the properties
    # specified will overwrite the corresponding properties in the existing
    # function (exactly like a PATCH operation) and the resulting function will be
    # tested.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Concurrent::Promise] promise which provides async access to http
    # response.
    #
    def test_async(resource_group_name, job_name, function_name, function = nil, custom_headers = nil)
      # Send request
      promise = begin_test_async(resource_group_name, job_name, function_name, function, custom_headers)

      promise = promise.then do |response|
        # Defining deserialization method.
        deserialize_method = lambda do |parsed_response|
          result_mapper = Azure::ARM::StreamAnalytics::Models::ResourceTestStatus.mapper()
          parsed_response = @client.deserialize(result_mapper, parsed_response)
        end

        # Waiting for response.
        @client.get_long_running_operation_result(response, deserialize_method)
      end

      promise
    end

    #
    # Retrieves the default definition of a function based on the parameters
    # specified.
    #
    # @param resource_group_name [String] The name of the resource group that
    # contains the resource. You can obtain this value from the Azure Resource
    # Manager API or the portal.
    # @param job_name [String] The name of the streaming job.
    # @param function_name [String] The name of the function.
    # @param function_retrieve_default_definition_parameters
    # [FunctionRetrieveDefaultDefinitionParameters] Parameters used to specify the
    # type of function to retrieve the default definition for.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Function] operation results.
    #
    def retrieve_default_definition(resource_group_name, job_name, function_name, function_retrieve_default_definition_parameters = nil, custom_headers = nil)
      response = retrieve_default_definition_async(resource_group_name, job_name, function_name, function_retrieve_default_definition_parameters, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Retrieves the default definition of a function based on the parameters
    # specified.
    #
    # @param resource_group_name [String] The name of the resource group that
    # contains the resource. You can obtain this value from the Azure Resource
    # Manager API or the portal.
    # @param job_name [String] The name of the streaming job.
    # @param function_name [String] The name of the function.
    # @param function_retrieve_default_definition_parameters
    # [FunctionRetrieveDefaultDefinitionParameters] Parameters used to specify the
    # type of function to retrieve the default definition for.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def retrieve_default_definition_with_http_info(resource_group_name, job_name, function_name, function_retrieve_default_definition_parameters = nil, custom_headers = nil)
      retrieve_default_definition_async(resource_group_name, job_name, function_name, function_retrieve_default_definition_parameters, custom_headers).value!
    end

    #
    # Retrieves the default definition of a function based on the parameters
    # specified.
    #
    # @param resource_group_name [String] The name of the resource group that
    # contains the resource. You can obtain this value from the Azure Resource
    # Manager API or the portal.
    # @param job_name [String] The name of the streaming job.
    # @param function_name [String] The name of the function.
    # @param function_retrieve_default_definition_parameters
    # [FunctionRetrieveDefaultDefinitionParameters] Parameters used to specify the
    # type of function to retrieve the default definition for.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def retrieve_default_definition_async(resource_group_name, job_name, function_name, function_retrieve_default_definition_parameters = nil, custom_headers = nil)
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'job_name is nil' if job_name.nil?
      fail ArgumentError, 'function_name is nil' if function_name.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = Azure::ARM::StreamAnalytics::Models::FunctionRetrieveDefaultDefinitionParameters.mapper()
      request_content = @client.serialize(request_mapper,  function_retrieve_default_definition_parameters)
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = 'subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.StreamAnalytics/streamingjobs/{jobName}/functions/{functionName}/RetrieveDefaultDefinition'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'subscriptionId' => @client.subscription_id,'resourceGroupName' => resource_group_name,'jobName' => job_name,'functionName' => function_name},
          query_params: {'api-version' => @client.api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::StreamAnalytics::Models::Function.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Tests if the information provided for a function is valid. This can range
    # from testing the connection to the underlying web service behind the function
    # or making sure the function code provided is syntactically correct.
    #
    # @param resource_group_name [String] The name of the resource group that
    # contains the resource. You can obtain this value from the Azure Resource
    # Manager API or the portal.
    # @param job_name [String] The name of the streaming job.
    # @param function_name [String] The name of the function.
    # @param function [Function] If the function specified does not already exist,
    # this parameter must contain the full function definition intended to be
    # tested. If the function specified already exists, this parameter can be left
    # null to test the existing function as is or if specified, the properties
    # specified will overwrite the corresponding properties in the existing
    # function (exactly like a PATCH operation) and the resulting function will be
    # tested.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [ResourceTestStatus] operation results.
    #
    def begin_test(resource_group_name, job_name, function_name, function = nil, custom_headers = nil)
      response = begin_test_async(resource_group_name, job_name, function_name, function, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Tests if the information provided for a function is valid. This can range
    # from testing the connection to the underlying web service behind the function
    # or making sure the function code provided is syntactically correct.
    #
    # @param resource_group_name [String] The name of the resource group that
    # contains the resource. You can obtain this value from the Azure Resource
    # Manager API or the portal.
    # @param job_name [String] The name of the streaming job.
    # @param function_name [String] The name of the function.
    # @param function [Function] If the function specified does not already exist,
    # this parameter must contain the full function definition intended to be
    # tested. If the function specified already exists, this parameter can be left
    # null to test the existing function as is or if specified, the properties
    # specified will overwrite the corresponding properties in the existing
    # function (exactly like a PATCH operation) and the resulting function will be
    # tested.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def begin_test_with_http_info(resource_group_name, job_name, function_name, function = nil, custom_headers = nil)
      begin_test_async(resource_group_name, job_name, function_name, function, custom_headers).value!
    end

    #
    # Tests if the information provided for a function is valid. This can range
    # from testing the connection to the underlying web service behind the function
    # or making sure the function code provided is syntactically correct.
    #
    # @param resource_group_name [String] The name of the resource group that
    # contains the resource. You can obtain this value from the Azure Resource
    # Manager API or the portal.
    # @param job_name [String] The name of the streaming job.
    # @param function_name [String] The name of the function.
    # @param function [Function] If the function specified does not already exist,
    # this parameter must contain the full function definition intended to be
    # tested. If the function specified already exists, this parameter can be left
    # null to test the existing function as is or if specified, the properties
    # specified will overwrite the corresponding properties in the existing
    # function (exactly like a PATCH operation) and the resulting function will be
    # tested.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def begin_test_async(resource_group_name, job_name, function_name, function = nil, custom_headers = nil)
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'job_name is nil' if job_name.nil?
      fail ArgumentError, 'function_name is nil' if function_name.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = Azure::ARM::StreamAnalytics::Models::Function.mapper()
      request_content = @client.serialize(request_mapper,  function)
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = 'subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.StreamAnalytics/streamingjobs/{jobName}/functions/{functionName}/test'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'subscriptionId' => @client.subscription_id,'resourceGroupName' => resource_group_name,'jobName' => job_name,'functionName' => function_name},
          query_params: {'api-version' => @client.api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200 || status_code == 202
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::StreamAnalytics::Models::ResourceTestStatus.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Lists all of the functions under the specified streaming job.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [FunctionListResult] operation results.
    #
    def list_by_streaming_job_next(next_page_link, custom_headers = nil)
      response = list_by_streaming_job_next_async(next_page_link, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Lists all of the functions under the specified streaming job.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_by_streaming_job_next_with_http_info(next_page_link, custom_headers = nil)
      list_by_streaming_job_next_async(next_page_link, custom_headers).value!
    end

    #
    # Lists all of the functions under the specified streaming job.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_by_streaming_job_next_async(next_page_link, custom_headers = nil)
      fail ArgumentError, 'next_page_link is nil' if next_page_link.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '{nextLink}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          skip_encoding_path_params: {'nextLink' => next_page_link},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::StreamAnalytics::Models::FunctionListResult.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Lists all of the functions under the specified streaming job.
    #
    # @param resource_group_name [String] The name of the resource group that
    # contains the resource. You can obtain this value from the Azure Resource
    # Manager API or the portal.
    # @param job_name [String] The name of the streaming job.
    # @param select [String] The $select OData query parameter. This is a
    # comma-separated list of structural properties to include in the response, or
    # “*” to include all properties. By default, all properties are returned except
    # diagnostics. Currently only accepts '*' as a valid value.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [FunctionListResult] which provide lazy access to pages of the
    # response.
    #
    def list_by_streaming_job_as_lazy(resource_group_name, job_name, select = nil, custom_headers = nil)
      response = list_by_streaming_job_async(resource_group_name, job_name, select, custom_headers).value!
      unless response.nil?
        page = response.body
        page.next_method = Proc.new do |next_page_link|
          list_by_streaming_job_next_async(next_page_link, custom_headers)
        end
        page
      end
    end

  end
end
