# encoding: utf-8
# Code generated by Microsoft (R) AutoRest Code Generator 1.2.2.0
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.

module Azure::ARM::Web
  #
  # WebSite Management Client
  #
  class AppServiceEnvironments
    include MsRestAzure

    #
    # Creates and initializes a new instance of the AppServiceEnvironments class.
    # @param client service class for accessing basic functionality.
    #
    def initialize(client)
      @client = client
    end

    # @return [WebSiteManagementClient] reference to the WebSiteManagementClient
    attr_reader :client

    #
    # Get all App Service Environments for a subscription.
    #
    # Get all App Service Environments for a subscription.
    #
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array<AppServiceEnvironment>] operation results.
    #
    def list(custom_headers = nil)
      first_page = list_as_lazy(custom_headers)
      first_page.get_all_items
    end

    #
    # Get all App Service Environments for a subscription.
    #
    # Get all App Service Environments for a subscription.
    #
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_with_http_info(custom_headers = nil)
      list_async(custom_headers).value!
    end

    #
    # Get all App Service Environments for a subscription.
    #
    # Get all App Service Environments for a subscription.
    #
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_async(custom_headers = nil)
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-09-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/providers/Microsoft.Web/hostingEnvironments'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::AppServiceEnvironmentCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Get all App Service Environments in a resource group.
    #
    # Get all App Service Environments in a resource group.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array<AppServiceEnvironment>] operation results.
    #
    def list_by_resource_group(resource_group_name, custom_headers = nil)
      first_page = list_by_resource_group_as_lazy(resource_group_name, custom_headers)
      first_page.get_all_items
    end

    #
    # Get all App Service Environments in a resource group.
    #
    # Get all App Service Environments in a resource group.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_by_resource_group_with_http_info(resource_group_name, custom_headers = nil)
      list_by_resource_group_async(resource_group_name, custom_headers).value!
    end

    #
    # Get all App Service Environments in a resource group.
    #
    # Get all App Service Environments in a resource group.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_by_resource_group_async(resource_group_name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-09-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::AppServiceEnvironmentCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Get the properties of an App Service Environment.
    #
    # Get the properties of an App Service Environment.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the App Service Environment.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [AppServiceEnvironmentResource] operation results.
    #
    def get(resource_group_name, name, custom_headers = nil)
      response = get_async(resource_group_name, name, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Get the properties of an App Service Environment.
    #
    # Get the properties of an App Service Environment.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the App Service Environment.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_with_http_info(resource_group_name, name, custom_headers = nil)
      get_async(resource_group_name, name, custom_headers).value!
    end

    #
    # Get the properties of an App Service Environment.
    #
    # Get the properties of an App Service Environment.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the App Service Environment.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_async(resource_group_name, name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-09-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::AppServiceEnvironmentResource.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Create or update an App Service Environment.
    #
    # Create or update an App Service Environment.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the App Service Environment.
    # @param hosting_environment_envelope [AppServiceEnvironmentResource]
    # Configuration details of the App Service Environment.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [AppServiceEnvironmentResource] operation results.
    #
    def create_or_update(resource_group_name, name, hosting_environment_envelope, custom_headers = nil)
      response = create_or_update_async(resource_group_name, name, hosting_environment_envelope, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the App Service Environment.
    # @param hosting_environment_envelope [AppServiceEnvironmentResource]
    # Configuration details of the App Service Environment.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Concurrent::Promise] promise which provides async access to http
    # response.
    #
    def create_or_update_async(resource_group_name, name, hosting_environment_envelope, custom_headers = nil)
      # Send request
      promise = begin_create_or_update_async(resource_group_name, name, hosting_environment_envelope, custom_headers)

      promise = promise.then do |response|
        # Defining deserialization method.
        deserialize_method = lambda do |parsed_response|
          result_mapper = Azure::ARM::Web::Models::AppServiceEnvironmentResource.mapper()
          parsed_response = @client.deserialize(result_mapper, parsed_response)
        end

        # Waiting for response.
        @client.get_long_running_operation_result(response, deserialize_method)
      end

      promise
    end

    #
    # Delete an App Service Environment.
    #
    # Delete an App Service Environment.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the App Service Environment.
    # @param force_delete [Boolean] Specify <code>true</code> to force the deletion
    # even if the App Service Environment contains resources. The default is
    # <code>false</code>.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    def delete(resource_group_name, name, force_delete = nil, custom_headers = nil)
      response = delete_async(resource_group_name, name, force_delete, custom_headers).value!
      nil
    end

    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the App Service Environment.
    # @param force_delete [Boolean] Specify <code>true</code> to force the deletion
    # even if the App Service Environment contains resources. The default is
    # <code>false</code>.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Concurrent::Promise] promise which provides async access to http
    # response.
    #
    def delete_async(resource_group_name, name, force_delete = nil, custom_headers = nil)
      # Send request
      promise = begin_delete_async(resource_group_name, name, force_delete, custom_headers)

      promise = promise.then do |response|
        # Defining deserialization method.
        deserialize_method = lambda do |parsed_response|
        end

        # Waiting for response.
        @client.get_long_running_operation_result(response, deserialize_method)
      end

      promise
    end

    #
    # Get the used, available, and total worker capacity an App Service
    # Environment.
    #
    # Get the used, available, and total worker capacity an App Service
    # Environment.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the App Service Environment.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array<StampCapacity>] operation results.
    #
    def list_capacities(resource_group_name, name, custom_headers = nil)
      first_page = list_capacities_as_lazy(resource_group_name, name, custom_headers)
      first_page.get_all_items
    end

    #
    # Get the used, available, and total worker capacity an App Service
    # Environment.
    #
    # Get the used, available, and total worker capacity an App Service
    # Environment.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the App Service Environment.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_capacities_with_http_info(resource_group_name, name, custom_headers = nil)
      list_capacities_async(resource_group_name, name, custom_headers).value!
    end

    #
    # Get the used, available, and total worker capacity an App Service
    # Environment.
    #
    # Get the used, available, and total worker capacity an App Service
    # Environment.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the App Service Environment.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_capacities_async(resource_group_name, name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-09-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/capacities/compute'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::StampCapacityCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Get IP addresses assigned to an App Service Environment.
    #
    # Get IP addresses assigned to an App Service Environment.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the App Service Environment.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [AddressResponse] operation results.
    #
    def list_vips(resource_group_name, name, custom_headers = nil)
      response = list_vips_async(resource_group_name, name, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Get IP addresses assigned to an App Service Environment.
    #
    # Get IP addresses assigned to an App Service Environment.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the App Service Environment.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_vips_with_http_info(resource_group_name, name, custom_headers = nil)
      list_vips_async(resource_group_name, name, custom_headers).value!
    end

    #
    # Get IP addresses assigned to an App Service Environment.
    #
    # Get IP addresses assigned to an App Service Environment.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the App Service Environment.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_vips_async(resource_group_name, name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-09-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/capacities/virtualip'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::AddressResponse.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Get diagnostic information for an App Service Environment.
    #
    # Get diagnostic information for an App Service Environment.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the App Service Environment.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array] operation results.
    #
    def list_diagnostics(resource_group_name, name, custom_headers = nil)
      response = list_diagnostics_async(resource_group_name, name, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Get diagnostic information for an App Service Environment.
    #
    # Get diagnostic information for an App Service Environment.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the App Service Environment.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_diagnostics_with_http_info(resource_group_name, name, custom_headers = nil)
      list_diagnostics_async(resource_group_name, name, custom_headers).value!
    end

    #
    # Get diagnostic information for an App Service Environment.
    #
    # Get diagnostic information for an App Service Environment.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the App Service Environment.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_diagnostics_async(resource_group_name, name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-09-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/diagnostics'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = {
              required: false,
              serialized_name: 'parsed_response',
              type: {
                name: 'Sequence',
                element: {
                    required: false,
                    serialized_name: 'HostingEnvironmentDiagnosticsElementType',
                    type: {
                      name: 'Composite',
                      class_name: 'HostingEnvironmentDiagnostics'
                    }
                }
              }
            }
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Get a diagnostics item for an App Service Environment.
    #
    # Get a diagnostics item for an App Service Environment.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the App Service Environment.
    # @param diagnostics_name [String] Name of the diagnostics item.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [HostingEnvironmentDiagnostics] operation results.
    #
    def get_diagnostics_item(resource_group_name, name, diagnostics_name, custom_headers = nil)
      response = get_diagnostics_item_async(resource_group_name, name, diagnostics_name, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Get a diagnostics item for an App Service Environment.
    #
    # Get a diagnostics item for an App Service Environment.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the App Service Environment.
    # @param diagnostics_name [String] Name of the diagnostics item.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_diagnostics_item_with_http_info(resource_group_name, name, diagnostics_name, custom_headers = nil)
      get_diagnostics_item_async(resource_group_name, name, diagnostics_name, custom_headers).value!
    end

    #
    # Get a diagnostics item for an App Service Environment.
    #
    # Get a diagnostics item for an App Service Environment.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the App Service Environment.
    # @param diagnostics_name [String] Name of the diagnostics item.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_diagnostics_item_async(resource_group_name, name, diagnostics_name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'diagnostics_name is nil' if diagnostics_name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-09-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/diagnostics/{diagnosticsName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'diagnosticsName' => diagnostics_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::HostingEnvironmentDiagnostics.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Get global metric definitions of an App Service Environment.
    #
    # Get global metric definitions of an App Service Environment.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the App Service Environment.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MetricDefinition] operation results.
    #
    def list_metric_definitions(resource_group_name, name, custom_headers = nil)
      response = list_metric_definitions_async(resource_group_name, name, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Get global metric definitions of an App Service Environment.
    #
    # Get global metric definitions of an App Service Environment.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the App Service Environment.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_metric_definitions_with_http_info(resource_group_name, name, custom_headers = nil)
      list_metric_definitions_async(resource_group_name, name, custom_headers).value!
    end

    #
    # Get global metric definitions of an App Service Environment.
    #
    # Get global metric definitions of an App Service Environment.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the App Service Environment.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_metric_definitions_async(resource_group_name, name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-09-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/metricdefinitions'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::MetricDefinition.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Get global metrics of an App Service Environment.
    #
    # Get global metrics of an App Service Environment.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the App Service Environment.
    # @param details [Boolean] Specify <code>true</code> to include instance
    # details. The default is <code>false</code>.
    # @param filter [String] Return only usages/metrics specified in the filter.
    # Filter conforms to odata syntax. Example: $filter=(name.value eq 'Metric1' or
    # name.value eq 'Metric2') and startTime eq '2014-01-01T00:00:00Z' and endTime
    # eq '2014-12-31T23:59:59Z' and timeGrain eq duration'[Hour|Minute|Day]'.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array<ResourceMetric>] operation results.
    #
    def list_metrics(resource_group_name, name, details = nil, filter = nil, custom_headers = nil)
      first_page = list_metrics_as_lazy(resource_group_name, name, details, filter, custom_headers)
      first_page.get_all_items
    end

    #
    # Get global metrics of an App Service Environment.
    #
    # Get global metrics of an App Service Environment.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the App Service Environment.
    # @param details [Boolean] Specify <code>true</code> to include instance
    # details. The default is <code>false</code>.
    # @param filter [String] Return only usages/metrics specified in the filter.
    # Filter conforms to odata syntax. Example: $filter=(name.value eq 'Metric1' or
    # name.value eq 'Metric2') and startTime eq '2014-01-01T00:00:00Z' and endTime
    # eq '2014-12-31T23:59:59Z' and timeGrain eq duration'[Hour|Minute|Day]'.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_metrics_with_http_info(resource_group_name, name, details = nil, filter = nil, custom_headers = nil)
      list_metrics_async(resource_group_name, name, details, filter, custom_headers).value!
    end

    #
    # Get global metrics of an App Service Environment.
    #
    # Get global metrics of an App Service Environment.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the App Service Environment.
    # @param details [Boolean] Specify <code>true</code> to include instance
    # details. The default is <code>false</code>.
    # @param filter [String] Return only usages/metrics specified in the filter.
    # Filter conforms to odata syntax. Example: $filter=(name.value eq 'Metric1' or
    # name.value eq 'Metric2') and startTime eq '2014-01-01T00:00:00Z' and endTime
    # eq '2014-12-31T23:59:59Z' and timeGrain eq duration'[Hour|Minute|Day]'.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_metrics_async(resource_group_name, name, details = nil, filter = nil, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-09-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/metrics'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'details' => details,'api-version' => api_version},
          skip_encoding_query_params: {'$filter' => filter},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::ResourceMetricCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Get all multi-role pools.
    #
    # Get all multi-role pools.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the App Service Environment.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array<WorkerPoolResource>] operation results.
    #
    def list_multi_role_pools(resource_group_name, name, custom_headers = nil)
      first_page = list_multi_role_pools_as_lazy(resource_group_name, name, custom_headers)
      first_page.get_all_items
    end

    #
    # Get all multi-role pools.
    #
    # Get all multi-role pools.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the App Service Environment.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_multi_role_pools_with_http_info(resource_group_name, name, custom_headers = nil)
      list_multi_role_pools_async(resource_group_name, name, custom_headers).value!
    end

    #
    # Get all multi-role pools.
    #
    # Get all multi-role pools.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the App Service Environment.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_multi_role_pools_async(resource_group_name, name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-09-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/multiRolePools'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::WorkerPoolCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Get properties of a multi-role pool.
    #
    # Get properties of a multi-role pool.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the App Service Environment.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [WorkerPoolResource] operation results.
    #
    def get_multi_role_pool(resource_group_name, name, custom_headers = nil)
      response = get_multi_role_pool_async(resource_group_name, name, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Get properties of a multi-role pool.
    #
    # Get properties of a multi-role pool.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the App Service Environment.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_multi_role_pool_with_http_info(resource_group_name, name, custom_headers = nil)
      get_multi_role_pool_async(resource_group_name, name, custom_headers).value!
    end

    #
    # Get properties of a multi-role pool.
    #
    # Get properties of a multi-role pool.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the App Service Environment.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_multi_role_pool_async(resource_group_name, name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-09-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/multiRolePools/default'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::WorkerPoolResource.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Create or update a multi-role pool.
    #
    # Create or update a multi-role pool.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the App Service Environment.
    # @param multi_role_pool_envelope [WorkerPoolResource] Properties of the
    # multi-role pool.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [WorkerPoolResource] operation results.
    #
    def create_or_update_multi_role_pool(resource_group_name, name, multi_role_pool_envelope, custom_headers = nil)
      response = create_or_update_multi_role_pool_async(resource_group_name, name, multi_role_pool_envelope, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the App Service Environment.
    # @param multi_role_pool_envelope [WorkerPoolResource] Properties of the
    # multi-role pool.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Concurrent::Promise] promise which provides async access to http
    # response.
    #
    def create_or_update_multi_role_pool_async(resource_group_name, name, multi_role_pool_envelope, custom_headers = nil)
      # Send request
      promise = begin_create_or_update_multi_role_pool_async(resource_group_name, name, multi_role_pool_envelope, custom_headers)

      promise = promise.then do |response|
        # Defining deserialization method.
        deserialize_method = lambda do |parsed_response|
          result_mapper = Azure::ARM::Web::Models::WorkerPoolResource.mapper()
          parsed_response = @client.deserialize(result_mapper, parsed_response)
        end

        # Waiting for response.
        @client.get_long_running_operation_result(response, deserialize_method)
      end

      promise
    end

    #
    # Get metric definitions for a specific instance of a multi-role pool of an App
    # Service Environment.
    #
    # Get metric definitions for a specific instance of a multi-role pool of an App
    # Service Environment.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the App Service Environment.
    # @param instance [String] Name of the instance in the multi-role pool.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array<ResourceMetricDefinition>] operation results.
    #
    def list_multi_role_pool_instance_metric_definitions(resource_group_name, name, instance, custom_headers = nil)
      first_page = list_multi_role_pool_instance_metric_definitions_as_lazy(resource_group_name, name, instance, custom_headers)
      first_page.get_all_items
    end

    #
    # Get metric definitions for a specific instance of a multi-role pool of an App
    # Service Environment.
    #
    # Get metric definitions for a specific instance of a multi-role pool of an App
    # Service Environment.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the App Service Environment.
    # @param instance [String] Name of the instance in the multi-role pool.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_multi_role_pool_instance_metric_definitions_with_http_info(resource_group_name, name, instance, custom_headers = nil)
      list_multi_role_pool_instance_metric_definitions_async(resource_group_name, name, instance, custom_headers).value!
    end

    #
    # Get metric definitions for a specific instance of a multi-role pool of an App
    # Service Environment.
    #
    # Get metric definitions for a specific instance of a multi-role pool of an App
    # Service Environment.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the App Service Environment.
    # @param instance [String] Name of the instance in the multi-role pool.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_multi_role_pool_instance_metric_definitions_async(resource_group_name, name, instance, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'instance is nil' if instance.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-09-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/multiRolePools/default/instances/{instance}/metricdefinitions'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'instance' => instance,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::ResourceMetricDefinitionCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Get metrics for a specific instance of a multi-role pool of an App Service
    # Environment.
    #
    # Get metrics for a specific instance of a multi-role pool of an App Service
    # Environment.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the App Service Environment.
    # @param instance [String] Name of the instance in the multi-role pool.
    # @param details [Boolean] Specify <code>true</code> to include instance
    # details. The default is <code>false</code>.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array<ResourceMetric>] operation results.
    #
    def list_multi_role_pool_instance_metrics(resource_group_name, name, instance, details = nil, custom_headers = nil)
      first_page = list_multi_role_pool_instance_metrics_as_lazy(resource_group_name, name, instance, details, custom_headers)
      first_page.get_all_items
    end

    #
    # Get metrics for a specific instance of a multi-role pool of an App Service
    # Environment.
    #
    # Get metrics for a specific instance of a multi-role pool of an App Service
    # Environment.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the App Service Environment.
    # @param instance [String] Name of the instance in the multi-role pool.
    # @param details [Boolean] Specify <code>true</code> to include instance
    # details. The default is <code>false</code>.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_multi_role_pool_instance_metrics_with_http_info(resource_group_name, name, instance, details = nil, custom_headers = nil)
      list_multi_role_pool_instance_metrics_async(resource_group_name, name, instance, details, custom_headers).value!
    end

    #
    # Get metrics for a specific instance of a multi-role pool of an App Service
    # Environment.
    #
    # Get metrics for a specific instance of a multi-role pool of an App Service
    # Environment.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the App Service Environment.
    # @param instance [String] Name of the instance in the multi-role pool.
    # @param details [Boolean] Specify <code>true</code> to include instance
    # details. The default is <code>false</code>.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_multi_role_pool_instance_metrics_async(resource_group_name, name, instance, details = nil, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'instance is nil' if instance.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-09-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/multiRolePools/default/instances/{instance}metrics'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'instance' => instance,'subscriptionId' => @client.subscription_id},
          query_params: {'details' => details,'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::ResourceMetricCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Get metric definitions for a multi-role pool of an App Service Environment.
    #
    # Get metric definitions for a multi-role pool of an App Service Environment.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the App Service Environment.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array<ResourceMetricDefinition>] operation results.
    #
    def list_multi_role_metric_definitions(resource_group_name, name, custom_headers = nil)
      first_page = list_multi_role_metric_definitions_as_lazy(resource_group_name, name, custom_headers)
      first_page.get_all_items
    end

    #
    # Get metric definitions for a multi-role pool of an App Service Environment.
    #
    # Get metric definitions for a multi-role pool of an App Service Environment.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the App Service Environment.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_multi_role_metric_definitions_with_http_info(resource_group_name, name, custom_headers = nil)
      list_multi_role_metric_definitions_async(resource_group_name, name, custom_headers).value!
    end

    #
    # Get metric definitions for a multi-role pool of an App Service Environment.
    #
    # Get metric definitions for a multi-role pool of an App Service Environment.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the App Service Environment.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_multi_role_metric_definitions_async(resource_group_name, name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-09-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/multiRolePools/default/metricdefinitions'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::ResourceMetricDefinitionCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Get metrics for a multi-role pool of an App Service Environment.
    #
    # Get metrics for a multi-role pool of an App Service Environment.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the App Service Environment.
    # @param start_time [String] Beginning time of the metrics query.
    # @param end_time [String] End time of the metrics query.
    # @param time_grain [String] Time granularity of the metrics query.
    # @param details [Boolean] Specify <code>true</code> to include instance
    # details. The default is <code>false</code>.
    # @param filter [String] Return only usages/metrics specified in the filter.
    # Filter conforms to odata syntax. Example: $filter=(name.value eq 'Metric1' or
    # name.value eq 'Metric2') and startTime eq '2014-01-01T00:00:00Z' and endTime
    # eq '2014-12-31T23:59:59Z' and timeGrain eq duration'[Hour|Minute|Day]'.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array<ResourceMetric>] operation results.
    #
    def list_multi_role_metrics(resource_group_name, name, start_time = nil, end_time = nil, time_grain = nil, details = nil, filter = nil, custom_headers = nil)
      first_page = list_multi_role_metrics_as_lazy(resource_group_name, name, start_time, end_time, time_grain, details, filter, custom_headers)
      first_page.get_all_items
    end

    #
    # Get metrics for a multi-role pool of an App Service Environment.
    #
    # Get metrics for a multi-role pool of an App Service Environment.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the App Service Environment.
    # @param start_time [String] Beginning time of the metrics query.
    # @param end_time [String] End time of the metrics query.
    # @param time_grain [String] Time granularity of the metrics query.
    # @param details [Boolean] Specify <code>true</code> to include instance
    # details. The default is <code>false</code>.
    # @param filter [String] Return only usages/metrics specified in the filter.
    # Filter conforms to odata syntax. Example: $filter=(name.value eq 'Metric1' or
    # name.value eq 'Metric2') and startTime eq '2014-01-01T00:00:00Z' and endTime
    # eq '2014-12-31T23:59:59Z' and timeGrain eq duration'[Hour|Minute|Day]'.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_multi_role_metrics_with_http_info(resource_group_name, name, start_time = nil, end_time = nil, time_grain = nil, details = nil, filter = nil, custom_headers = nil)
      list_multi_role_metrics_async(resource_group_name, name, start_time, end_time, time_grain, details, filter, custom_headers).value!
    end

    #
    # Get metrics for a multi-role pool of an App Service Environment.
    #
    # Get metrics for a multi-role pool of an App Service Environment.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the App Service Environment.
    # @param start_time [String] Beginning time of the metrics query.
    # @param end_time [String] End time of the metrics query.
    # @param time_grain [String] Time granularity of the metrics query.
    # @param details [Boolean] Specify <code>true</code> to include instance
    # details. The default is <code>false</code>.
    # @param filter [String] Return only usages/metrics specified in the filter.
    # Filter conforms to odata syntax. Example: $filter=(name.value eq 'Metric1' or
    # name.value eq 'Metric2') and startTime eq '2014-01-01T00:00:00Z' and endTime
    # eq '2014-12-31T23:59:59Z' and timeGrain eq duration'[Hour|Minute|Day]'.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_multi_role_metrics_async(resource_group_name, name, start_time = nil, end_time = nil, time_grain = nil, details = nil, filter = nil, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-09-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/multiRolePools/default/metrics'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'startTime' => start_time,'endTime' => end_time,'timeGrain' => time_grain,'details' => details,'api-version' => api_version},
          skip_encoding_query_params: {'$filter' => filter},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::ResourceMetricCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Get available SKUs for scaling a multi-role pool.
    #
    # Get available SKUs for scaling a multi-role pool.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the App Service Environment.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array<SkuInfo>] operation results.
    #
    def list_multi_role_pool_skus(resource_group_name, name, custom_headers = nil)
      first_page = list_multi_role_pool_skus_as_lazy(resource_group_name, name, custom_headers)
      first_page.get_all_items
    end

    #
    # Get available SKUs for scaling a multi-role pool.
    #
    # Get available SKUs for scaling a multi-role pool.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the App Service Environment.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_multi_role_pool_skus_with_http_info(resource_group_name, name, custom_headers = nil)
      list_multi_role_pool_skus_async(resource_group_name, name, custom_headers).value!
    end

    #
    # Get available SKUs for scaling a multi-role pool.
    #
    # Get available SKUs for scaling a multi-role pool.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the App Service Environment.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_multi_role_pool_skus_async(resource_group_name, name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-09-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/multiRolePools/default/skus'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::SkuInfoCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Get usage metrics for a multi-role pool of an App Service Environment.
    #
    # Get usage metrics for a multi-role pool of an App Service Environment.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the App Service Environment.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array<Usage>] operation results.
    #
    def list_multi_role_usages(resource_group_name, name, custom_headers = nil)
      first_page = list_multi_role_usages_as_lazy(resource_group_name, name, custom_headers)
      first_page.get_all_items
    end

    #
    # Get usage metrics for a multi-role pool of an App Service Environment.
    #
    # Get usage metrics for a multi-role pool of an App Service Environment.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the App Service Environment.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_multi_role_usages_with_http_info(resource_group_name, name, custom_headers = nil)
      list_multi_role_usages_async(resource_group_name, name, custom_headers).value!
    end

    #
    # Get usage metrics for a multi-role pool of an App Service Environment.
    #
    # Get usage metrics for a multi-role pool of an App Service Environment.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the App Service Environment.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_multi_role_usages_async(resource_group_name, name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-09-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/multiRolePools/default/usages'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::UsageCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # List all currently running operations on the App Service Environment.
    #
    # List all currently running operations on the App Service Environment.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the App Service Environment.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array] operation results.
    #
    def list_operations(resource_group_name, name, custom_headers = nil)
      response = list_operations_async(resource_group_name, name, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # List all currently running operations on the App Service Environment.
    #
    # List all currently running operations on the App Service Environment.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the App Service Environment.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_operations_with_http_info(resource_group_name, name, custom_headers = nil)
      list_operations_async(resource_group_name, name, custom_headers).value!
    end

    #
    # List all currently running operations on the App Service Environment.
    #
    # List all currently running operations on the App Service Environment.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the App Service Environment.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_operations_async(resource_group_name, name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-09-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/operations'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = {
              required: false,
              serialized_name: 'parsed_response',
              type: {
                name: 'Sequence',
                element: {
                    required: false,
                    serialized_name: 'OperationElementType',
                    type: {
                      name: 'Composite',
                      class_name: 'Operation'
                    }
                }
              }
            }
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Reboot all machines in an App Service Environment.
    #
    # Reboot all machines in an App Service Environment.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the App Service Environment.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    #
    def reboot(resource_group_name, name, custom_headers = nil)
      response = reboot_async(resource_group_name, name, custom_headers).value!
      nil
    end

    #
    # Reboot all machines in an App Service Environment.
    #
    # Reboot all machines in an App Service Environment.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the App Service Environment.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def reboot_with_http_info(resource_group_name, name, custom_headers = nil)
      reboot_async(resource_group_name, name, custom_headers).value!
    end

    #
    # Reboot all machines in an App Service Environment.
    #
    # Reboot all machines in an App Service Environment.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the App Service Environment.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def reboot_async(resource_group_name, name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-09-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/reboot'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 202 || status_code == 400 || status_code == 404 || status_code == 409
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Resume an App Service Environment.
    #
    # Resume an App Service Environment.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the App Service Environment.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array<Site>] which provide lazy access to pages of the response.
    #
    def resume(resource_group_name, name, custom_headers = nil)
      response = resume_async(resource_group_name, name, custom_headers).value!
      unless response.nil?
        page = response.body
        page.next_method = Proc.new do |next_page_link|
          resume_next_async(next_page_link, custom_headers)
        end
        page
      end
    end
    #
    # Resume an App Service Environment.
    #
    # Resume an App Service Environment.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the App Service Environment.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array<Site>] operation results.
    #
    def resume(resource_group_name, name, custom_headers = nil)
      first_page = resume_as_lazy(resource_group_name, name, custom_headers)
      first_page.get_all_items
    end

    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the App Service Environment.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Concurrent::Promise] promise which provides async access to http
    # response.
    #
    def resume_async(resource_group_name, name, custom_headers = nil)
      # Send request
      promise = begin_resume_async(resource_group_name, name, custom_headers)

      promise = promise.then do |response|
        # Defining deserialization method.
        deserialize_method = lambda do |parsed_response|
          result_mapper = Azure::ARM::Web::Models::WebAppCollection.mapper()
          parsed_response = @client.deserialize(result_mapper, parsed_response)
        end

        # Waiting for response.
        @client.get_long_running_operation_result(response, deserialize_method)
      end

      promise
    end

    #
    # Get all App Service plans in an App Service Environment.
    #
    # Get all App Service plans in an App Service Environment.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the App Service Environment.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array<AppServicePlan>] operation results.
    #
    def list_app_service_plans(resource_group_name, name, custom_headers = nil)
      first_page = list_app_service_plans_as_lazy(resource_group_name, name, custom_headers)
      first_page.get_all_items
    end

    #
    # Get all App Service plans in an App Service Environment.
    #
    # Get all App Service plans in an App Service Environment.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the App Service Environment.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_app_service_plans_with_http_info(resource_group_name, name, custom_headers = nil)
      list_app_service_plans_async(resource_group_name, name, custom_headers).value!
    end

    #
    # Get all App Service plans in an App Service Environment.
    #
    # Get all App Service plans in an App Service Environment.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the App Service Environment.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_app_service_plans_async(resource_group_name, name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-09-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/serverfarms'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::AppServicePlanCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Get all apps in an App Service Environment.
    #
    # Get all apps in an App Service Environment.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the App Service Environment.
    # @param properties_to_include [String] Comma separated list of app properties
    # to include.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array<Site>] operation results.
    #
    def list_web_apps(resource_group_name, name, properties_to_include = nil, custom_headers = nil)
      first_page = list_web_apps_as_lazy(resource_group_name, name, properties_to_include, custom_headers)
      first_page.get_all_items
    end

    #
    # Get all apps in an App Service Environment.
    #
    # Get all apps in an App Service Environment.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the App Service Environment.
    # @param properties_to_include [String] Comma separated list of app properties
    # to include.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_web_apps_with_http_info(resource_group_name, name, properties_to_include = nil, custom_headers = nil)
      list_web_apps_async(resource_group_name, name, properties_to_include, custom_headers).value!
    end

    #
    # Get all apps in an App Service Environment.
    #
    # Get all apps in an App Service Environment.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the App Service Environment.
    # @param properties_to_include [String] Comma separated list of app properties
    # to include.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_web_apps_async(resource_group_name, name, properties_to_include = nil, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-09-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/sites'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'propertiesToInclude' => properties_to_include,'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::WebAppCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Suspend an App Service Environment.
    #
    # Suspend an App Service Environment.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the App Service Environment.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array<Site>] which provide lazy access to pages of the response.
    #
    def suspend(resource_group_name, name, custom_headers = nil)
      response = suspend_async(resource_group_name, name, custom_headers).value!
      unless response.nil?
        page = response.body
        page.next_method = Proc.new do |next_page_link|
          suspend_next_async(next_page_link, custom_headers)
        end
        page
      end
    end
    #
    # Suspend an App Service Environment.
    #
    # Suspend an App Service Environment.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the App Service Environment.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array<Site>] operation results.
    #
    def suspend(resource_group_name, name, custom_headers = nil)
      first_page = suspend_as_lazy(resource_group_name, name, custom_headers)
      first_page.get_all_items
    end

    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the App Service Environment.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Concurrent::Promise] promise which provides async access to http
    # response.
    #
    def suspend_async(resource_group_name, name, custom_headers = nil)
      # Send request
      promise = begin_suspend_async(resource_group_name, name, custom_headers)

      promise = promise.then do |response|
        # Defining deserialization method.
        deserialize_method = lambda do |parsed_response|
          result_mapper = Azure::ARM::Web::Models::WebAppCollection.mapper()
          parsed_response = @client.deserialize(result_mapper, parsed_response)
        end

        # Waiting for response.
        @client.get_long_running_operation_result(response, deserialize_method)
      end

      promise
    end

    #
    # Get global usage metrics of an App Service Environment.
    #
    # Get global usage metrics of an App Service Environment.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the App Service Environment.
    # @param filter [String] Return only usages/metrics specified in the filter.
    # Filter conforms to odata syntax. Example: $filter=(name.value eq 'Metric1' or
    # name.value eq 'Metric2') and startTime eq '2014-01-01T00:00:00Z' and endTime
    # eq '2014-12-31T23:59:59Z' and timeGrain eq duration'[Hour|Minute|Day]'.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array<CsmUsageQuota>] operation results.
    #
    def list_usages(resource_group_name, name, filter = nil, custom_headers = nil)
      first_page = list_usages_as_lazy(resource_group_name, name, filter, custom_headers)
      first_page.get_all_items
    end

    #
    # Get global usage metrics of an App Service Environment.
    #
    # Get global usage metrics of an App Service Environment.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the App Service Environment.
    # @param filter [String] Return only usages/metrics specified in the filter.
    # Filter conforms to odata syntax. Example: $filter=(name.value eq 'Metric1' or
    # name.value eq 'Metric2') and startTime eq '2014-01-01T00:00:00Z' and endTime
    # eq '2014-12-31T23:59:59Z' and timeGrain eq duration'[Hour|Minute|Day]'.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_usages_with_http_info(resource_group_name, name, filter = nil, custom_headers = nil)
      list_usages_async(resource_group_name, name, filter, custom_headers).value!
    end

    #
    # Get global usage metrics of an App Service Environment.
    #
    # Get global usage metrics of an App Service Environment.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the App Service Environment.
    # @param filter [String] Return only usages/metrics specified in the filter.
    # Filter conforms to odata syntax. Example: $filter=(name.value eq 'Metric1' or
    # name.value eq 'Metric2') and startTime eq '2014-01-01T00:00:00Z' and endTime
    # eq '2014-12-31T23:59:59Z' and timeGrain eq duration'[Hour|Minute|Day]'.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_usages_async(resource_group_name, name, filter = nil, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-09-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/usages'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          skip_encoding_query_params: {'$filter' => filter},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::CsmUsageQuotaCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Get all worker pools of an App Service Environment.
    #
    # Get all worker pools of an App Service Environment.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the App Service Environment.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array<WorkerPoolResource>] operation results.
    #
    def list_worker_pools(resource_group_name, name, custom_headers = nil)
      first_page = list_worker_pools_as_lazy(resource_group_name, name, custom_headers)
      first_page.get_all_items
    end

    #
    # Get all worker pools of an App Service Environment.
    #
    # Get all worker pools of an App Service Environment.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the App Service Environment.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_worker_pools_with_http_info(resource_group_name, name, custom_headers = nil)
      list_worker_pools_async(resource_group_name, name, custom_headers).value!
    end

    #
    # Get all worker pools of an App Service Environment.
    #
    # Get all worker pools of an App Service Environment.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the App Service Environment.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_worker_pools_async(resource_group_name, name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-09-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/workerPools'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::WorkerPoolCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Get properties of a worker pool.
    #
    # Get properties of a worker pool.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the App Service Environment.
    # @param worker_pool_name [String] Name of the worker pool.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [WorkerPoolResource] operation results.
    #
    def get_worker_pool(resource_group_name, name, worker_pool_name, custom_headers = nil)
      response = get_worker_pool_async(resource_group_name, name, worker_pool_name, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Get properties of a worker pool.
    #
    # Get properties of a worker pool.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the App Service Environment.
    # @param worker_pool_name [String] Name of the worker pool.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_worker_pool_with_http_info(resource_group_name, name, worker_pool_name, custom_headers = nil)
      get_worker_pool_async(resource_group_name, name, worker_pool_name, custom_headers).value!
    end

    #
    # Get properties of a worker pool.
    #
    # Get properties of a worker pool.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the App Service Environment.
    # @param worker_pool_name [String] Name of the worker pool.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_worker_pool_async(resource_group_name, name, worker_pool_name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'worker_pool_name is nil' if worker_pool_name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-09-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/workerPools/{workerPoolName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'workerPoolName' => worker_pool_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::WorkerPoolResource.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Create or update a worker pool.
    #
    # Create or update a worker pool.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the App Service Environment.
    # @param worker_pool_name [String] Name of the worker pool.
    # @param worker_pool_envelope [WorkerPoolResource] Properties of the worker
    # pool.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [WorkerPoolResource] operation results.
    #
    def create_or_update_worker_pool(resource_group_name, name, worker_pool_name, worker_pool_envelope, custom_headers = nil)
      response = create_or_update_worker_pool_async(resource_group_name, name, worker_pool_name, worker_pool_envelope, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the App Service Environment.
    # @param worker_pool_name [String] Name of the worker pool.
    # @param worker_pool_envelope [WorkerPoolResource] Properties of the worker
    # pool.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Concurrent::Promise] promise which provides async access to http
    # response.
    #
    def create_or_update_worker_pool_async(resource_group_name, name, worker_pool_name, worker_pool_envelope, custom_headers = nil)
      # Send request
      promise = begin_create_or_update_worker_pool_async(resource_group_name, name, worker_pool_name, worker_pool_envelope, custom_headers)

      promise = promise.then do |response|
        # Defining deserialization method.
        deserialize_method = lambda do |parsed_response|
          result_mapper = Azure::ARM::Web::Models::WorkerPoolResource.mapper()
          parsed_response = @client.deserialize(result_mapper, parsed_response)
        end

        # Waiting for response.
        @client.get_long_running_operation_result(response, deserialize_method)
      end

      promise
    end

    #
    # Get metric definitions for a specific instance of a worker pool of an App
    # Service Environment.
    #
    # Get metric definitions for a specific instance of a worker pool of an App
    # Service Environment.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the App Service Environment.
    # @param worker_pool_name [String] Name of the worker pool.
    # @param instance [String] Name of the instance in the worker pool.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array<ResourceMetricDefinition>] operation results.
    #
    def list_worker_pool_instance_metric_definitions(resource_group_name, name, worker_pool_name, instance, custom_headers = nil)
      first_page = list_worker_pool_instance_metric_definitions_as_lazy(resource_group_name, name, worker_pool_name, instance, custom_headers)
      first_page.get_all_items
    end

    #
    # Get metric definitions for a specific instance of a worker pool of an App
    # Service Environment.
    #
    # Get metric definitions for a specific instance of a worker pool of an App
    # Service Environment.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the App Service Environment.
    # @param worker_pool_name [String] Name of the worker pool.
    # @param instance [String] Name of the instance in the worker pool.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_worker_pool_instance_metric_definitions_with_http_info(resource_group_name, name, worker_pool_name, instance, custom_headers = nil)
      list_worker_pool_instance_metric_definitions_async(resource_group_name, name, worker_pool_name, instance, custom_headers).value!
    end

    #
    # Get metric definitions for a specific instance of a worker pool of an App
    # Service Environment.
    #
    # Get metric definitions for a specific instance of a worker pool of an App
    # Service Environment.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the App Service Environment.
    # @param worker_pool_name [String] Name of the worker pool.
    # @param instance [String] Name of the instance in the worker pool.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_worker_pool_instance_metric_definitions_async(resource_group_name, name, worker_pool_name, instance, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'worker_pool_name is nil' if worker_pool_name.nil?
      fail ArgumentError, 'instance is nil' if instance.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-09-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/workerPools/{workerPoolName}/instances/{instance}/metricdefinitions'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'workerPoolName' => worker_pool_name,'instance' => instance,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::ResourceMetricDefinitionCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Get metrics for a specific instance of a worker pool of an App Service
    # Environment.
    #
    # Get metrics for a specific instance of a worker pool of an App Service
    # Environment.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the App Service Environment.
    # @param worker_pool_name [String] Name of the worker pool.
    # @param instance [String] Name of the instance in the worker pool.
    # @param details [Boolean] Specify <code>true</code> to include instance
    # details. The default is <code>false</code>.
    # @param filter [String] Return only usages/metrics specified in the filter.
    # Filter conforms to odata syntax. Example: $filter=(name.value eq 'Metric1' or
    # name.value eq 'Metric2') and startTime eq '2014-01-01T00:00:00Z' and endTime
    # eq '2014-12-31T23:59:59Z' and timeGrain eq duration'[Hour|Minute|Day]'.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array<ResourceMetric>] operation results.
    #
    def list_worker_pool_instance_metrics(resource_group_name, name, worker_pool_name, instance, details = nil, filter = nil, custom_headers = nil)
      first_page = list_worker_pool_instance_metrics_as_lazy(resource_group_name, name, worker_pool_name, instance, details, filter, custom_headers)
      first_page.get_all_items
    end

    #
    # Get metrics for a specific instance of a worker pool of an App Service
    # Environment.
    #
    # Get metrics for a specific instance of a worker pool of an App Service
    # Environment.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the App Service Environment.
    # @param worker_pool_name [String] Name of the worker pool.
    # @param instance [String] Name of the instance in the worker pool.
    # @param details [Boolean] Specify <code>true</code> to include instance
    # details. The default is <code>false</code>.
    # @param filter [String] Return only usages/metrics specified in the filter.
    # Filter conforms to odata syntax. Example: $filter=(name.value eq 'Metric1' or
    # name.value eq 'Metric2') and startTime eq '2014-01-01T00:00:00Z' and endTime
    # eq '2014-12-31T23:59:59Z' and timeGrain eq duration'[Hour|Minute|Day]'.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_worker_pool_instance_metrics_with_http_info(resource_group_name, name, worker_pool_name, instance, details = nil, filter = nil, custom_headers = nil)
      list_worker_pool_instance_metrics_async(resource_group_name, name, worker_pool_name, instance, details, filter, custom_headers).value!
    end

    #
    # Get metrics for a specific instance of a worker pool of an App Service
    # Environment.
    #
    # Get metrics for a specific instance of a worker pool of an App Service
    # Environment.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the App Service Environment.
    # @param worker_pool_name [String] Name of the worker pool.
    # @param instance [String] Name of the instance in the worker pool.
    # @param details [Boolean] Specify <code>true</code> to include instance
    # details. The default is <code>false</code>.
    # @param filter [String] Return only usages/metrics specified in the filter.
    # Filter conforms to odata syntax. Example: $filter=(name.value eq 'Metric1' or
    # name.value eq 'Metric2') and startTime eq '2014-01-01T00:00:00Z' and endTime
    # eq '2014-12-31T23:59:59Z' and timeGrain eq duration'[Hour|Minute|Day]'.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_worker_pool_instance_metrics_async(resource_group_name, name, worker_pool_name, instance, details = nil, filter = nil, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'worker_pool_name is nil' if worker_pool_name.nil?
      fail ArgumentError, 'instance is nil' if instance.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-09-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/workerPools/{workerPoolName}/instances/{instance}metrics'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'workerPoolName' => worker_pool_name,'instance' => instance,'subscriptionId' => @client.subscription_id},
          query_params: {'details' => details,'api-version' => api_version},
          skip_encoding_query_params: {'$filter' => filter},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::ResourceMetricCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Get metric definitions for a worker pool of an App Service Environment.
    #
    # Get metric definitions for a worker pool of an App Service Environment.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the App Service Environment.
    # @param worker_pool_name [String] Name of the worker pool.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array<ResourceMetricDefinition>] operation results.
    #
    def list_web_worker_metric_definitions(resource_group_name, name, worker_pool_name, custom_headers = nil)
      first_page = list_web_worker_metric_definitions_as_lazy(resource_group_name, name, worker_pool_name, custom_headers)
      first_page.get_all_items
    end

    #
    # Get metric definitions for a worker pool of an App Service Environment.
    #
    # Get metric definitions for a worker pool of an App Service Environment.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the App Service Environment.
    # @param worker_pool_name [String] Name of the worker pool.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_web_worker_metric_definitions_with_http_info(resource_group_name, name, worker_pool_name, custom_headers = nil)
      list_web_worker_metric_definitions_async(resource_group_name, name, worker_pool_name, custom_headers).value!
    end

    #
    # Get metric definitions for a worker pool of an App Service Environment.
    #
    # Get metric definitions for a worker pool of an App Service Environment.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the App Service Environment.
    # @param worker_pool_name [String] Name of the worker pool.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_web_worker_metric_definitions_async(resource_group_name, name, worker_pool_name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'worker_pool_name is nil' if worker_pool_name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-09-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/workerPools/{workerPoolName}/metricdefinitions'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'workerPoolName' => worker_pool_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::ResourceMetricDefinitionCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Get metrics for a worker pool of a AppServiceEnvironment (App Service
    # Environment).
    #
    # Get metrics for a worker pool of a AppServiceEnvironment (App Service
    # Environment).
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the App Service Environment.
    # @param worker_pool_name [String] Name of worker pool
    # @param details [Boolean] Specify <code>true</code> to include instance
    # details. The default is <code>false</code>.
    # @param filter [String] Return only usages/metrics specified in the filter.
    # Filter conforms to odata syntax. Example: $filter=(name.value eq 'Metric1' or
    # name.value eq 'Metric2') and startTime eq '2014-01-01T00:00:00Z' and endTime
    # eq '2014-12-31T23:59:59Z' and timeGrain eq duration'[Hour|Minute|Day]'.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array<ResourceMetric>] operation results.
    #
    def list_web_worker_metrics(resource_group_name, name, worker_pool_name, details = nil, filter = nil, custom_headers = nil)
      first_page = list_web_worker_metrics_as_lazy(resource_group_name, name, worker_pool_name, details, filter, custom_headers)
      first_page.get_all_items
    end

    #
    # Get metrics for a worker pool of a AppServiceEnvironment (App Service
    # Environment).
    #
    # Get metrics for a worker pool of a AppServiceEnvironment (App Service
    # Environment).
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the App Service Environment.
    # @param worker_pool_name [String] Name of worker pool
    # @param details [Boolean] Specify <code>true</code> to include instance
    # details. The default is <code>false</code>.
    # @param filter [String] Return only usages/metrics specified in the filter.
    # Filter conforms to odata syntax. Example: $filter=(name.value eq 'Metric1' or
    # name.value eq 'Metric2') and startTime eq '2014-01-01T00:00:00Z' and endTime
    # eq '2014-12-31T23:59:59Z' and timeGrain eq duration'[Hour|Minute|Day]'.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_web_worker_metrics_with_http_info(resource_group_name, name, worker_pool_name, details = nil, filter = nil, custom_headers = nil)
      list_web_worker_metrics_async(resource_group_name, name, worker_pool_name, details, filter, custom_headers).value!
    end

    #
    # Get metrics for a worker pool of a AppServiceEnvironment (App Service
    # Environment).
    #
    # Get metrics for a worker pool of a AppServiceEnvironment (App Service
    # Environment).
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the App Service Environment.
    # @param worker_pool_name [String] Name of worker pool
    # @param details [Boolean] Specify <code>true</code> to include instance
    # details. The default is <code>false</code>.
    # @param filter [String] Return only usages/metrics specified in the filter.
    # Filter conforms to odata syntax. Example: $filter=(name.value eq 'Metric1' or
    # name.value eq 'Metric2') and startTime eq '2014-01-01T00:00:00Z' and endTime
    # eq '2014-12-31T23:59:59Z' and timeGrain eq duration'[Hour|Minute|Day]'.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_web_worker_metrics_async(resource_group_name, name, worker_pool_name, details = nil, filter = nil, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'worker_pool_name is nil' if worker_pool_name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-09-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/workerPools/{workerPoolName}/metrics'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'workerPoolName' => worker_pool_name,'subscriptionId' => @client.subscription_id},
          query_params: {'details' => details,'api-version' => api_version},
          skip_encoding_query_params: {'$filter' => filter},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::ResourceMetricCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Get available SKUs for scaling a worker pool.
    #
    # Get available SKUs for scaling a worker pool.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the App Service Environment.
    # @param worker_pool_name [String] Name of the worker pool.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array<SkuInfo>] operation results.
    #
    def list_worker_pool_skus(resource_group_name, name, worker_pool_name, custom_headers = nil)
      first_page = list_worker_pool_skus_as_lazy(resource_group_name, name, worker_pool_name, custom_headers)
      first_page.get_all_items
    end

    #
    # Get available SKUs for scaling a worker pool.
    #
    # Get available SKUs for scaling a worker pool.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the App Service Environment.
    # @param worker_pool_name [String] Name of the worker pool.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_worker_pool_skus_with_http_info(resource_group_name, name, worker_pool_name, custom_headers = nil)
      list_worker_pool_skus_async(resource_group_name, name, worker_pool_name, custom_headers).value!
    end

    #
    # Get available SKUs for scaling a worker pool.
    #
    # Get available SKUs for scaling a worker pool.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the App Service Environment.
    # @param worker_pool_name [String] Name of the worker pool.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_worker_pool_skus_async(resource_group_name, name, worker_pool_name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'worker_pool_name is nil' if worker_pool_name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-09-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/workerPools/{workerPoolName}/skus'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'workerPoolName' => worker_pool_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::SkuInfoCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Get usage metrics for a worker pool of an App Service Environment.
    #
    # Get usage metrics for a worker pool of an App Service Environment.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the App Service Environment.
    # @param worker_pool_name [String] Name of the worker pool.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array<Usage>] operation results.
    #
    def list_web_worker_usages(resource_group_name, name, worker_pool_name, custom_headers = nil)
      first_page = list_web_worker_usages_as_lazy(resource_group_name, name, worker_pool_name, custom_headers)
      first_page.get_all_items
    end

    #
    # Get usage metrics for a worker pool of an App Service Environment.
    #
    # Get usage metrics for a worker pool of an App Service Environment.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the App Service Environment.
    # @param worker_pool_name [String] Name of the worker pool.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_web_worker_usages_with_http_info(resource_group_name, name, worker_pool_name, custom_headers = nil)
      list_web_worker_usages_async(resource_group_name, name, worker_pool_name, custom_headers).value!
    end

    #
    # Get usage metrics for a worker pool of an App Service Environment.
    #
    # Get usage metrics for a worker pool of an App Service Environment.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the App Service Environment.
    # @param worker_pool_name [String] Name of the worker pool.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_web_worker_usages_async(resource_group_name, name, worker_pool_name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'worker_pool_name is nil' if worker_pool_name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-09-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/workerPools/{workerPoolName}/usages'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'workerPoolName' => worker_pool_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::UsageCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Create or update an App Service Environment.
    #
    # Create or update an App Service Environment.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the App Service Environment.
    # @param hosting_environment_envelope [AppServiceEnvironmentResource]
    # Configuration details of the App Service Environment.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [AppServiceEnvironmentResource] operation results.
    #
    def begin_create_or_update(resource_group_name, name, hosting_environment_envelope, custom_headers = nil)
      response = begin_create_or_update_async(resource_group_name, name, hosting_environment_envelope, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Create or update an App Service Environment.
    #
    # Create or update an App Service Environment.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the App Service Environment.
    # @param hosting_environment_envelope [AppServiceEnvironmentResource]
    # Configuration details of the App Service Environment.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def begin_create_or_update_with_http_info(resource_group_name, name, hosting_environment_envelope, custom_headers = nil)
      begin_create_or_update_async(resource_group_name, name, hosting_environment_envelope, custom_headers).value!
    end

    #
    # Create or update an App Service Environment.
    #
    # Create or update an App Service Environment.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the App Service Environment.
    # @param hosting_environment_envelope [AppServiceEnvironmentResource]
    # Configuration details of the App Service Environment.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def begin_create_or_update_async(resource_group_name, name, hosting_environment_envelope, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'hosting_environment_envelope is nil' if hosting_environment_envelope.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-09-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = Azure::ARM::Web::Models::AppServiceEnvironmentResource.mapper()
      request_content = @client.serialize(request_mapper,  hosting_environment_envelope)
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:put, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200 || status_code == 202 || status_code == 400 || status_code == 404 || status_code == 409
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::AppServiceEnvironmentResource.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end
        # Deserialize Response
        if status_code == 202
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::AppServiceEnvironmentResource.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Delete an App Service Environment.
    #
    # Delete an App Service Environment.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the App Service Environment.
    # @param force_delete [Boolean] Specify <code>true</code> to force the deletion
    # even if the App Service Environment contains resources. The default is
    # <code>false</code>.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    #
    def begin_delete(resource_group_name, name, force_delete = nil, custom_headers = nil)
      response = begin_delete_async(resource_group_name, name, force_delete, custom_headers).value!
      nil
    end

    #
    # Delete an App Service Environment.
    #
    # Delete an App Service Environment.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the App Service Environment.
    # @param force_delete [Boolean] Specify <code>true</code> to force the deletion
    # even if the App Service Environment contains resources. The default is
    # <code>false</code>.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def begin_delete_with_http_info(resource_group_name, name, force_delete = nil, custom_headers = nil)
      begin_delete_async(resource_group_name, name, force_delete, custom_headers).value!
    end

    #
    # Delete an App Service Environment.
    #
    # Delete an App Service Environment.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the App Service Environment.
    # @param force_delete [Boolean] Specify <code>true</code> to force the deletion
    # even if the App Service Environment contains resources. The default is
    # <code>false</code>.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def begin_delete_async(resource_group_name, name, force_delete = nil, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-09-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'forceDelete' => force_delete,'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:delete, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 202 || status_code == 204 || status_code == 400 || status_code == 404 || status_code == 409
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Create or update a multi-role pool.
    #
    # Create or update a multi-role pool.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the App Service Environment.
    # @param multi_role_pool_envelope [WorkerPoolResource] Properties of the
    # multi-role pool.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [WorkerPoolResource] operation results.
    #
    def begin_create_or_update_multi_role_pool(resource_group_name, name, multi_role_pool_envelope, custom_headers = nil)
      response = begin_create_or_update_multi_role_pool_async(resource_group_name, name, multi_role_pool_envelope, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Create or update a multi-role pool.
    #
    # Create or update a multi-role pool.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the App Service Environment.
    # @param multi_role_pool_envelope [WorkerPoolResource] Properties of the
    # multi-role pool.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def begin_create_or_update_multi_role_pool_with_http_info(resource_group_name, name, multi_role_pool_envelope, custom_headers = nil)
      begin_create_or_update_multi_role_pool_async(resource_group_name, name, multi_role_pool_envelope, custom_headers).value!
    end

    #
    # Create or update a multi-role pool.
    #
    # Create or update a multi-role pool.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the App Service Environment.
    # @param multi_role_pool_envelope [WorkerPoolResource] Properties of the
    # multi-role pool.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def begin_create_or_update_multi_role_pool_async(resource_group_name, name, multi_role_pool_envelope, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'multi_role_pool_envelope is nil' if multi_role_pool_envelope.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-09-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = Azure::ARM::Web::Models::WorkerPoolResource.mapper()
      request_content = @client.serialize(request_mapper,  multi_role_pool_envelope)
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/multiRolePools/default'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:put, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200 || status_code == 202 || status_code == 400 || status_code == 404 || status_code == 409
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::WorkerPoolResource.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end
        # Deserialize Response
        if status_code == 202
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::WorkerPoolResource.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Resume an App Service Environment.
    #
    # Resume an App Service Environment.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the App Service Environment.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array<Site>] operation results.
    #
    def begin_resume(resource_group_name, name, custom_headers = nil)
      first_page = begin_resume_as_lazy(resource_group_name, name, custom_headers)
      first_page.get_all_items
    end

    #
    # Resume an App Service Environment.
    #
    # Resume an App Service Environment.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the App Service Environment.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def begin_resume_with_http_info(resource_group_name, name, custom_headers = nil)
      begin_resume_async(resource_group_name, name, custom_headers).value!
    end

    #
    # Resume an App Service Environment.
    #
    # Resume an App Service Environment.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the App Service Environment.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def begin_resume_async(resource_group_name, name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-09-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/resume'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200 || status_code == 202
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::WebAppCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end
        # Deserialize Response
        if status_code == 202
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::WebAppCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Suspend an App Service Environment.
    #
    # Suspend an App Service Environment.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the App Service Environment.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array<Site>] operation results.
    #
    def begin_suspend(resource_group_name, name, custom_headers = nil)
      first_page = begin_suspend_as_lazy(resource_group_name, name, custom_headers)
      first_page.get_all_items
    end

    #
    # Suspend an App Service Environment.
    #
    # Suspend an App Service Environment.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the App Service Environment.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def begin_suspend_with_http_info(resource_group_name, name, custom_headers = nil)
      begin_suspend_async(resource_group_name, name, custom_headers).value!
    end

    #
    # Suspend an App Service Environment.
    #
    # Suspend an App Service Environment.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the App Service Environment.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def begin_suspend_async(resource_group_name, name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-09-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/suspend'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200 || status_code == 202
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::WebAppCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end
        # Deserialize Response
        if status_code == 202
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::WebAppCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Create or update a worker pool.
    #
    # Create or update a worker pool.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the App Service Environment.
    # @param worker_pool_name [String] Name of the worker pool.
    # @param worker_pool_envelope [WorkerPoolResource] Properties of the worker
    # pool.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [WorkerPoolResource] operation results.
    #
    def begin_create_or_update_worker_pool(resource_group_name, name, worker_pool_name, worker_pool_envelope, custom_headers = nil)
      response = begin_create_or_update_worker_pool_async(resource_group_name, name, worker_pool_name, worker_pool_envelope, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Create or update a worker pool.
    #
    # Create or update a worker pool.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the App Service Environment.
    # @param worker_pool_name [String] Name of the worker pool.
    # @param worker_pool_envelope [WorkerPoolResource] Properties of the worker
    # pool.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def begin_create_or_update_worker_pool_with_http_info(resource_group_name, name, worker_pool_name, worker_pool_envelope, custom_headers = nil)
      begin_create_or_update_worker_pool_async(resource_group_name, name, worker_pool_name, worker_pool_envelope, custom_headers).value!
    end

    #
    # Create or update a worker pool.
    #
    # Create or update a worker pool.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the App Service Environment.
    # @param worker_pool_name [String] Name of the worker pool.
    # @param worker_pool_envelope [WorkerPoolResource] Properties of the worker
    # pool.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def begin_create_or_update_worker_pool_async(resource_group_name, name, worker_pool_name, worker_pool_envelope, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'worker_pool_name is nil' if worker_pool_name.nil?
      fail ArgumentError, 'worker_pool_envelope is nil' if worker_pool_envelope.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-09-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = Azure::ARM::Web::Models::WorkerPoolResource.mapper()
      request_content = @client.serialize(request_mapper,  worker_pool_envelope)
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/hostingEnvironments/{name}/workerPools/{workerPoolName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'workerPoolName' => worker_pool_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:put, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200 || status_code == 202 || status_code == 400 || status_code == 404 || status_code == 409
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::WorkerPoolResource.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end
        # Deserialize Response
        if status_code == 202
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::WorkerPoolResource.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Get all App Service Environments for a subscription.
    #
    # Get all App Service Environments for a subscription.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [AppServiceEnvironmentCollection] operation results.
    #
    def list_next(next_page_link, custom_headers = nil)
      response = list_next_async(next_page_link, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Get all App Service Environments for a subscription.
    #
    # Get all App Service Environments for a subscription.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_next_with_http_info(next_page_link, custom_headers = nil)
      list_next_async(next_page_link, custom_headers).value!
    end

    #
    # Get all App Service Environments for a subscription.
    #
    # Get all App Service Environments for a subscription.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_next_async(next_page_link, custom_headers = nil)
      fail ArgumentError, 'next_page_link is nil' if next_page_link.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '{nextLink}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          skip_encoding_path_params: {'nextLink' => next_page_link},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::AppServiceEnvironmentCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Get all App Service Environments in a resource group.
    #
    # Get all App Service Environments in a resource group.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [AppServiceEnvironmentCollection] operation results.
    #
    def list_by_resource_group_next(next_page_link, custom_headers = nil)
      response = list_by_resource_group_next_async(next_page_link, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Get all App Service Environments in a resource group.
    #
    # Get all App Service Environments in a resource group.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_by_resource_group_next_with_http_info(next_page_link, custom_headers = nil)
      list_by_resource_group_next_async(next_page_link, custom_headers).value!
    end

    #
    # Get all App Service Environments in a resource group.
    #
    # Get all App Service Environments in a resource group.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_by_resource_group_next_async(next_page_link, custom_headers = nil)
      fail ArgumentError, 'next_page_link is nil' if next_page_link.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '{nextLink}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          skip_encoding_path_params: {'nextLink' => next_page_link},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::AppServiceEnvironmentCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Get the used, available, and total worker capacity an App Service
    # Environment.
    #
    # Get the used, available, and total worker capacity an App Service
    # Environment.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [StampCapacityCollection] operation results.
    #
    def list_capacities_next(next_page_link, custom_headers = nil)
      response = list_capacities_next_async(next_page_link, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Get the used, available, and total worker capacity an App Service
    # Environment.
    #
    # Get the used, available, and total worker capacity an App Service
    # Environment.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_capacities_next_with_http_info(next_page_link, custom_headers = nil)
      list_capacities_next_async(next_page_link, custom_headers).value!
    end

    #
    # Get the used, available, and total worker capacity an App Service
    # Environment.
    #
    # Get the used, available, and total worker capacity an App Service
    # Environment.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_capacities_next_async(next_page_link, custom_headers = nil)
      fail ArgumentError, 'next_page_link is nil' if next_page_link.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '{nextLink}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          skip_encoding_path_params: {'nextLink' => next_page_link},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::StampCapacityCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Get global metrics of an App Service Environment.
    #
    # Get global metrics of an App Service Environment.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [ResourceMetricCollection] operation results.
    #
    def list_metrics_next(next_page_link, custom_headers = nil)
      response = list_metrics_next_async(next_page_link, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Get global metrics of an App Service Environment.
    #
    # Get global metrics of an App Service Environment.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_metrics_next_with_http_info(next_page_link, custom_headers = nil)
      list_metrics_next_async(next_page_link, custom_headers).value!
    end

    #
    # Get global metrics of an App Service Environment.
    #
    # Get global metrics of an App Service Environment.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_metrics_next_async(next_page_link, custom_headers = nil)
      fail ArgumentError, 'next_page_link is nil' if next_page_link.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '{nextLink}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          skip_encoding_path_params: {'nextLink' => next_page_link},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::ResourceMetricCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Get all multi-role pools.
    #
    # Get all multi-role pools.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [WorkerPoolCollection] operation results.
    #
    def list_multi_role_pools_next(next_page_link, custom_headers = nil)
      response = list_multi_role_pools_next_async(next_page_link, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Get all multi-role pools.
    #
    # Get all multi-role pools.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_multi_role_pools_next_with_http_info(next_page_link, custom_headers = nil)
      list_multi_role_pools_next_async(next_page_link, custom_headers).value!
    end

    #
    # Get all multi-role pools.
    #
    # Get all multi-role pools.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_multi_role_pools_next_async(next_page_link, custom_headers = nil)
      fail ArgumentError, 'next_page_link is nil' if next_page_link.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '{nextLink}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          skip_encoding_path_params: {'nextLink' => next_page_link},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::WorkerPoolCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Get metric definitions for a specific instance of a multi-role pool of an App
    # Service Environment.
    #
    # Get metric definitions for a specific instance of a multi-role pool of an App
    # Service Environment.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [ResourceMetricDefinitionCollection] operation results.
    #
    def list_multi_role_pool_instance_metric_definitions_next(next_page_link, custom_headers = nil)
      response = list_multi_role_pool_instance_metric_definitions_next_async(next_page_link, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Get metric definitions for a specific instance of a multi-role pool of an App
    # Service Environment.
    #
    # Get metric definitions for a specific instance of a multi-role pool of an App
    # Service Environment.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_multi_role_pool_instance_metric_definitions_next_with_http_info(next_page_link, custom_headers = nil)
      list_multi_role_pool_instance_metric_definitions_next_async(next_page_link, custom_headers).value!
    end

    #
    # Get metric definitions for a specific instance of a multi-role pool of an App
    # Service Environment.
    #
    # Get metric definitions for a specific instance of a multi-role pool of an App
    # Service Environment.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_multi_role_pool_instance_metric_definitions_next_async(next_page_link, custom_headers = nil)
      fail ArgumentError, 'next_page_link is nil' if next_page_link.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '{nextLink}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          skip_encoding_path_params: {'nextLink' => next_page_link},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::ResourceMetricDefinitionCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Get metrics for a specific instance of a multi-role pool of an App Service
    # Environment.
    #
    # Get metrics for a specific instance of a multi-role pool of an App Service
    # Environment.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [ResourceMetricCollection] operation results.
    #
    def list_multi_role_pool_instance_metrics_next(next_page_link, custom_headers = nil)
      response = list_multi_role_pool_instance_metrics_next_async(next_page_link, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Get metrics for a specific instance of a multi-role pool of an App Service
    # Environment.
    #
    # Get metrics for a specific instance of a multi-role pool of an App Service
    # Environment.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_multi_role_pool_instance_metrics_next_with_http_info(next_page_link, custom_headers = nil)
      list_multi_role_pool_instance_metrics_next_async(next_page_link, custom_headers).value!
    end

    #
    # Get metrics for a specific instance of a multi-role pool of an App Service
    # Environment.
    #
    # Get metrics for a specific instance of a multi-role pool of an App Service
    # Environment.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_multi_role_pool_instance_metrics_next_async(next_page_link, custom_headers = nil)
      fail ArgumentError, 'next_page_link is nil' if next_page_link.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '{nextLink}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          skip_encoding_path_params: {'nextLink' => next_page_link},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::ResourceMetricCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Get metric definitions for a multi-role pool of an App Service Environment.
    #
    # Get metric definitions for a multi-role pool of an App Service Environment.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [ResourceMetricDefinitionCollection] operation results.
    #
    def list_multi_role_metric_definitions_next(next_page_link, custom_headers = nil)
      response = list_multi_role_metric_definitions_next_async(next_page_link, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Get metric definitions for a multi-role pool of an App Service Environment.
    #
    # Get metric definitions for a multi-role pool of an App Service Environment.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_multi_role_metric_definitions_next_with_http_info(next_page_link, custom_headers = nil)
      list_multi_role_metric_definitions_next_async(next_page_link, custom_headers).value!
    end

    #
    # Get metric definitions for a multi-role pool of an App Service Environment.
    #
    # Get metric definitions for a multi-role pool of an App Service Environment.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_multi_role_metric_definitions_next_async(next_page_link, custom_headers = nil)
      fail ArgumentError, 'next_page_link is nil' if next_page_link.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '{nextLink}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          skip_encoding_path_params: {'nextLink' => next_page_link},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::ResourceMetricDefinitionCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Get metrics for a multi-role pool of an App Service Environment.
    #
    # Get metrics for a multi-role pool of an App Service Environment.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [ResourceMetricCollection] operation results.
    #
    def list_multi_role_metrics_next(next_page_link, custom_headers = nil)
      response = list_multi_role_metrics_next_async(next_page_link, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Get metrics for a multi-role pool of an App Service Environment.
    #
    # Get metrics for a multi-role pool of an App Service Environment.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_multi_role_metrics_next_with_http_info(next_page_link, custom_headers = nil)
      list_multi_role_metrics_next_async(next_page_link, custom_headers).value!
    end

    #
    # Get metrics for a multi-role pool of an App Service Environment.
    #
    # Get metrics for a multi-role pool of an App Service Environment.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_multi_role_metrics_next_async(next_page_link, custom_headers = nil)
      fail ArgumentError, 'next_page_link is nil' if next_page_link.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '{nextLink}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          skip_encoding_path_params: {'nextLink' => next_page_link},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::ResourceMetricCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Get available SKUs for scaling a multi-role pool.
    #
    # Get available SKUs for scaling a multi-role pool.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [SkuInfoCollection] operation results.
    #
    def list_multi_role_pool_skus_next(next_page_link, custom_headers = nil)
      response = list_multi_role_pool_skus_next_async(next_page_link, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Get available SKUs for scaling a multi-role pool.
    #
    # Get available SKUs for scaling a multi-role pool.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_multi_role_pool_skus_next_with_http_info(next_page_link, custom_headers = nil)
      list_multi_role_pool_skus_next_async(next_page_link, custom_headers).value!
    end

    #
    # Get available SKUs for scaling a multi-role pool.
    #
    # Get available SKUs for scaling a multi-role pool.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_multi_role_pool_skus_next_async(next_page_link, custom_headers = nil)
      fail ArgumentError, 'next_page_link is nil' if next_page_link.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '{nextLink}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          skip_encoding_path_params: {'nextLink' => next_page_link},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::SkuInfoCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Get usage metrics for a multi-role pool of an App Service Environment.
    #
    # Get usage metrics for a multi-role pool of an App Service Environment.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [UsageCollection] operation results.
    #
    def list_multi_role_usages_next(next_page_link, custom_headers = nil)
      response = list_multi_role_usages_next_async(next_page_link, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Get usage metrics for a multi-role pool of an App Service Environment.
    #
    # Get usage metrics for a multi-role pool of an App Service Environment.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_multi_role_usages_next_with_http_info(next_page_link, custom_headers = nil)
      list_multi_role_usages_next_async(next_page_link, custom_headers).value!
    end

    #
    # Get usage metrics for a multi-role pool of an App Service Environment.
    #
    # Get usage metrics for a multi-role pool of an App Service Environment.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_multi_role_usages_next_async(next_page_link, custom_headers = nil)
      fail ArgumentError, 'next_page_link is nil' if next_page_link.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '{nextLink}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          skip_encoding_path_params: {'nextLink' => next_page_link},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::UsageCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Resume an App Service Environment.
    #
    # Resume an App Service Environment.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [WebAppCollection] operation results.
    #
    def resume_next(next_page_link, custom_headers = nil)
      response = resume_next_async(next_page_link, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Concurrent::Promise] promise which provides async access to http
    # response.
    #
    def resume_next_async(next_page_link, custom_headers = nil)
      # Send request
      promise = begin_resume_next_async(next_page_link, custom_headers)

      promise = promise.then do |response|
        # Defining deserialization method.
        deserialize_method = lambda do |parsed_response|
          result_mapper = Azure::ARM::Web::Models::WebAppCollection.mapper()
          parsed_response = @client.deserialize(result_mapper, parsed_response)
        end

        # Waiting for response.
        @client.get_long_running_operation_result(response, deserialize_method)
      end

      promise
    end

    #
    # Get all App Service plans in an App Service Environment.
    #
    # Get all App Service plans in an App Service Environment.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [AppServicePlanCollection] operation results.
    #
    def list_app_service_plans_next(next_page_link, custom_headers = nil)
      response = list_app_service_plans_next_async(next_page_link, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Get all App Service plans in an App Service Environment.
    #
    # Get all App Service plans in an App Service Environment.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_app_service_plans_next_with_http_info(next_page_link, custom_headers = nil)
      list_app_service_plans_next_async(next_page_link, custom_headers).value!
    end

    #
    # Get all App Service plans in an App Service Environment.
    #
    # Get all App Service plans in an App Service Environment.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_app_service_plans_next_async(next_page_link, custom_headers = nil)
      fail ArgumentError, 'next_page_link is nil' if next_page_link.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '{nextLink}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          skip_encoding_path_params: {'nextLink' => next_page_link},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::AppServicePlanCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Get all apps in an App Service Environment.
    #
    # Get all apps in an App Service Environment.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [WebAppCollection] operation results.
    #
    def list_web_apps_next(next_page_link, custom_headers = nil)
      response = list_web_apps_next_async(next_page_link, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Get all apps in an App Service Environment.
    #
    # Get all apps in an App Service Environment.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_web_apps_next_with_http_info(next_page_link, custom_headers = nil)
      list_web_apps_next_async(next_page_link, custom_headers).value!
    end

    #
    # Get all apps in an App Service Environment.
    #
    # Get all apps in an App Service Environment.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_web_apps_next_async(next_page_link, custom_headers = nil)
      fail ArgumentError, 'next_page_link is nil' if next_page_link.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '{nextLink}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          skip_encoding_path_params: {'nextLink' => next_page_link},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::WebAppCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Suspend an App Service Environment.
    #
    # Suspend an App Service Environment.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [WebAppCollection] operation results.
    #
    def suspend_next(next_page_link, custom_headers = nil)
      response = suspend_next_async(next_page_link, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Concurrent::Promise] promise which provides async access to http
    # response.
    #
    def suspend_next_async(next_page_link, custom_headers = nil)
      # Send request
      promise = begin_suspend_next_async(next_page_link, custom_headers)

      promise = promise.then do |response|
        # Defining deserialization method.
        deserialize_method = lambda do |parsed_response|
          result_mapper = Azure::ARM::Web::Models::WebAppCollection.mapper()
          parsed_response = @client.deserialize(result_mapper, parsed_response)
        end

        # Waiting for response.
        @client.get_long_running_operation_result(response, deserialize_method)
      end

      promise
    end

    #
    # Get global usage metrics of an App Service Environment.
    #
    # Get global usage metrics of an App Service Environment.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [CsmUsageQuotaCollection] operation results.
    #
    def list_usages_next(next_page_link, custom_headers = nil)
      response = list_usages_next_async(next_page_link, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Get global usage metrics of an App Service Environment.
    #
    # Get global usage metrics of an App Service Environment.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_usages_next_with_http_info(next_page_link, custom_headers = nil)
      list_usages_next_async(next_page_link, custom_headers).value!
    end

    #
    # Get global usage metrics of an App Service Environment.
    #
    # Get global usage metrics of an App Service Environment.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_usages_next_async(next_page_link, custom_headers = nil)
      fail ArgumentError, 'next_page_link is nil' if next_page_link.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '{nextLink}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          skip_encoding_path_params: {'nextLink' => next_page_link},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::CsmUsageQuotaCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Get all worker pools of an App Service Environment.
    #
    # Get all worker pools of an App Service Environment.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [WorkerPoolCollection] operation results.
    #
    def list_worker_pools_next(next_page_link, custom_headers = nil)
      response = list_worker_pools_next_async(next_page_link, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Get all worker pools of an App Service Environment.
    #
    # Get all worker pools of an App Service Environment.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_worker_pools_next_with_http_info(next_page_link, custom_headers = nil)
      list_worker_pools_next_async(next_page_link, custom_headers).value!
    end

    #
    # Get all worker pools of an App Service Environment.
    #
    # Get all worker pools of an App Service Environment.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_worker_pools_next_async(next_page_link, custom_headers = nil)
      fail ArgumentError, 'next_page_link is nil' if next_page_link.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '{nextLink}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          skip_encoding_path_params: {'nextLink' => next_page_link},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::WorkerPoolCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Get metric definitions for a specific instance of a worker pool of an App
    # Service Environment.
    #
    # Get metric definitions for a specific instance of a worker pool of an App
    # Service Environment.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [ResourceMetricDefinitionCollection] operation results.
    #
    def list_worker_pool_instance_metric_definitions_next(next_page_link, custom_headers = nil)
      response = list_worker_pool_instance_metric_definitions_next_async(next_page_link, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Get metric definitions for a specific instance of a worker pool of an App
    # Service Environment.
    #
    # Get metric definitions for a specific instance of a worker pool of an App
    # Service Environment.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_worker_pool_instance_metric_definitions_next_with_http_info(next_page_link, custom_headers = nil)
      list_worker_pool_instance_metric_definitions_next_async(next_page_link, custom_headers).value!
    end

    #
    # Get metric definitions for a specific instance of a worker pool of an App
    # Service Environment.
    #
    # Get metric definitions for a specific instance of a worker pool of an App
    # Service Environment.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_worker_pool_instance_metric_definitions_next_async(next_page_link, custom_headers = nil)
      fail ArgumentError, 'next_page_link is nil' if next_page_link.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '{nextLink}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          skip_encoding_path_params: {'nextLink' => next_page_link},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::ResourceMetricDefinitionCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Get metrics for a specific instance of a worker pool of an App Service
    # Environment.
    #
    # Get metrics for a specific instance of a worker pool of an App Service
    # Environment.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [ResourceMetricCollection] operation results.
    #
    def list_worker_pool_instance_metrics_next(next_page_link, custom_headers = nil)
      response = list_worker_pool_instance_metrics_next_async(next_page_link, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Get metrics for a specific instance of a worker pool of an App Service
    # Environment.
    #
    # Get metrics for a specific instance of a worker pool of an App Service
    # Environment.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_worker_pool_instance_metrics_next_with_http_info(next_page_link, custom_headers = nil)
      list_worker_pool_instance_metrics_next_async(next_page_link, custom_headers).value!
    end

    #
    # Get metrics for a specific instance of a worker pool of an App Service
    # Environment.
    #
    # Get metrics for a specific instance of a worker pool of an App Service
    # Environment.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_worker_pool_instance_metrics_next_async(next_page_link, custom_headers = nil)
      fail ArgumentError, 'next_page_link is nil' if next_page_link.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '{nextLink}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          skip_encoding_path_params: {'nextLink' => next_page_link},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::ResourceMetricCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Get metric definitions for a worker pool of an App Service Environment.
    #
    # Get metric definitions for a worker pool of an App Service Environment.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [ResourceMetricDefinitionCollection] operation results.
    #
    def list_web_worker_metric_definitions_next(next_page_link, custom_headers = nil)
      response = list_web_worker_metric_definitions_next_async(next_page_link, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Get metric definitions for a worker pool of an App Service Environment.
    #
    # Get metric definitions for a worker pool of an App Service Environment.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_web_worker_metric_definitions_next_with_http_info(next_page_link, custom_headers = nil)
      list_web_worker_metric_definitions_next_async(next_page_link, custom_headers).value!
    end

    #
    # Get metric definitions for a worker pool of an App Service Environment.
    #
    # Get metric definitions for a worker pool of an App Service Environment.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_web_worker_metric_definitions_next_async(next_page_link, custom_headers = nil)
      fail ArgumentError, 'next_page_link is nil' if next_page_link.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '{nextLink}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          skip_encoding_path_params: {'nextLink' => next_page_link},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::ResourceMetricDefinitionCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Get metrics for a worker pool of a AppServiceEnvironment (App Service
    # Environment).
    #
    # Get metrics for a worker pool of a AppServiceEnvironment (App Service
    # Environment).
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [ResourceMetricCollection] operation results.
    #
    def list_web_worker_metrics_next(next_page_link, custom_headers = nil)
      response = list_web_worker_metrics_next_async(next_page_link, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Get metrics for a worker pool of a AppServiceEnvironment (App Service
    # Environment).
    #
    # Get metrics for a worker pool of a AppServiceEnvironment (App Service
    # Environment).
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_web_worker_metrics_next_with_http_info(next_page_link, custom_headers = nil)
      list_web_worker_metrics_next_async(next_page_link, custom_headers).value!
    end

    #
    # Get metrics for a worker pool of a AppServiceEnvironment (App Service
    # Environment).
    #
    # Get metrics for a worker pool of a AppServiceEnvironment (App Service
    # Environment).
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_web_worker_metrics_next_async(next_page_link, custom_headers = nil)
      fail ArgumentError, 'next_page_link is nil' if next_page_link.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '{nextLink}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          skip_encoding_path_params: {'nextLink' => next_page_link},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::ResourceMetricCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Get available SKUs for scaling a worker pool.
    #
    # Get available SKUs for scaling a worker pool.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [SkuInfoCollection] operation results.
    #
    def list_worker_pool_skus_next(next_page_link, custom_headers = nil)
      response = list_worker_pool_skus_next_async(next_page_link, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Get available SKUs for scaling a worker pool.
    #
    # Get available SKUs for scaling a worker pool.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_worker_pool_skus_next_with_http_info(next_page_link, custom_headers = nil)
      list_worker_pool_skus_next_async(next_page_link, custom_headers).value!
    end

    #
    # Get available SKUs for scaling a worker pool.
    #
    # Get available SKUs for scaling a worker pool.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_worker_pool_skus_next_async(next_page_link, custom_headers = nil)
      fail ArgumentError, 'next_page_link is nil' if next_page_link.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '{nextLink}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          skip_encoding_path_params: {'nextLink' => next_page_link},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::SkuInfoCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Get usage metrics for a worker pool of an App Service Environment.
    #
    # Get usage metrics for a worker pool of an App Service Environment.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [UsageCollection] operation results.
    #
    def list_web_worker_usages_next(next_page_link, custom_headers = nil)
      response = list_web_worker_usages_next_async(next_page_link, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Get usage metrics for a worker pool of an App Service Environment.
    #
    # Get usage metrics for a worker pool of an App Service Environment.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_web_worker_usages_next_with_http_info(next_page_link, custom_headers = nil)
      list_web_worker_usages_next_async(next_page_link, custom_headers).value!
    end

    #
    # Get usage metrics for a worker pool of an App Service Environment.
    #
    # Get usage metrics for a worker pool of an App Service Environment.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_web_worker_usages_next_async(next_page_link, custom_headers = nil)
      fail ArgumentError, 'next_page_link is nil' if next_page_link.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '{nextLink}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          skip_encoding_path_params: {'nextLink' => next_page_link},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::UsageCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Resume an App Service Environment.
    #
    # Resume an App Service Environment.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [WebAppCollection] operation results.
    #
    def begin_resume_next(next_page_link, custom_headers = nil)
      response = begin_resume_next_async(next_page_link, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Resume an App Service Environment.
    #
    # Resume an App Service Environment.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def begin_resume_next_with_http_info(next_page_link, custom_headers = nil)
      begin_resume_next_async(next_page_link, custom_headers).value!
    end

    #
    # Resume an App Service Environment.
    #
    # Resume an App Service Environment.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def begin_resume_next_async(next_page_link, custom_headers = nil)
      fail ArgumentError, 'next_page_link is nil' if next_page_link.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '{nextLink}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          skip_encoding_path_params: {'nextLink' => next_page_link},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200 || status_code == 202
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::WebAppCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end
        # Deserialize Response
        if status_code == 202
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::WebAppCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Suspend an App Service Environment.
    #
    # Suspend an App Service Environment.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [WebAppCollection] operation results.
    #
    def begin_suspend_next(next_page_link, custom_headers = nil)
      response = begin_suspend_next_async(next_page_link, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Suspend an App Service Environment.
    #
    # Suspend an App Service Environment.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def begin_suspend_next_with_http_info(next_page_link, custom_headers = nil)
      begin_suspend_next_async(next_page_link, custom_headers).value!
    end

    #
    # Suspend an App Service Environment.
    #
    # Suspend an App Service Environment.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def begin_suspend_next_async(next_page_link, custom_headers = nil)
      fail ArgumentError, 'next_page_link is nil' if next_page_link.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '{nextLink}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          skip_encoding_path_params: {'nextLink' => next_page_link},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200 || status_code == 202
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::WebAppCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end
        # Deserialize Response
        if status_code == 202
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::WebAppCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Get all App Service Environments for a subscription.
    #
    # Get all App Service Environments for a subscription.
    #
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [AppServiceEnvironmentCollection] which provide lazy access to pages
    # of the response.
    #
    def list_as_lazy(custom_headers = nil)
      response = list_async(custom_headers).value!
      unless response.nil?
        page = response.body
        page.next_method = Proc.new do |next_page_link|
          list_next_async(next_page_link, custom_headers)
        end
        page
      end
    end

    #
    # Get all App Service Environments in a resource group.
    #
    # Get all App Service Environments in a resource group.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [AppServiceEnvironmentCollection] which provide lazy access to pages
    # of the response.
    #
    def list_by_resource_group_as_lazy(resource_group_name, custom_headers = nil)
      response = list_by_resource_group_async(resource_group_name, custom_headers).value!
      unless response.nil?
        page = response.body
        page.next_method = Proc.new do |next_page_link|
          list_by_resource_group_next_async(next_page_link, custom_headers)
        end
        page
      end
    end

    #
    # Get the used, available, and total worker capacity an App Service
    # Environment.
    #
    # Get the used, available, and total worker capacity an App Service
    # Environment.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the App Service Environment.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [StampCapacityCollection] which provide lazy access to pages of the
    # response.
    #
    def list_capacities_as_lazy(resource_group_name, name, custom_headers = nil)
      response = list_capacities_async(resource_group_name, name, custom_headers).value!
      unless response.nil?
        page = response.body
        page.next_method = Proc.new do |next_page_link|
          list_capacities_next_async(next_page_link, custom_headers)
        end
        page
      end
    end

    #
    # Get global metrics of an App Service Environment.
    #
    # Get global metrics of an App Service Environment.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the App Service Environment.
    # @param details [Boolean] Specify <code>true</code> to include instance
    # details. The default is <code>false</code>.
    # @param filter [String] Return only usages/metrics specified in the filter.
    # Filter conforms to odata syntax. Example: $filter=(name.value eq 'Metric1' or
    # name.value eq 'Metric2') and startTime eq '2014-01-01T00:00:00Z' and endTime
    # eq '2014-12-31T23:59:59Z' and timeGrain eq duration'[Hour|Minute|Day]'.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [ResourceMetricCollection] which provide lazy access to pages of the
    # response.
    #
    def list_metrics_as_lazy(resource_group_name, name, details = nil, filter = nil, custom_headers = nil)
      response = list_metrics_async(resource_group_name, name, details, filter, custom_headers).value!
      unless response.nil?
        page = response.body
        page.next_method = Proc.new do |next_page_link|
          list_metrics_next_async(next_page_link, custom_headers)
        end
        page
      end
    end

    #
    # Get all multi-role pools.
    #
    # Get all multi-role pools.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the App Service Environment.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [WorkerPoolCollection] which provide lazy access to pages of the
    # response.
    #
    def list_multi_role_pools_as_lazy(resource_group_name, name, custom_headers = nil)
      response = list_multi_role_pools_async(resource_group_name, name, custom_headers).value!
      unless response.nil?
        page = response.body
        page.next_method = Proc.new do |next_page_link|
          list_multi_role_pools_next_async(next_page_link, custom_headers)
        end
        page
      end
    end

    #
    # Get metric definitions for a specific instance of a multi-role pool of an App
    # Service Environment.
    #
    # Get metric definitions for a specific instance of a multi-role pool of an App
    # Service Environment.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the App Service Environment.
    # @param instance [String] Name of the instance in the multi-role pool.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [ResourceMetricDefinitionCollection] which provide lazy access to
    # pages of the response.
    #
    def list_multi_role_pool_instance_metric_definitions_as_lazy(resource_group_name, name, instance, custom_headers = nil)
      response = list_multi_role_pool_instance_metric_definitions_async(resource_group_name, name, instance, custom_headers).value!
      unless response.nil?
        page = response.body
        page.next_method = Proc.new do |next_page_link|
          list_multi_role_pool_instance_metric_definitions_next_async(next_page_link, custom_headers)
        end
        page
      end
    end

    #
    # Get metrics for a specific instance of a multi-role pool of an App Service
    # Environment.
    #
    # Get metrics for a specific instance of a multi-role pool of an App Service
    # Environment.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the App Service Environment.
    # @param instance [String] Name of the instance in the multi-role pool.
    # @param details [Boolean] Specify <code>true</code> to include instance
    # details. The default is <code>false</code>.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [ResourceMetricCollection] which provide lazy access to pages of the
    # response.
    #
    def list_multi_role_pool_instance_metrics_as_lazy(resource_group_name, name, instance, details = nil, custom_headers = nil)
      response = list_multi_role_pool_instance_metrics_async(resource_group_name, name, instance, details, custom_headers).value!
      unless response.nil?
        page = response.body
        page.next_method = Proc.new do |next_page_link|
          list_multi_role_pool_instance_metrics_next_async(next_page_link, custom_headers)
        end
        page
      end
    end

    #
    # Get metric definitions for a multi-role pool of an App Service Environment.
    #
    # Get metric definitions for a multi-role pool of an App Service Environment.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the App Service Environment.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [ResourceMetricDefinitionCollection] which provide lazy access to
    # pages of the response.
    #
    def list_multi_role_metric_definitions_as_lazy(resource_group_name, name, custom_headers = nil)
      response = list_multi_role_metric_definitions_async(resource_group_name, name, custom_headers).value!
      unless response.nil?
        page = response.body
        page.next_method = Proc.new do |next_page_link|
          list_multi_role_metric_definitions_next_async(next_page_link, custom_headers)
        end
        page
      end
    end

    #
    # Get metrics for a multi-role pool of an App Service Environment.
    #
    # Get metrics for a multi-role pool of an App Service Environment.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the App Service Environment.
    # @param start_time [String] Beginning time of the metrics query.
    # @param end_time [String] End time of the metrics query.
    # @param time_grain [String] Time granularity of the metrics query.
    # @param details [Boolean] Specify <code>true</code> to include instance
    # details. The default is <code>false</code>.
    # @param filter [String] Return only usages/metrics specified in the filter.
    # Filter conforms to odata syntax. Example: $filter=(name.value eq 'Metric1' or
    # name.value eq 'Metric2') and startTime eq '2014-01-01T00:00:00Z' and endTime
    # eq '2014-12-31T23:59:59Z' and timeGrain eq duration'[Hour|Minute|Day]'.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [ResourceMetricCollection] which provide lazy access to pages of the
    # response.
    #
    def list_multi_role_metrics_as_lazy(resource_group_name, name, start_time = nil, end_time = nil, time_grain = nil, details = nil, filter = nil, custom_headers = nil)
      response = list_multi_role_metrics_async(resource_group_name, name, start_time, end_time, time_grain, details, filter, custom_headers).value!
      unless response.nil?
        page = response.body
        page.next_method = Proc.new do |next_page_link|
          list_multi_role_metrics_next_async(next_page_link, custom_headers)
        end
        page
      end
    end

    #
    # Get available SKUs for scaling a multi-role pool.
    #
    # Get available SKUs for scaling a multi-role pool.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the App Service Environment.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [SkuInfoCollection] which provide lazy access to pages of the
    # response.
    #
    def list_multi_role_pool_skus_as_lazy(resource_group_name, name, custom_headers = nil)
      response = list_multi_role_pool_skus_async(resource_group_name, name, custom_headers).value!
      unless response.nil?
        page = response.body
        page.next_method = Proc.new do |next_page_link|
          list_multi_role_pool_skus_next_async(next_page_link, custom_headers)
        end
        page
      end
    end

    #
    # Get usage metrics for a multi-role pool of an App Service Environment.
    #
    # Get usage metrics for a multi-role pool of an App Service Environment.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the App Service Environment.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [UsageCollection] which provide lazy access to pages of the response.
    #
    def list_multi_role_usages_as_lazy(resource_group_name, name, custom_headers = nil)
      response = list_multi_role_usages_async(resource_group_name, name, custom_headers).value!
      unless response.nil?
        page = response.body
        page.next_method = Proc.new do |next_page_link|
          list_multi_role_usages_next_async(next_page_link, custom_headers)
        end
        page
      end
    end

    #
    # Get all App Service plans in an App Service Environment.
    #
    # Get all App Service plans in an App Service Environment.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the App Service Environment.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [AppServicePlanCollection] which provide lazy access to pages of the
    # response.
    #
    def list_app_service_plans_as_lazy(resource_group_name, name, custom_headers = nil)
      response = list_app_service_plans_async(resource_group_name, name, custom_headers).value!
      unless response.nil?
        page = response.body
        page.next_method = Proc.new do |next_page_link|
          list_app_service_plans_next_async(next_page_link, custom_headers)
        end
        page
      end
    end

    #
    # Get all apps in an App Service Environment.
    #
    # Get all apps in an App Service Environment.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the App Service Environment.
    # @param properties_to_include [String] Comma separated list of app properties
    # to include.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [WebAppCollection] which provide lazy access to pages of the
    # response.
    #
    def list_web_apps_as_lazy(resource_group_name, name, properties_to_include = nil, custom_headers = nil)
      response = list_web_apps_async(resource_group_name, name, properties_to_include, custom_headers).value!
      unless response.nil?
        page = response.body
        page.next_method = Proc.new do |next_page_link|
          list_web_apps_next_async(next_page_link, custom_headers)
        end
        page
      end
    end

    #
    # Get global usage metrics of an App Service Environment.
    #
    # Get global usage metrics of an App Service Environment.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the App Service Environment.
    # @param filter [String] Return only usages/metrics specified in the filter.
    # Filter conforms to odata syntax. Example: $filter=(name.value eq 'Metric1' or
    # name.value eq 'Metric2') and startTime eq '2014-01-01T00:00:00Z' and endTime
    # eq '2014-12-31T23:59:59Z' and timeGrain eq duration'[Hour|Minute|Day]'.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [CsmUsageQuotaCollection] which provide lazy access to pages of the
    # response.
    #
    def list_usages_as_lazy(resource_group_name, name, filter = nil, custom_headers = nil)
      response = list_usages_async(resource_group_name, name, filter, custom_headers).value!
      unless response.nil?
        page = response.body
        page.next_method = Proc.new do |next_page_link|
          list_usages_next_async(next_page_link, custom_headers)
        end
        page
      end
    end

    #
    # Get all worker pools of an App Service Environment.
    #
    # Get all worker pools of an App Service Environment.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the App Service Environment.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [WorkerPoolCollection] which provide lazy access to pages of the
    # response.
    #
    def list_worker_pools_as_lazy(resource_group_name, name, custom_headers = nil)
      response = list_worker_pools_async(resource_group_name, name, custom_headers).value!
      unless response.nil?
        page = response.body
        page.next_method = Proc.new do |next_page_link|
          list_worker_pools_next_async(next_page_link, custom_headers)
        end
        page
      end
    end

    #
    # Get metric definitions for a specific instance of a worker pool of an App
    # Service Environment.
    #
    # Get metric definitions for a specific instance of a worker pool of an App
    # Service Environment.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the App Service Environment.
    # @param worker_pool_name [String] Name of the worker pool.
    # @param instance [String] Name of the instance in the worker pool.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [ResourceMetricDefinitionCollection] which provide lazy access to
    # pages of the response.
    #
    def list_worker_pool_instance_metric_definitions_as_lazy(resource_group_name, name, worker_pool_name, instance, custom_headers = nil)
      response = list_worker_pool_instance_metric_definitions_async(resource_group_name, name, worker_pool_name, instance, custom_headers).value!
      unless response.nil?
        page = response.body
        page.next_method = Proc.new do |next_page_link|
          list_worker_pool_instance_metric_definitions_next_async(next_page_link, custom_headers)
        end
        page
      end
    end

    #
    # Get metrics for a specific instance of a worker pool of an App Service
    # Environment.
    #
    # Get metrics for a specific instance of a worker pool of an App Service
    # Environment.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the App Service Environment.
    # @param worker_pool_name [String] Name of the worker pool.
    # @param instance [String] Name of the instance in the worker pool.
    # @param details [Boolean] Specify <code>true</code> to include instance
    # details. The default is <code>false</code>.
    # @param filter [String] Return only usages/metrics specified in the filter.
    # Filter conforms to odata syntax. Example: $filter=(name.value eq 'Metric1' or
    # name.value eq 'Metric2') and startTime eq '2014-01-01T00:00:00Z' and endTime
    # eq '2014-12-31T23:59:59Z' and timeGrain eq duration'[Hour|Minute|Day]'.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [ResourceMetricCollection] which provide lazy access to pages of the
    # response.
    #
    def list_worker_pool_instance_metrics_as_lazy(resource_group_name, name, worker_pool_name, instance, details = nil, filter = nil, custom_headers = nil)
      response = list_worker_pool_instance_metrics_async(resource_group_name, name, worker_pool_name, instance, details, filter, custom_headers).value!
      unless response.nil?
        page = response.body
        page.next_method = Proc.new do |next_page_link|
          list_worker_pool_instance_metrics_next_async(next_page_link, custom_headers)
        end
        page
      end
    end

    #
    # Get metric definitions for a worker pool of an App Service Environment.
    #
    # Get metric definitions for a worker pool of an App Service Environment.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the App Service Environment.
    # @param worker_pool_name [String] Name of the worker pool.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [ResourceMetricDefinitionCollection] which provide lazy access to
    # pages of the response.
    #
    def list_web_worker_metric_definitions_as_lazy(resource_group_name, name, worker_pool_name, custom_headers = nil)
      response = list_web_worker_metric_definitions_async(resource_group_name, name, worker_pool_name, custom_headers).value!
      unless response.nil?
        page = response.body
        page.next_method = Proc.new do |next_page_link|
          list_web_worker_metric_definitions_next_async(next_page_link, custom_headers)
        end
        page
      end
    end

    #
    # Get metrics for a worker pool of a AppServiceEnvironment (App Service
    # Environment).
    #
    # Get metrics for a worker pool of a AppServiceEnvironment (App Service
    # Environment).
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the App Service Environment.
    # @param worker_pool_name [String] Name of worker pool
    # @param details [Boolean] Specify <code>true</code> to include instance
    # details. The default is <code>false</code>.
    # @param filter [String] Return only usages/metrics specified in the filter.
    # Filter conforms to odata syntax. Example: $filter=(name.value eq 'Metric1' or
    # name.value eq 'Metric2') and startTime eq '2014-01-01T00:00:00Z' and endTime
    # eq '2014-12-31T23:59:59Z' and timeGrain eq duration'[Hour|Minute|Day]'.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [ResourceMetricCollection] which provide lazy access to pages of the
    # response.
    #
    def list_web_worker_metrics_as_lazy(resource_group_name, name, worker_pool_name, details = nil, filter = nil, custom_headers = nil)
      response = list_web_worker_metrics_async(resource_group_name, name, worker_pool_name, details, filter, custom_headers).value!
      unless response.nil?
        page = response.body
        page.next_method = Proc.new do |next_page_link|
          list_web_worker_metrics_next_async(next_page_link, custom_headers)
        end
        page
      end
    end

    #
    # Get available SKUs for scaling a worker pool.
    #
    # Get available SKUs for scaling a worker pool.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the App Service Environment.
    # @param worker_pool_name [String] Name of the worker pool.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [SkuInfoCollection] which provide lazy access to pages of the
    # response.
    #
    def list_worker_pool_skus_as_lazy(resource_group_name, name, worker_pool_name, custom_headers = nil)
      response = list_worker_pool_skus_async(resource_group_name, name, worker_pool_name, custom_headers).value!
      unless response.nil?
        page = response.body
        page.next_method = Proc.new do |next_page_link|
          list_worker_pool_skus_next_async(next_page_link, custom_headers)
        end
        page
      end
    end

    #
    # Get usage metrics for a worker pool of an App Service Environment.
    #
    # Get usage metrics for a worker pool of an App Service Environment.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the App Service Environment.
    # @param worker_pool_name [String] Name of the worker pool.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [UsageCollection] which provide lazy access to pages of the response.
    #
    def list_web_worker_usages_as_lazy(resource_group_name, name, worker_pool_name, custom_headers = nil)
      response = list_web_worker_usages_async(resource_group_name, name, worker_pool_name, custom_headers).value!
      unless response.nil?
        page = response.body
        page.next_method = Proc.new do |next_page_link|
          list_web_worker_usages_next_async(next_page_link, custom_headers)
        end
        page
      end
    end

    #
    # Resume an App Service Environment.
    #
    # Resume an App Service Environment.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the App Service Environment.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [WebAppCollection] which provide lazy access to pages of the
    # response.
    #
    def begin_resume_as_lazy(resource_group_name, name, custom_headers = nil)
      response = begin_resume_async(resource_group_name, name, custom_headers).value!
      unless response.nil?
        page = response.body
        page.next_method = Proc.new do |next_page_link|
          begin_resume_next_async(next_page_link, custom_headers)
        end
        page
      end
    end

    #
    # Suspend an App Service Environment.
    #
    # Suspend an App Service Environment.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param name [String] Name of the App Service Environment.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [WebAppCollection] which provide lazy access to pages of the
    # response.
    #
    def begin_suspend_as_lazy(resource_group_name, name, custom_headers = nil)
      response = begin_suspend_async(resource_group_name, name, custom_headers).value!
      unless response.nil?
        page = response.body
        page.next_method = Proc.new do |next_page_link|
          begin_suspend_next_async(next_page_link, custom_headers)
        end
        page
      end
    end

  end
end
