# encoding: utf-8
# Code generated by Microsoft (R) AutoRest Code Generator 1.2.2.0
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.

module Azure::ARM::Web
  #
  # A service client - single point of access to the REST API.
  #
  class WebSiteManagementClient < MsRestAzure::AzureServiceClient
    include MsRestAzure
    include MsRestAzure::Serialization

    # @return [String] the base URI of the service.
    attr_accessor :base_url

    # @return Credentials needed for the client to connect to Azure.
    attr_reader :credentials

    # @return [String] Your Azure subscription ID. This is a GUID-formatted
    # string (e.g. 00000000-0000-0000-0000-000000000000).
    attr_accessor :subscription_id

    # @return [String] Gets or sets the preferred language for the response.
    attr_accessor :accept_language

    # @return [Integer] Gets or sets the retry timeout in seconds for Long
    # Running Operations. Default value is 30.
    attr_accessor :long_running_operation_retry_timeout

    # @return [Boolean] When set to true a unique x-ms-client-request-id value
    # is generated and included in each request. Default is true.
    attr_accessor :generate_client_request_id

    # @return [AppServiceCertificateOrders] app_service_certificate_orders
    attr_reader :app_service_certificate_orders

    # @return [Domains] domains
    attr_reader :domains

    # @return [TopLevelDomains] top_level_domains
    attr_reader :top_level_domains

    # @return [Certificates] certificates
    attr_reader :certificates

    # @return [DeletedWebApps] deleted_web_apps
    attr_reader :deleted_web_apps

    # @return [Provider] provider
    attr_reader :provider

    # @return [Recommendations] recommendations
    attr_reader :recommendations

    # @return [WebApps] web_apps
    attr_reader :web_apps

    # @return [AppServiceEnvironments] app_service_environments
    attr_reader :app_service_environments

    # @return [AppServicePlans] app_service_plans
    attr_reader :app_service_plans

    #
    # Creates initializes a new instance of the WebSiteManagementClient class.
    # @param credentials [MsRest::ServiceClientCredentials] credentials to authorize HTTP requests made by the service client.
    # @param base_url [String] the base URI of the service.
    # @param options [Array] filters to be applied to the HTTP requests.
    #
    def initialize(credentials = nil, base_url = nil, options = nil)
      super(credentials, options)
      @base_url = base_url || 'https://management.azure.com'

      fail ArgumentError, 'invalid type of credentials input parameter' unless credentials.is_a?(MsRest::ServiceClientCredentials) unless credentials.nil?
      @credentials = credentials

      @app_service_certificate_orders = AppServiceCertificateOrders.new(self)
      @domains = Domains.new(self)
      @top_level_domains = TopLevelDomains.new(self)
      @certificates = Certificates.new(self)
      @deleted_web_apps = DeletedWebApps.new(self)
      @provider = Provider.new(self)
      @recommendations = Recommendations.new(self)
      @web_apps = WebApps.new(self)
      @app_service_environments = AppServiceEnvironments.new(self)
      @app_service_plans = AppServicePlans.new(self)
      @accept_language = 'en-US'
      @long_running_operation_retry_timeout = 30
      @generate_client_request_id = true
      add_telemetry
    end

    #
    # Makes a request and returns the body of the response.
    # @param method [Symbol] with any of the following values :get, :put, :post, :patch, :delete.
    # @param path [String] the path, relative to {base_url}.
    # @param options [Hash{String=>String}] specifying any request options like :body.
    # @return [Hash{String=>String}] containing the body of the response.
    # Example:
    #
    #  request_content = "{'location':'westus','tags':{'tag1':'val1','tag2':'val2'}}"
    #  path = "/path"
    #  options = {
    #    body: request_content,
    #    query_params: {'api-version' => '2016-02-01'}
    #  }
    #  result = @client.make_request(:put, path, options)
    #
    def make_request(method, path, options = {})
      result = make_request_with_http_info(method, path, options)
      result.body unless result.nil?
    end

    #
    # Makes a request and returns the operation response.
    # @param method [Symbol] with any of the following values :get, :put, :post, :patch, :delete.
    # @param path [String] the path, relative to {base_url}.
    # @param options [Hash{String=>String}] specifying any request options like :body.
    # @return [MsRestAzure::AzureOperationResponse] Operation response containing the request, response and status.
    #
    def make_request_with_http_info(method, path, options = {})
      result = make_request_async(method, path, options).value!
      result.body = result.response.body.to_s.empty? ? nil : JSON.load(result.response.body)
      result
    end

    #
    # Makes a request asynchronously.
    # @param method [Symbol] with any of the following values :get, :put, :post, :patch, :delete.
    # @param path [String] the path, relative to {base_url}.
    # @param options [Hash{String=>String}] specifying any request options like :body.
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def make_request_async(method, path, options = {})
      fail ArgumentError, 'method is nil' if method.nil?
      fail ArgumentError, 'path is nil' if path.nil?

      request_url = options[:base_url] || @base_url

      request_headers = @request_headers
      request_headers.merge!({'accept-language' => @accept_language}) unless @accept_language.nil?
      options.merge!({headers: request_headers.merge(options[:headers] || {})})
      options.merge!({credentials: @credentials}) unless @credentials.nil?

      super(request_url, method, path, options)
    end

    #
    # Gets publishing user
    #
    # Gets publishing user
    #
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [User] operation results.
    #
    def get_publishing_user(custom_headers = nil)
      response = get_publishing_user_async(custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets publishing user
    #
    # Gets publishing user
    #
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_publishing_user_with_http_info(custom_headers = nil)
      get_publishing_user_async(custom_headers).value!
    end

    #
    # Gets publishing user
    #
    # Gets publishing user
    #
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_publishing_user_async(custom_headers = nil)
      api_version = '2016-03-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = accept_language unless accept_language.nil?
      path_template = 'providers/Microsoft.Web/publishingUsers/web'

      request_url = @base_url || self.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = self.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::User.mapper()
            result.body = self.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Updates publishing user
    #
    # Updates publishing user
    #
    # @param user_details [User] Details of publishing user
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [User] operation results.
    #
    def update_publishing_user(user_details, custom_headers = nil)
      response = update_publishing_user_async(user_details, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Updates publishing user
    #
    # Updates publishing user
    #
    # @param user_details [User] Details of publishing user
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def update_publishing_user_with_http_info(user_details, custom_headers = nil)
      update_publishing_user_async(user_details, custom_headers).value!
    end

    #
    # Updates publishing user
    #
    # Updates publishing user
    #
    # @param user_details [User] Details of publishing user
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def update_publishing_user_async(user_details, custom_headers = nil)
      fail ArgumentError, 'user_details is nil' if user_details.nil?
      api_version = '2016-03-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = accept_language unless accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = Azure::ARM::Web::Models::User.mapper()
      request_content = self.serialize(request_mapper,  user_details)
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = 'providers/Microsoft.Web/publishingUsers/web'

      request_url = @base_url || self.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          query_params: {'api-version' => api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = self.make_request_async(:put, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::User.mapper()
            result.body = self.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Gets the source controls available for Azure websites.
    #
    # Gets the source controls available for Azure websites.
    #
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array<SourceControl>] operation results.
    #
    def list_source_controls(custom_headers = nil)
      first_page = list_source_controls_as_lazy(custom_headers)
      first_page.get_all_items
    end

    #
    # Gets the source controls available for Azure websites.
    #
    # Gets the source controls available for Azure websites.
    #
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_source_controls_with_http_info(custom_headers = nil)
      list_source_controls_async(custom_headers).value!
    end

    #
    # Gets the source controls available for Azure websites.
    #
    # Gets the source controls available for Azure websites.
    #
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_source_controls_async(custom_headers = nil)
      api_version = '2016-03-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = accept_language unless accept_language.nil?
      path_template = 'providers/Microsoft.Web/sourcecontrols'

      request_url = @base_url || self.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = self.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::SourceControlCollection.mapper()
            result.body = self.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Updates source control token
    #
    # Updates source control token
    #
    # @param source_control_type [String] Type of source control
    # @param request_message [SourceControl] Source control token information
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [SourceControl] operation results.
    #
    def update_source_control(source_control_type, request_message, custom_headers = nil)
      response = update_source_control_async(source_control_type, request_message, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Updates source control token
    #
    # Updates source control token
    #
    # @param source_control_type [String] Type of source control
    # @param request_message [SourceControl] Source control token information
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def update_source_control_with_http_info(source_control_type, request_message, custom_headers = nil)
      update_source_control_async(source_control_type, request_message, custom_headers).value!
    end

    #
    # Updates source control token
    #
    # Updates source control token
    #
    # @param source_control_type [String] Type of source control
    # @param request_message [SourceControl] Source control token information
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def update_source_control_async(source_control_type, request_message, custom_headers = nil)
      fail ArgumentError, 'source_control_type is nil' if source_control_type.nil?
      fail ArgumentError, 'request_message is nil' if request_message.nil?
      api_version = '2016-03-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = accept_language unless accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = Azure::ARM::Web::Models::SourceControl.mapper()
      request_content = self.serialize(request_mapper,  request_message)
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = 'providers/Microsoft.Web/sourcecontrols/{sourceControlType}'

      request_url = @base_url || self.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'sourceControlType' => source_control_type},
          query_params: {'api-version' => api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = self.make_request_async(:put, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::SourceControl.mapper()
            result.body = self.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Check if a resource name is available.
    #
    # Check if a resource name is available.
    #
    # @param name [String] Resource name to verify.
    # @param type [CheckNameResourceTypes] Resource type used for verification.
    # Possible values include: 'Site', 'Slot', 'HostingEnvironment'
    # @param is_fqdn [Boolean] Is fully qualified domain name.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [ResourceNameAvailability] operation results.
    #
    def check_name_availability(name, type, is_fqdn = nil, custom_headers = nil)
      response = check_name_availability_async(name, type, is_fqdn, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Check if a resource name is available.
    #
    # Check if a resource name is available.
    #
    # @param name [String] Resource name to verify.
    # @param type [CheckNameResourceTypes] Resource type used for verification.
    # Possible values include: 'Site', 'Slot', 'HostingEnvironment'
    # @param is_fqdn [Boolean] Is fully qualified domain name.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def check_name_availability_with_http_info(name, type, is_fqdn = nil, custom_headers = nil)
      check_name_availability_async(name, type, is_fqdn, custom_headers).value!
    end

    #
    # Check if a resource name is available.
    #
    # Check if a resource name is available.
    #
    # @param name [String] Resource name to verify.
    # @param type [CheckNameResourceTypes] Resource type used for verification.
    # Possible values include: 'Site', 'Slot', 'HostingEnvironment'
    # @param is_fqdn [Boolean] Is fully qualified domain name.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def check_name_availability_async(name, type, is_fqdn = nil, custom_headers = nil)
      fail ArgumentError, 'subscription_id is nil' if subscription_id.nil?
      api_version = '2016-03-01'
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'type is nil' if type.nil?

      request = ResourceNameAvailabilityRequest.new
      unless name.nil? && type.nil? && is_fqdn.nil?
        request.name = name
        request.type = type
        request.is_fqdn = is_fqdn
      end

      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = accept_language unless accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = Azure::ARM::Web::Models::ResourceNameAvailabilityRequest.mapper()
      request_content = self.serialize(request_mapper,  request)
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = 'subscriptions/{subscriptionId}/providers/Microsoft.Web/checknameavailability'

      request_url = @base_url || self.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'subscriptionId' => subscription_id},
          query_params: {'api-version' => api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = self.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::ResourceNameAvailability.mapper()
            result.body = self.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Get a list of available geographical regions.
    #
    # Get a list of available geographical regions.
    #
    # @param sku [SkuName] Name of SKU used to filter the regions. Possible values
    # include: 'Free', 'Shared', 'Basic', 'Standard', 'Premium', 'Dynamic',
    # 'Isolated'
    # @param linux_workers_enabled [Boolean] Specify <code>true</code> if you want
    # to filter to only regions that support Linux workers.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array<GeoRegion>] operation results.
    #
    def list_geo_regions(sku = nil, linux_workers_enabled = nil, custom_headers = nil)
      first_page = list_geo_regions_as_lazy(sku, linux_workers_enabled, custom_headers)
      first_page.get_all_items
    end

    #
    # Get a list of available geographical regions.
    #
    # Get a list of available geographical regions.
    #
    # @param sku [SkuName] Name of SKU used to filter the regions. Possible values
    # include: 'Free', 'Shared', 'Basic', 'Standard', 'Premium', 'Dynamic',
    # 'Isolated'
    # @param linux_workers_enabled [Boolean] Specify <code>true</code> if you want
    # to filter to only regions that support Linux workers.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_geo_regions_with_http_info(sku = nil, linux_workers_enabled = nil, custom_headers = nil)
      list_geo_regions_async(sku, linux_workers_enabled, custom_headers).value!
    end

    #
    # Get a list of available geographical regions.
    #
    # Get a list of available geographical regions.
    #
    # @param sku [SkuName] Name of SKU used to filter the regions. Possible values
    # include: 'Free', 'Shared', 'Basic', 'Standard', 'Premium', 'Dynamic',
    # 'Isolated'
    # @param linux_workers_enabled [Boolean] Specify <code>true</code> if you want
    # to filter to only regions that support Linux workers.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_geo_regions_async(sku = nil, linux_workers_enabled = nil, custom_headers = nil)
      fail ArgumentError, 'subscription_id is nil' if subscription_id.nil?
      api_version = '2016-03-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = accept_language unless accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/providers/Microsoft.Web/geoRegions'

      request_url = @base_url || self.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'subscriptionId' => subscription_id},
          query_params: {'sku' => sku,'linuxWorkersEnabled' => linux_workers_enabled,'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = self.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::GeoRegionCollection.mapper()
            result.body = self.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # List all premier add-on offers.
    #
    # List all premier add-on offers.
    #
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array<PremierAddOnOffer>] operation results.
    #
    def list_premier_add_on_offers(custom_headers = nil)
      first_page = list_premier_add_on_offers_as_lazy(custom_headers)
      first_page.get_all_items
    end

    #
    # List all premier add-on offers.
    #
    # List all premier add-on offers.
    #
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_premier_add_on_offers_with_http_info(custom_headers = nil)
      list_premier_add_on_offers_async(custom_headers).value!
    end

    #
    # List all premier add-on offers.
    #
    # List all premier add-on offers.
    #
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_premier_add_on_offers_async(custom_headers = nil)
      fail ArgumentError, 'subscription_id is nil' if subscription_id.nil?
      api_version = '2016-03-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = accept_language unless accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/providers/Microsoft.Web/premieraddonoffers'

      request_url = @base_url || self.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'subscriptionId' => subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = self.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::PremierAddOnOfferCollection.mapper()
            result.body = self.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # List all SKUs.
    #
    # List all SKUs.
    #
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [SkuInfos] operation results.
    #
    def list_skus(custom_headers = nil)
      response = list_skus_async(custom_headers).value!
      response.body unless response.nil?
    end

    #
    # List all SKUs.
    #
    # List all SKUs.
    #
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_skus_with_http_info(custom_headers = nil)
      list_skus_async(custom_headers).value!
    end

    #
    # List all SKUs.
    #
    # List all SKUs.
    #
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_skus_async(custom_headers = nil)
      fail ArgumentError, 'subscription_id is nil' if subscription_id.nil?
      api_version = '2016-03-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = accept_language unless accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/providers/Microsoft.Web/skus'

      request_url = @base_url || self.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'subscriptionId' => subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = self.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::SkuInfos.mapper()
            result.body = self.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Move resources between resource groups.
    #
    # Move resources between resource groups.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param move_resource_envelope [CsmMoveResourceEnvelope] Object that
    # represents the resource to move.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    #
    def move(resource_group_name, move_resource_envelope, custom_headers = nil)
      response = move_async(resource_group_name, move_resource_envelope, custom_headers).value!
      nil
    end

    #
    # Move resources between resource groups.
    #
    # Move resources between resource groups.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param move_resource_envelope [CsmMoveResourceEnvelope] Object that
    # represents the resource to move.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def move_with_http_info(resource_group_name, move_resource_envelope, custom_headers = nil)
      move_async(resource_group_name, move_resource_envelope, custom_headers).value!
    end

    #
    # Move resources between resource groups.
    #
    # Move resources between resource groups.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param move_resource_envelope [CsmMoveResourceEnvelope] Object that
    # represents the resource to move.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def move_async(resource_group_name, move_resource_envelope, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'move_resource_envelope is nil' if move_resource_envelope.nil?
      fail ArgumentError, 'subscription_id is nil' if subscription_id.nil?
      api_version = '2016-03-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = accept_language unless accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = Azure::ARM::Web::Models::CsmMoveResourceEnvelope.mapper()
      request_content = self.serialize(request_mapper,  move_resource_envelope)
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/moveResources'

      request_url = @base_url || self.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'subscriptionId' => subscription_id},
          query_params: {'api-version' => api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = self.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 204
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Validate if a resource can be created.
    #
    # Validate if a resource can be created.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param validate_request [ValidateRequest] Request with the resources to
    # validate.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [ValidateResponse] operation results.
    #
    def validate(resource_group_name, validate_request, custom_headers = nil)
      response = validate_async(resource_group_name, validate_request, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Validate if a resource can be created.
    #
    # Validate if a resource can be created.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param validate_request [ValidateRequest] Request with the resources to
    # validate.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def validate_with_http_info(resource_group_name, validate_request, custom_headers = nil)
      validate_async(resource_group_name, validate_request, custom_headers).value!
    end

    #
    # Validate if a resource can be created.
    #
    # Validate if a resource can be created.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param validate_request [ValidateRequest] Request with the resources to
    # validate.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def validate_async(resource_group_name, validate_request, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'validate_request is nil' if validate_request.nil?
      fail ArgumentError, 'subscription_id is nil' if subscription_id.nil?
      api_version = '2016-03-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = accept_language unless accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = Azure::ARM::Web::Models::ValidateRequest.mapper()
      request_content = self.serialize(request_mapper,  validate_request)
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/validate'

      request_url = @base_url || self.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'subscriptionId' => subscription_id},
          query_params: {'api-version' => api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = self.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::ValidateResponse.mapper()
            result.body = self.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Validate whether a resource can be moved.
    #
    # Validate whether a resource can be moved.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param move_resource_envelope [CsmMoveResourceEnvelope] Object that
    # represents the resource to move.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    #
    def validate_move(resource_group_name, move_resource_envelope, custom_headers = nil)
      response = validate_move_async(resource_group_name, move_resource_envelope, custom_headers).value!
      nil
    end

    #
    # Validate whether a resource can be moved.
    #
    # Validate whether a resource can be moved.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param move_resource_envelope [CsmMoveResourceEnvelope] Object that
    # represents the resource to move.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def validate_move_with_http_info(resource_group_name, move_resource_envelope, custom_headers = nil)
      validate_move_async(resource_group_name, move_resource_envelope, custom_headers).value!
    end

    #
    # Validate whether a resource can be moved.
    #
    # Validate whether a resource can be moved.
    #
    # @param resource_group_name [String] Name of the resource group to which the
    # resource belongs.
    # @param move_resource_envelope [CsmMoveResourceEnvelope] Object that
    # represents the resource to move.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def validate_move_async(resource_group_name, move_resource_envelope, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'move_resource_envelope is nil' if move_resource_envelope.nil?
      fail ArgumentError, 'subscription_id is nil' if subscription_id.nil?
      api_version = '2016-03-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = accept_language unless accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = Azure::ARM::Web::Models::CsmMoveResourceEnvelope.mapper()
      request_content = self.serialize(request_mapper,  move_resource_envelope)
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/validateMoveResources'

      request_url = @base_url || self.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'subscriptionId' => subscription_id},
          query_params: {'api-version' => api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = self.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 204
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Gets the source controls available for Azure websites.
    #
    # Gets the source controls available for Azure websites.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [SourceControlCollection] operation results.
    #
    def list_source_controls_next(next_page_link, custom_headers = nil)
      response = list_source_controls_next_async(next_page_link, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets the source controls available for Azure websites.
    #
    # Gets the source controls available for Azure websites.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_source_controls_next_with_http_info(next_page_link, custom_headers = nil)
      list_source_controls_next_async(next_page_link, custom_headers).value!
    end

    #
    # Gets the source controls available for Azure websites.
    #
    # Gets the source controls available for Azure websites.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_source_controls_next_async(next_page_link, custom_headers = nil)
      fail ArgumentError, 'next_page_link is nil' if next_page_link.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = accept_language unless accept_language.nil?
      path_template = '{nextLink}'

      request_url = @base_url || self.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          skip_encoding_path_params: {'nextLink' => next_page_link},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = self.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::SourceControlCollection.mapper()
            result.body = self.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Get a list of available geographical regions.
    #
    # Get a list of available geographical regions.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [GeoRegionCollection] operation results.
    #
    def list_geo_regions_next(next_page_link, custom_headers = nil)
      response = list_geo_regions_next_async(next_page_link, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Get a list of available geographical regions.
    #
    # Get a list of available geographical regions.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_geo_regions_next_with_http_info(next_page_link, custom_headers = nil)
      list_geo_regions_next_async(next_page_link, custom_headers).value!
    end

    #
    # Get a list of available geographical regions.
    #
    # Get a list of available geographical regions.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_geo_regions_next_async(next_page_link, custom_headers = nil)
      fail ArgumentError, 'next_page_link is nil' if next_page_link.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = accept_language unless accept_language.nil?
      path_template = '{nextLink}'

      request_url = @base_url || self.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          skip_encoding_path_params: {'nextLink' => next_page_link},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = self.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::GeoRegionCollection.mapper()
            result.body = self.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # List all premier add-on offers.
    #
    # List all premier add-on offers.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [PremierAddOnOfferCollection] operation results.
    #
    def list_premier_add_on_offers_next(next_page_link, custom_headers = nil)
      response = list_premier_add_on_offers_next_async(next_page_link, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # List all premier add-on offers.
    #
    # List all premier add-on offers.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_premier_add_on_offers_next_with_http_info(next_page_link, custom_headers = nil)
      list_premier_add_on_offers_next_async(next_page_link, custom_headers).value!
    end

    #
    # List all premier add-on offers.
    #
    # List all premier add-on offers.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_premier_add_on_offers_next_async(next_page_link, custom_headers = nil)
      fail ArgumentError, 'next_page_link is nil' if next_page_link.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = accept_language unless accept_language.nil?
      path_template = '{nextLink}'

      request_url = @base_url || self.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          skip_encoding_path_params: {'nextLink' => next_page_link},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = self.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::PremierAddOnOfferCollection.mapper()
            result.body = self.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Gets the source controls available for Azure websites.
    #
    # Gets the source controls available for Azure websites.
    #
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [SourceControlCollection] operation results.
    #
    def list_source_controls_as_lazy(custom_headers = nil)
      first_page = list_source_controls_as_lazy_as_lazy(custom_headers)
      first_page.get_all_items
    end

    #
    # Gets the source controls available for Azure websites.
    #
    # Gets the source controls available for Azure websites.
    #
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_source_controls_as_lazy_with_http_info(custom_headers = nil)
      list_source_controls_as_lazy_async(custom_headers).value!
    end

    #
    # Gets the source controls available for Azure websites.
    #
    # Gets the source controls available for Azure websites.
    #
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_source_controls_as_lazy_async(custom_headers = nil)
      api_version = '2016-03-01'


      request_headers = {}
      path_template = 'providers/Microsoft.Web/sourcecontrols'

      request_url = @base_url || self.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = self.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::SourceControlCollection.mapper()
            result.body = self.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Get a list of available geographical regions.
    #
    # Get a list of available geographical regions.
    #
    # @param sku [SkuName] Name of SKU used to filter the regions. Possible values
    # include: 'Free', 'Shared', 'Basic', 'Standard', 'Premium', 'Dynamic',
    # 'Isolated'
    # @param linux_workers_enabled [Boolean] Specify <code>true</code> if you want
    # to filter to only regions that support Linux workers.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [GeoRegionCollection] operation results.
    #
    def list_geo_regions_as_lazy(sku = nil, linux_workers_enabled = nil, custom_headers = nil)
      first_page = list_geo_regions_as_lazy_as_lazy(sku, linux_workers_enabled, custom_headers)
      first_page.get_all_items
    end

    #
    # Get a list of available geographical regions.
    #
    # Get a list of available geographical regions.
    #
    # @param sku [SkuName] Name of SKU used to filter the regions. Possible values
    # include: 'Free', 'Shared', 'Basic', 'Standard', 'Premium', 'Dynamic',
    # 'Isolated'
    # @param linux_workers_enabled [Boolean] Specify <code>true</code> if you want
    # to filter to only regions that support Linux workers.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_geo_regions_as_lazy_with_http_info(sku = nil, linux_workers_enabled = nil, custom_headers = nil)
      list_geo_regions_as_lazy_async(sku, linux_workers_enabled, custom_headers).value!
    end

    #
    # Get a list of available geographical regions.
    #
    # Get a list of available geographical regions.
    #
    # @param sku [SkuName] Name of SKU used to filter the regions. Possible values
    # include: 'Free', 'Shared', 'Basic', 'Standard', 'Premium', 'Dynamic',
    # 'Isolated'
    # @param linux_workers_enabled [Boolean] Specify <code>true</code> if you want
    # to filter to only regions that support Linux workers.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_geo_regions_as_lazy_async(sku = nil, linux_workers_enabled = nil, custom_headers = nil)
      api_version = '2016-03-01'


      request_headers = {}
      path_template = 'subscriptions/{subscriptionId}/providers/Microsoft.Web/geoRegions'

      request_url = @base_url || self.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          query_params: {'sku' => sku,'linuxWorkersEnabled' => linux_workers_enabled,'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = self.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::GeoRegionCollection.mapper()
            result.body = self.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # List all premier add-on offers.
    #
    # List all premier add-on offers.
    #
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [PremierAddOnOfferCollection] operation results.
    #
    def list_premier_add_on_offers_as_lazy(custom_headers = nil)
      first_page = list_premier_add_on_offers_as_lazy_as_lazy(custom_headers)
      first_page.get_all_items
    end

    #
    # List all premier add-on offers.
    #
    # List all premier add-on offers.
    #
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_premier_add_on_offers_as_lazy_with_http_info(custom_headers = nil)
      list_premier_add_on_offers_as_lazy_async(custom_headers).value!
    end

    #
    # List all premier add-on offers.
    #
    # List all premier add-on offers.
    #
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_premier_add_on_offers_as_lazy_async(custom_headers = nil)
      api_version = '2016-03-01'


      request_headers = {}
      path_template = 'subscriptions/{subscriptionId}/providers/Microsoft.Web/premieraddonoffers'

      request_url = @base_url || self.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = self.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::Web::Models::PremierAddOnOfferCollection.mapper()
            result.body = self.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end


    private
    #
    # Adds telemetry information.
    #
    def add_telemetry
        sdk_information = 'azure_mgmt_web'
        if defined? Azure::ARM::Web::VERSION
          sdk_information = "#{sdk_information}/#{Azure::ARM::Web::VERSION}"
        end
        add_user_agent_information(sdk_information)
    end
  end
end
